/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public final class DocBaseNodeFactory
implements NodeFactory {
    private static RequestProcessor RP = new RequestProcessor();

    public NodeList createNodes(Project project) {
        WebProject webProject = (WebProject)project.getLookup().lookup(WebProject.class);
        assert (webProject != null);
        return new DocBaseNodeList(webProject);
    }

    static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final SourceGroup sourceGroup;

        public VisibilityQueryDataFilter(SourceGroup sourceGroup) {
            this.sourceGroup = sourceGroup;
            if (this.sourceGroup != null) {
                this.sourceGroup.addPropertyChangeListener((PropertyChangeListener)this);
            }
            VisibilityQuery visibilityQuery = VisibilityQuery.getDefault();
            visibilityQuery.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)visibilityQuery));
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return (this.sourceGroup == null || this.sourceGroup.contains(fileObject)) && VisibilityQuery.getDefault().isVisible(fileObject);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.changeSupport.fireChange();
        }
    }

    private static abstract class BaseNode
    extends FilterNode {
        private static Image WEB_PAGES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/webPagesBadge.gif");
        private static final String JAVA_MIME_TYPE = "text/x-java";
        private Action[] actions;
        protected final WebProject project;

        BaseNode(DataFolder dataFolder, WebProject webProject, VisibilityQueryDataFilter visibilityQueryDataFilter) {
            super(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren((DataFilter)visibilityQueryDataFilter));
            this.project = webProject;
        }

        public Image getIcon(int n) {
            return this.computeIcon(false, n);
        }

        public Image getOpenedIcon(int n) {
            return this.computeIcon(true, n);
        }

        private Node getDataFolderNodeDelegate() {
            return ((DataFolder)this.getLookup().lookup(DataFolder.class)).getNodeDelegate();
        }

        private Image computeIcon(boolean bl, int n) {
            Image image = bl ? this.getDataFolderNodeDelegate().getOpenedIcon(n) : this.getDataFolderNodeDelegate().getIcon(n);
            image = ImageUtilities.mergeImages((Image)image, (Image)WEB_PAGES_BADGE, (int)7, (int)7);
            return image;
        }

        public boolean canRename() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                this.actions = new Action[9];
                this.actions[0] = CommonProjectActions.newFileAction();
                this.actions[1] = null;
                this.actions[2] = SystemAction.get(FindAction.class);
                this.actions[3] = null;
                this.actions[4] = SystemAction.get(PasteAction.class);
                this.actions[5] = null;
                this.actions[6] = SystemAction.get(FileSystemAction.class);
                this.actions[7] = null;
                this.actions[8] = ProjectUISupport.createPreselectPropertiesAction((Project)this.project, (String)"Sources", null);
            }
            return this.actions;
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            try {
                Object object;
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (object = transferable.getTransferData(DataFlavor.javaFileListFlavor)) != null) {
                    List list = (List)object;
                    for (Object e : list) {
                        File file = FileUtil.normalizeFile((File)((File)e));
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        if (fileObject == null || !JAVA_MIME_TYPE.equals(fileObject.getMIMEType())) continue;
                        return null;
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return super.getDropType(transferable, n, n2);
        }
    }

    private static final class WebInfNode
    extends BaseNode {
        WebInfNode(DataFolder dataFolder, WebProject webProject, VisibilityQueryDataFilter visibilityQueryDataFilter) {
            super(dataFolder, webProject, visibilityQueryDataFilter);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DocBaseNodeFactory.class, (String)"LBL_Node_WebInf");
        }
    }

    private static final class DocBaseNode
    extends BaseNode {
        DocBaseNode(DataFolder dataFolder, WebProject webProject, VisibilityQueryDataFilter visibilityQueryDataFilter) {
            super(dataFolder, webProject, visibilityQueryDataFilter);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DocBaseNodeFactory.class, (String)"LBL_Node_DocBase");
        }
    }

    private static class DocBaseNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String DOC_BASE = "docBase";
        private static final String WEB_INF = "webInf";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyEvaluator evaluator;
        private final UpdateHelper helper;
        private SourceGroup webDocRoot;

        DocBaseNodeList(WebProject webProject) {
            this.project = webProject;
            this.evaluator = this.project.evaluator();
            this.helper = this.project.getUpdateHelper();
            Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
            assert (sources != null);
            if (sources.getSourceGroups("doc_root").length > 0) {
                this.webDocRoot = sources.getSourceGroups("doc_root")[0];
            } else {
                String string = ProjectUtils.getInformation((Project)webProject).getDisplayName();
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DocBaseNodeList.class, (String)"LBL_No_Source_Groups_Found", (Object)string), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }

        public List<String> keys() {
            FolderHolder folderHolder = this.getNodeFolders();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(DOC_BASE + this.getFolderPath(folderHolder.getWebDocBaseDir()));
            if (!folderHolder.hasCorrectStructure()) {
                arrayList.add(WEB_INF + this.getFolderPath(folderHolder.getWebInfDir()));
            }
            return arrayList;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public Node node(String string) {
            FolderHolder folderHolder = this.getNodeFolders();
            if (string.startsWith(DOC_BASE)) {
                FileObject fileObject = folderHolder.getWebDocBaseDir();
                DataFolder dataFolder = this.getFolder(fileObject);
                if (dataFolder != null) {
                    return new DocBaseNode(dataFolder, this.project, new VisibilityQueryDataFilter(this.webDocRoot));
                }
                return null;
            }
            if (string.startsWith(WEB_INF)) {
                if (folderHolder.hasCorrectStructure()) {
                    return null;
                }
                FileObject fileObject = folderHolder.getWebInfDir();
                DataFolder dataFolder = this.getFolder(fileObject);
                if (dataFolder != null) {
                    return new WebInfNode(dataFolder, this.project, new VisibilityQueryDataFilter(null));
                }
                return null;
            }
            assert (false) : "No node for key: " + string;
            return null;
        }

        public void addNotify() {
            this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.evaluator.removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DocBaseNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private DataFolder getFolder(FileObject fileObject) {
            if (fileObject != null) {
                return DataFolder.findFolder((FileObject)fileObject);
            }
            return null;
        }

        private String getFolderPath(FileObject fileObject) {
            if (fileObject == null) {
                return "";
            }
            return fileObject.getPath();
        }

        private FileObject getFileObject(String string) {
            String string2 = this.evaluator.getProperty(string);
            if (string2 == null) {
                return null;
            }
            FileObject fileObject = this.helper.getAntProjectHelper().resolveFileObject(string2);
            return fileObject != null && fileObject.isValid() ? fileObject : null;
        }

        private FolderHolder getNodeFolders() {
            return (FolderHolder)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FolderHolder>(){

                public FolderHolder run() {
                    FileObject fileObject = DocBaseNodeList.this.getFileObject("web.docbase.dir");
                    FileObject fileObject2 = DocBaseNodeList.this.getFileObject("webinf.dir");
                    return new FolderHolder(fileObject, fileObject2);
                }
            });
        }

        private static final class FolderHolder {
            private final FileObject webDocBaseDir;
            private final FileObject webInfDir;

            public FolderHolder(FileObject fileObject, FileObject fileObject2) {
                this.webDocBaseDir = fileObject;
                this.webInfDir = fileObject2;
            }

            public FileObject getWebDocBaseDir() {
                return this.webDocBaseDir;
            }

            public FileObject getWebInfDir() {
                return this.webInfDir;
            }

            public boolean hasCorrectStructure() {
                if (this.webDocBaseDir == null || this.webInfDir == null) {
                    return false;
                }
                return FileUtil.isParentOf((FileObject)this.webDocBaseDir, (FileObject)this.webInfDir);
            }
        }
    }
}

