/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.j2ee.persistence.editor.completion.Utils;

public class CCParser {
    private static final int INIT = 0;
    private static final int NN = 1;
    private static final int ERROR = 2;
    private static final int NNNAME = 3;
    private static final int INNN = 4;
    private static final int ATTRNAME = 5;
    private static final int EQ = 6;
    private static final int ATTRVALUE = 7;
    private final CompilationController controller;

    CCParser(CompilationController controller) {
        this.controller = controller;
    }

    public CC parseAnnotation(int offset) {
        int nnStart = this.findAnnotationStart(offset);
        if (nnStart == -1) {
            return null;
        }
        return this.parseAnnotationOnOffset(nnStart);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CC parseAnnotationOnOffset(int offset) {
        int state = 0;
        TokenSequence ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.moveStart();
        if (ts.move(offset) == 0 && !ts.moveNext()) {
            ts.movePrevious();
        }
        Token titk = ts.token();
        JavaTokenId id = (JavaTokenId)titk.id();
        assert (id == JavaTokenId.AT);
        int nnstart = ts.offset();
        int nnend = -1;
        String nnName = null;
        String currAttrName = null;
        String currAttrValue = null;
        ArrayList<NNAttr> attrs = new ArrayList<NNAttr>(5);
        int eqOffset = -1;
        block30: do {
            if ((id = (JavaTokenId)titk.id()) == JavaTokenId.WHITESPACE || id == JavaTokenId.LINE_COMMENT || id == JavaTokenId.BLOCK_COMMENT || id == JavaTokenId.JAVADOC_COMMENT) {
                ts.moveNext();
                titk = ts.token();
                continue;
            }
            block0 : switch (state) {
                case 0: {
                    switch (id) {
                        case AT: {
                            state = 1;
                            break block0;
                        }
                    }
                    state = 2;
                    break;
                }
                case 1: {
                    switch (id) {
                        case IDENTIFIER: {
                            state = 3;
                            nnName = ((Object)titk.text()).toString();
                            break block0;
                        }
                    }
                    state = 2;
                    break;
                }
                case 3: {
                    switch (id) {
                        case LPAREN: {
                            state = 4;
                            break block0;
                        }
                        case IDENTIFIER: 
                        case DOT: {
                            nnName = nnName + ((Object)titk.text()).toString();
                            break block0;
                        }
                    }
                    nnend = nnstart + "@".length() + nnName.length();
                    return new CC(nnName, attrs, nnstart, nnend);
                }
                case 4: {
                    switch (id) {
                        case IDENTIFIER: {
                            currAttrName = ((Object)titk.text()).toString();
                            state = 5;
                            break block0;
                        }
                        case COMMA: {
                            break block0;
                        }
                    }
                    state = 2;
                    break;
                }
                case 5: {
                    switch (id) {
                        case EQ: {
                            state = 6;
                            eqOffset = ts.offset();
                            break block0;
                        }
                    }
                    state = 2;
                    break;
                }
                case 6: {
                    switch (id) {
                        case STRING_LITERAL: {
                            state = 4;
                            currAttrValue = Utils.unquote(((Object)titk.text()).toString());
                            attrs.add(new NNAttr(currAttrName, currAttrValue, ts.offset(), true));
                            break block0;
                        }
                        case IDENTIFIER: {
                            state = 4;
                            currAttrValue = ((Object)titk.text()).toString();
                            attrs.add(new NNAttr(currAttrName, currAttrValue, ts.offset(), false));
                            break block0;
                        }
                        case AT: {
                            CC nestedNN = this.parseAnnotationOnOffset(ts.offset());
                            attrs.add(new NNAttr(currAttrName, nestedNN, ts.offset(), false));
                            state = 4;
                            if (ts.move(nestedNN.getEndOffset()) == 0 && !ts.moveNext()) {
                                ts.movePrevious();
                            }
                            titk = ts.token();
                            continue block30;
                        }
                        default: {
                            attrs.add(new NNAttr(currAttrName, "", eqOffset + 1, false));
                            state = 4;
                        }
                    }
                }
            }
            if (state == 2) {
                nnend = ts.offset() + ((Object)titk.text()).toString().length();
                return new CC(nnName, attrs, nnstart, nnend);
            }
            if (!ts.moveNext()) {
                return null;
            }
            titk = ts.token();
        } while (titk != null);
        return null;
    }

    private int findAnnotationStart(int offset) {
        if (offset > 0) {
            int len;
            int parentCount = -100;
            TokenSequence ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            if (ts.move(offset) == 0 || !ts.moveNext()) {
                ts.movePrevious();
            }
            if ((len = offset - ts.offset()) > 0 && (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("string") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal")) && ts.token().length() >= len) {
                String prefix = ts.token().toString().substring(0, len);
                offset = ts.offset();
            }
            Token titk = ts.token();
            while (titk != null) {
                JavaTokenId id = (JavaTokenId)titk.id();
                if (id == JavaTokenId.RPAREN) {
                    if (parentCount == -100) {
                        parentCount = 0;
                    }
                    ++parentCount;
                } else if (id == JavaTokenId.LPAREN) {
                    if (parentCount == -100) {
                        parentCount = 0;
                    }
                    --parentCount;
                } else if (id == JavaTokenId.AT && (parentCount == -1 || parentCount == -100)) {
                    return ts.offset();
                }
                if (!ts.movePrevious()) break;
                titk = ts.token();
            }
        }
        return -1;
    }

    public class CC {
        private String name;
        private List<NNAttr> attributes;
        private int startOffset;
        private int endOffset;

        public CC(String name, List<NNAttr> attributes, int startOffset, int endOffset) {
            this.name = name;
            this.attributes = attributes;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String getName() {
            return this.name;
        }

        public List<NNAttr> getAttributesList() {
            return this.attributes;
        }

        public Map<String, Object> getAttributes() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (NNAttr nnattr : this.getAttributesList()) {
                map.put(nnattr.getName(), nnattr.getValue());
            }
            return map;
        }

        public NNAttr getAttributeForOffset(int offset) {
            NNAttr prevnn = null;
            for (NNAttr nnattr : this.getAttributesList()) {
                if (nnattr.getValueOffset() >= offset) {
                    prevnn = nnattr;
                    break;
                }
                prevnn = nnattr;
            }
            if (prevnn == null) {
                return null;
            }
            int nnEndOffset = prevnn.getValueOffset() + prevnn.getValue().toString().length() + (prevnn.isValueQuoted() ? 2 : 0);
            if (nnEndOffset >= offset && prevnn.getValueOffset() <= offset) {
                return prevnn;
            }
            return null;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String toString() {
            String text = "@" + this.getName() + " [" + this.getStartOffset() + " - " + this.getEndOffset() + "](";
            for (NNAttr nnattr : this.getAttributesList()) {
                String key = nnattr.getName();
                String value = nnattr.getValue().toString();
                text = text + key + "=" + value + " (" + nnattr.getValueOffset() + ") ,";
            }
            text = text.substring(0, text.length() - 1);
            text = text + ")";
            return text;
        }
    }

    public class NNAttr {
        private String name;
        private Object value;
        private int valueOffset;
        private boolean quoted;

        NNAttr(String name, Object value, int valueOffset, boolean quoted) {
            this.name = name;
            this.value = value;
            this.valueOffset = valueOffset;
            this.quoted = quoted;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        public boolean isValueQuoted() {
            return this.quoted;
        }
    }
}

