/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import javax.lang.model.element.ElementKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.editor.completion.CCParser;
import org.netbeans.modules.j2ee.persistence.editor.completion.CompletionContextResolver;
import org.netbeans.modules.j2ee.persistence.editor.completion.JPACompletionItem;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBCompletionContextResolver;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JPACodeCompletionProvider
implements CompletionProvider {
    private static final String EMPTY = "";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        return new AsyncCompletionTask((AsyncCompletionQuery)new JPACodeCompletionQuery(queryType, component, component.getSelectionStart(), true), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static int getRowFirstNonWhite(StyledDocument doc, int offset) throws BadLocationException {
        Element lineElement = doc.getParagraphElement(offset);
        int start = lineElement.getStartOffset();
        while (start + 1 < lineElement.getEndOffset()) {
            try {
                if (doc.getText(start, 1).charAt(0) != ' ') {
                    break;
                }
            }
            catch (BadLocationException ex) {
                throw (BadLocationException)new BadLocationException("calling getText(" + start + ", " + (start + 1) + ") on doc of length: " + doc.getLength(), start).initCause(ex);
            }
            ++start;
        }
        return start;
    }

    static int indexOfWhite(char[] line) {
        int i = line.length;
        while (--i > -1) {
            char c = line[i];
            if (!Character.isWhitespace(c)) continue;
            return i;
        }
        ExtSyntaxSupport f = new ExtSyntaxSupport(null);
        return -1;
    }

    private TreePath getCompletionTreePath(CompilationController controller, int curOffset, int queryType) throws IOException {
        controller.toPhase(JavaSource.Phase.PARSED);
        int offset = controller.getSnapshot().getEmbeddedOffset(curOffset);
        if (offset < 0) {
            return null;
        }
        boolean complQuery = (queryType & 1) != 0;
        String prefix = null;
        if (offset > 0) {
            TokenSequence ts;
            if (complQuery) {
                int len;
                ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                if (ts.move(offset) == 0 || !ts.moveNext()) {
                    ts.movePrevious();
                }
                if ((len = offset - ts.offset()) > 0 && (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("string") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal")) && ts.token().length() >= len) {
                    prefix = ts.token().toString().substring(0, len);
                    offset = ts.offset();
                }
            } else if (queryType == 2) {
                ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                ts.move(offset);
                if (!ts.moveNext()) {
                    ts.movePrevious();
                }
                if (ts.offset() == offset && ts.token().length() > 0 && (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("string") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal"))) {
                    ++offset;
                }
            }
        }
        TreePath path = controller.getTreeUtilities().pathFor(offset);
        return path;
    }

    private static boolean isJavaIdentifierPart(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCasePrefix(String prefix) {
        if (prefix == null || prefix.length() < 2 || prefix.charAt(0) == '\"') {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (!Character.isUpperCase(prefix.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public final class Context {
        private JTextComponent component;
        CompilationController controller;
        private int endOffset;
        private PersistenceUnit[] pus;
        private EntityMappings emaps;
        private boolean autoPopup;
        private String completedMemberName;
        private String completedMemberJavaClassName;
        private CCParser CCParser;
        private CCParser.CC parsednn = null;

        public Context(JTextComponent component, CompilationController controller, int endOffset, boolean autoPopup) {
            this.component = component;
            this.controller = controller;
            this.endOffset = endOffset;
            this.autoPopup = autoPopup;
            FileObject documentFO = this.getFileObject();
            if (documentFO != null) {
                try {
                    this.pus = PersistenceUtils.getPersistenceUnits(documentFO);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                this.emaps = PersistenceUtils.getEntityMappings(documentFO);
            }
            this.CCParser = new CCParser(controller);
        }

        public javax.lang.model.element.Element getJavaClass() {
            TreePath path = null;
            try {
                path = JPACodeCompletionProvider.this.getCompletionTreePath(this.controller, this.endOffset, 1);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            javax.lang.model.element.Element el = null;
            try {
                this.controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            while ((el == null || ElementKind.CLASS != el.getKind() && ElementKind.INTERFACE != el.getKind()) && path != null) {
                path.getCompilationUnit().getTypeDecls();
                el = this.controller.getTrees().getElement(path);
                path = path.getParentPath();
            }
            return el;
        }

        public BaseDocument getBaseDocument() {
            BaseDocument doc = (BaseDocument)this.component.getDocument();
            return doc;
        }

        public FileObject getFileObject() {
            try {
                return URLMapper.findFileObject((URL)this.controller.getCompilationUnit().getSourceFile().toUri().toURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public PersistenceUnit[] getPersistenceUnits() {
            return this.pus;
        }

        public EntityMappings getEntityMappings() {
            return this.emaps;
        }

        public int getCompletionOffset() {
            return this.endOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CCParser.CC getParsedAnnotation() {
            CCParser cCParser = this.CCParser;
            synchronized (cCParser) {
                if (this.parsednn == null) {
                    this.parsednn = this.CCParser.parseAnnotation(this.getCompletionOffset());
                }
                return this.parsednn;
            }
        }

        public String getCompletedMemberClassName() {
            if (this.completedMemberJavaClassName == null) {
                this.initCompletedMemberContext();
            }
            return this.completedMemberJavaClassName;
        }

        public String getCompletedMemberName() {
            if (this.completedMemberName == null) {
                this.initCompletedMemberContext();
            }
            return this.completedMemberName;
        }

        private void initCompletedMemberContext() {
            Object type = null;
            Object genericType = null;
            Object propertyName = null;
            CCParser nnp = new CCParser(this.controller);
            TokenSequence ts = this.controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            ts.move(this.getCompletionOffset() + 1);
            this.nextNonWhitespaceToken((TokenSequence<JavaTokenId>)ts);
            Token ti = ts.token();
            while (ti != null && propertyName == null) {
                CCParser.CC parsed;
                javax.lang.model.element.Element el = null;
                try {
                    el = this.controller.getTrees().getElement(JPACodeCompletionProvider.this.getCompletionTreePath(this.controller, ts.offset() + 1, 1));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (el.getKind() == ElementKind.ANNOTATION_TYPE && (parsed = nnp.parseAnnotation(ts.offset() + 1)) != null) {
                    ts.move(parsed.getEndOffset());
                    ti = ts.token();
                    continue;
                }
                if (genericType != null && ti.id() == JavaTokenId.LT) {
                    ts.moveNext();
                    Token ti2 = ts.token();
                    if (ti2.id() != JavaTokenId.IDENTIFIER) {
                        genericType = null;
                    }
                } else if (ti.id() == JavaTokenId.IDENTIFIER && type == null) {
                    genericType = type;
                }
                ts.moveNext();
                ti = ts.token();
            }
            this.completedMemberName = propertyName;
            this.completedMemberJavaClassName = genericType == null ? type : genericType;
        }

        private TokenSequence<JavaTokenId> nextNonWhitespaceToken(TokenSequence<JavaTokenId> ts) {
            block3: while (ts.moveNext()) {
                int offset = ts.offset();
                switch ((JavaTokenId)ts.token().id()) {
                    case WHITESPACE: 
                    case LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case JAVADOC_COMMENT: {
                        continue block3;
                    }
                }
                return ts;
            }
            return null;
        }
    }

    class JPACodeCompletionQuery
    extends AsyncCompletionQuery {
        private ArrayList<CompletionContextResolver> resolvers;
        private List<JPACompletionItem> results;
        private byte hasAdditionalItems = 0;
        private CompletionDocumentation documentation;
        private int anchorOffset;
        private int toolTipOffset;
        private JTextComponent component;
        private int queryType;
        private int caretOffset;
        private String filterPrefix;
        private ElementHandle element;
        private boolean hasTask;

        public JPACodeCompletionQuery(int queryType, JTextComponent component, int caretOffset, boolean hasTask) {
            this.queryType = queryType;
            this.caretOffset = caretOffset;
            this.hasTask = hasTask;
            this.component = component;
            this.initResolvers();
        }

        private void initResolvers() {
            this.resolvers = new ArrayList();
            this.resolvers.add(new DBCompletionContextResolver());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                this.caretOffset = caretOffset;
                this.results = null;
                this.documentation = null;
                this.anchorOffset = -1;
                Source source = Source.create((Document)doc);
                if (source != null) {
                    Future f = ParserManager.parseWhenScanFinished(Collections.singletonList(source), (UserTask)this.getTask());
                    if (!f.isDone()) {
                        this.component.putClientProperty("completion-active", Boolean.FALSE);
                        resultSet.setWaitText(NbBundle.getMessage(JPACodeCompletionProvider.class, (String)"scanning-in-progress"));
                        f.get();
                    }
                    if ((this.queryType & 1) != 0) {
                        if (this.results != null) {
                            resultSet.addAllItems(this.results);
                        }
                        resultSet.setHasAdditionalItems(this.hasAdditionalItems > 0);
                        if (this.hasAdditionalItems == 1) {
                            resultSet.setHasAdditionalItemsText(NbBundle.getMessage(JPACodeCompletionProvider.class, (String)"JCP-imported-items"));
                        }
                        if (this.hasAdditionalItems == 2) {
                            resultSet.setHasAdditionalItemsText(NbBundle.getMessage(JPACodeCompletionProvider.class, (String)"JCP-instance-members"));
                        }
                    }
                    if (this.anchorOffset > -1) {
                        resultSet.setAnchorOffset(this.anchorOffset);
                    }
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                resultSet.finish();
            }
        }

        private UserTask getTask() {
            return new Task();
        }

        protected boolean canFilter(JTextComponent component) {
            return false;
        }

        protected void filter(CompletionResultSet resultSet) {
            try {
                if ((this.queryType & 1) != 0 && this.results != null) {
                    if (this.filterPrefix != null) {
                        resultSet.addAllItems(this.getFilteredData(this.results, this.filterPrefix));
                        resultSet.setHasAdditionalItems(this.hasAdditionalItems > 0);
                    } else {
                        Completion.get().hideDocumentation();
                        Completion.get().hideCompletion();
                    }
                }
                resultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            resultSet.finish();
        }

        private Collection getFilteredData(Collection<JPACompletionItem> data, String prefix) {
            if (prefix.length() == 0) {
                return data;
            }
            ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
            boolean camelCase = JPACodeCompletionProvider.isCamelCasePrefix(prefix);
            for (CompletionItem completionItem : data) {
                if (!((Object)completionItem.getInsertPrefix()).toString().startsWith(prefix)) continue;
                ret.add(completionItem);
            }
            return ret;
        }

        private void run(CompilationController controller) {
            Object filter = null;
            int startOffset = this.caretOffset;
            Iterator<CompletionContextResolver> resolversItr = this.resolvers.iterator();
            TreePath env = null;
            try {
                env = JPACodeCompletionProvider.this.getCompletionTreePath(controller, this.caretOffset, 1);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (env == null) {
                return;
            }
            this.results = new ArrayList<JPACompletionItem>();
            while (resolversItr.hasNext()) {
                CompletionContextResolver resolver = resolversItr.next();
                Context ctx = new Context(this.component, controller, startOffset, false);
                if (ctx.getEntityMappings() == null) {
                    ErrorManager.getDefault().log(1, "No EnitityMappings defined.");
                    break;
                }
                this.results.addAll(resolver.resolve(ctx));
            }
        }

        private class Task
        extends UserTask {
            private Task() {
            }

            public void run(ResultIterator resultIterator) throws Exception {
                CompilationController controller;
                Parser.Result result = resultIterator.getParserResult(JPACodeCompletionQuery.this.caretOffset);
                CompilationController compilationController = controller = result != null ? CompilationController.get((Parser.Result)result) : null;
                if (controller != null) {
                    JPACodeCompletionQuery.this.run(controller);
                }
            }
        }
    }
}

