/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.j2ee.persistence.editor.completion.CCPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

public abstract class JPACompletionItem
implements CompletionItem {
    protected int substituteOffset = -1;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;

    public abstract String getItemText();

    public int getSubstituteOffset() {
        return this.substituteOffset;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = this.getItemText();
        if (text != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                text = text + toAdd;
            }
            doc.atomicLock();
            try {
                char ch;
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) {
                    boolean bl = false;
                    return bl;
                }
                if (!text.startsWith("\"")) {
                    text = this.quoteText(text);
                }
                if ((ch = doc.getText(offset + len, 1).charAt(0)) == '\"') {
                    ++len;
                }
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    public abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((CCPaintComponent)renderComponent).paintComponent(g);
    }

    public String toString() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            Completion completion = Completion.get();
            switch (evt.getKeyChar()) {
                case ' ': {
                    if (evt.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '(': 
                case ',': 
                case ';': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
                case '.': {
                    if (!this.defaultAction((JTextComponent)evt.getSource(), Character.toString(evt.getKeyChar()))) break;
                    evt.consume();
                }
            }
        }
    }

    protected String quoteText(String s) {
        return "\"" + s + "\"";
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent c) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(c);
        return true;
    }

    public void defaultAction(JTextComponent component) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(component, "");
    }

    private boolean defaultAction(JTextComponent component, String addText) {
        int substOffset = this.substituteOffset;
        if (substOffset == -1) {
            substOffset = component.getCaret().getDot();
        }
        toAdd = addText;
        return this.substituteText(component, substOffset, component.getCaret().getDot() - substOffset, false);
    }

    public static final class NoConnectionElementItem
    extends JPACompletionItem {
        private static CCPaintComponent.NoConnectionItemPaintComponent paintComponent = null;
        private DatabaseConnection dbconn;

        public NoConnectionElementItem(DatabaseConnection dbconn) {
            this.dbconn = dbconn;
        }

        public int getSortPriority() {
            return 1;
        }

        @Override
        public String getItemText() {
            return "";
        }

        @Override
        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            ConnectionManager.getDefault().showConnectionDialog(this.dbconn);
            return false;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.NoConnectionItemPaintComponent();
            }
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class ColumnElementItem
    extends DBElementItem {
        private String tableName;
        protected static CCPaintComponent.ColumnElementPaintComponent paintComponent = null;

        public ColumnElementItem(String columnName, String tableName, boolean quote, int substituteOffset) {
            super(columnName, quote, substituteOffset);
            this.tableName = tableName;
        }

        @Override
        public String getTypeName() {
            return "Column";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public String getItemText() {
            return "\"" + this.getName() + "\"";
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.ColumnElementPaintComponent();
            }
            paintComponent.setContent(this.getName(), this.tableName);
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        @Override
        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class TableElementItem
    extends DBElementItem {
        protected static CCPaintComponent.TableElementPaintComponent paintComponent = null;

        public TableElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Table";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.TableElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        @Override
        public Object getAssociatedObject() {
            return this;
        }
    }

    public static final class SchemaElementItem
    extends DBElementItem {
        public SchemaElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Schema";
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static final class CatalogElementItem
    extends DBElementItem {
        public CatalogElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Catalog";
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static final class EntityPropertyElementItem
    extends DBElementItem {
        protected static CCPaintComponent.EntityPropertyElementPaintComponent paintComponent = null;

        public EntityPropertyElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Persistence Unit";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.EntityPropertyElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }
    }

    public static final class PersistenceUnitElementItem
    extends DBElementItem {
        protected static CCPaintComponent.PersistenceUnitElementPaintComponent paintComponent = null;

        public PersistenceUnitElementItem(String name, boolean quote, int substituteOffset) {
            super(name, quote, substituteOffset);
        }

        @Override
        public String getTypeName() {
            return "Persistence Unit";
        }

        public int getSortPriority() {
            return 100;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.PersistenceUnitElementPaintComponent();
            }
            paintComponent.setContent(this.getName());
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }
    }

    private static abstract class DBElementItem
    extends JPACompletionItem {
        private String name;
        private boolean quote;
        protected static CCPaintComponent.DBElementPaintComponent paintComponent = null;

        public DBElementItem(String name, boolean quote, int substituteOffset) {
            this.name = name;
            this.quote = quote;
            this.substituteOffset = substituteOffset;
        }

        public DBElementItem(String name, boolean quote) {
            this(name, quote, -1);
        }

        protected String getName() {
            return this.name;
        }

        protected boolean getQuoted() {
            return this.quote;
        }

        @Override
        public String getItemText() {
            if (this.quote) {
                return this.quoteText(this.name);
            }
            return this.name;
        }

        @Override
        public Component getPaintComponent(boolean isSelected) {
            if (paintComponent == null) {
                paintComponent = new CCPaintComponent.DBElementPaintComponent();
            }
            paintComponent.setString(this.getTypeName() + ": " + this.name);
            paintComponent.setSelected(isSelected);
            return paintComponent;
        }

        public Object getAssociatedObject() {
            return this;
        }

        public abstract String getTypeName();
    }
}

