/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.jpql;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Constructor;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeDeclaration;
import org.netbeans.modules.j2ee.persistence.spi.jpql.TypeRepository;

public class Type
implements IType {
    private final Element element;
    private final ITypeRepository repository;
    private ITypeDeclaration tDeclaration;

    public Type(TypeRepository typeRepository, Element element) {
        this.element = element;
        this.repository = typeRepository;
    }

    public Iterable<IConstructor> constructors() {
        ArrayList<IConstructor> ret = new ArrayList<IConstructor>();
        this.collectConstructors(ret, this.element);
        return ret;
    }

    public boolean equals(IType itype) {
        return this == itype || this.getName().equals(itype.getName());
    }

    public String[] getEnumConstants() {
        ArrayList<String> constants = new ArrayList<String>();
        for (Element element : this.element.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            constants.add(element.getSimpleName().toString());
        }
        return constants.toArray(new String[0]);
    }

    public String getName() {
        if (this.element instanceof TypeElement) {
            return ((TypeElement)this.element).getQualifiedName().toString();
        }
        return ((Object)this.element.asType()).toString();
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.tDeclaration == null) {
            this.tDeclaration = new TypeDeclaration(this, new ITypeDeclaration[0], 0);
        }
        return this.tDeclaration;
    }

    public boolean hasAnnotation(Class<? extends Annotation> type) {
        return this.element.getAnnotation(type) != null;
    }

    public boolean isAssignableTo(IType itype) {
        if (this == itype) {
            return true;
        }
        String rootName = itype.getName();
        TypeElement tEl = (TypeElement)(this.element instanceof TypeElement ? this.element : null);
        return this.haveInHierarchy(tEl, rootName);
    }

    public boolean isEnum() {
        return this.element instanceof TypeElement ? ((TypeElement)this.element).getKind() == ElementKind.ENUM : false;
    }

    public boolean isResolvable() {
        return true;
    }

    public String toString() {
        return super.toString() + ", name = " + this.getName();
    }

    private void collectConstructors(ArrayList<IConstructor> constructors, Element element) {
        if (element == null || element.getKind() != ElementKind.CLASS) {
            return;
        }
        TypeElement el = (TypeElement)element;
        for (Element element2 : el.getEnclosedElements()) {
            TypeMirror supMirror;
            if (element2.getKind() == ElementKind.CONSTRUCTOR) {
                constructors.add(new Constructor(this, (ExecutableElement)element2));
                continue;
            }
            if (element2.getKind() != ElementKind.CLASS || ((TypeElement)element2).getSuperclass() == null || (supMirror = ((TypeElement)element2).getSuperclass()).getKind() != TypeKind.DECLARED) continue;
            DeclaredType superclassDeclaredType = (DeclaredType)supMirror;
            Element superclassElement = superclassDeclaredType.asElement();
            this.collectConstructors(constructors, superclassElement);
        }
    }

    private boolean haveInHierarchy(TypeElement el, String name) {
        TypeElement tmpEl = el;
        while (tmpEl != null) {
            if (tmpEl.getQualifiedName().toString().equals(name)) {
                return true;
            }
            TypeMirror supMirror = tmpEl.getSuperclass();
            if (supMirror.getKind() != TypeKind.DECLARED) continue;
            DeclaredType declaredType = (DeclaredType)supMirror;
            Element superclassElement = declaredType.asElement();
            if (superclassElement instanceof TypeElement) {
                tmpEl = (TypeElement)superclassElement;
                continue;
            }
            tmpEl = null;
        }
        for (TypeMirror typeMirror : el.getInterfaces()) {
            DeclaredType intDeclType;
            Element intElement;
            if (typeMirror.getKind() != TypeKind.DECLARED || !((intElement = (intDeclType = (DeclaredType)typeMirror).asElement()) instanceof TypeElement) || !this.haveInHierarchy(tmpEl = (TypeElement)intElement, name)) continue;
            return true;
        }
        return false;
    }
}

