/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceCfgProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Util {
    public static ArrayList<String> getAllPropNames(Provider propCat) {
        ArrayList<String> results = new ArrayList<String>();
        if ("2.0".equals(ProviderUtil.getVersion(propCat))) {
            Collections.addAll(results, PersistenceCfgProperties.defaultJPA20Keys);
        }
        results.addAll(propCat.getPropertyNames());
        if (ProviderUtil.ECLIPSELINK_PROVIDER.equals(propCat)) {
            Collections.addAll(results, PersistenceCfgProperties.eclipselink20Keys);
        } else if (ProviderUtil.HIBERNATE_PROVIDER2_0.equals(propCat)) {
            Collections.addAll(results, PersistenceCfgProperties.hibernate20Keys);
        }
        return results;
    }

    public static ArrayList<String> getPropsNamesExceptGeneral(Provider propCat) {
        ArrayList<String> propsList = Util.getAllPropNames(propCat);
        propsList.remove(propCat.getJdbcDriver());
        propsList.remove(propCat.getJdbcUsername());
        propsList.remove(propCat.getJdbcUrl());
        propsList.remove(propCat.getJdbcPassword());
        propsList.remove(propCat.getTableGenerationPropertyName());
        return propsList;
    }

    public static ArrayList<String> getAvailPropNames(Provider propCat, PersistenceUnit pu) {
        ArrayList<String> propsList = Util.getPropsNamesExceptGeneral(propCat);
        if (pu != null) {
            ArrayList<String> availProps = new ArrayList<String>(propsList);
            for (int i = 0; i < pu.getProperties().sizeProperty2(); ++i) {
                String propName = pu.getProperties().getProperty2(i).getName();
                if (availProps.remove(propName) || !availProps.contains("javax.persistence." + propName)) continue;
                availProps.remove(propName);
            }
            return availProps;
        }
        return new ArrayList<String>();
    }

    public static SourceGroup[] getJavaSourceGroups(PUDataObject dObj) throws IOException {
        Project proj = FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile());
        if (proj == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)proj);
        SourceGroup[] toRet = sources.getSourceGroups("resources");
        if (toRet != null && toRet.length != 0) {
            return toRet;
        }
        return sources.getSourceGroups("java");
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo) {
        return Util.getResourcePath(groups, fo, '.', false);
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator) {
        return Util.getResourcePath(groups, fo, separator, false);
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator, boolean withExt) {
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (relativePath != null) {
                int index;
                if (separator != '/') {
                    relativePath = relativePath.replace('/', separator);
                }
                if (!withExt && (index = relativePath.lastIndexOf(46)) > 0) {
                    relativePath = relativePath.substring(0, index);
                }
                return relativePath;
            }
            return "";
        }
        return "";
    }
}

