/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.api.SourcesVisibilityQuery;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class DiscoveryUtils {
    private DiscoveryUtils() {
    }

    public static List<String> getSystemIncludePaths(ProjectProxy project, boolean isCPP) {
        ProjectBridge bridge;
        Project p = project.getProject();
        if (p != null && (bridge = new ProjectBridge(p)).isValid()) {
            return bridge.getSystemIncludePaths(isCPP);
        }
        return new ArrayList<String>();
    }

    public static CompilerFlavor getCompilerFlavor(ProjectProxy project) {
        ProjectBridge bridge;
        Project p = project.getProject();
        if (p != null && (bridge = new ProjectBridge(p)).isValid()) {
            return bridge.getCompilerFlavor();
        }
        return null;
    }

    public static String getCygwinDrive(ProjectProxy project) {
        ProjectBridge bridge;
        Project p = project.getProject();
        if (p != null && (bridge = new ProjectBridge(p)).isValid()) {
            return bridge.getCygwinDrive();
        }
        return null;
    }

    public static Map<String, String> getSystemMacroDefinitions(ProjectProxy project, boolean isCPP) {
        ProjectBridge bridge;
        Project p = project.getProject();
        if (p != null && (bridge = new ProjectBridge(p)).isValid()) {
            return bridge.getSystemMacroDefinitions(isCPP);
        }
        return new HashMap<String, String>();
    }

    public static List<String> scanCommandLine(String line) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        StringBuilder current = new StringBuilder();
        boolean isSingleQuoteMode = false;
        boolean isDoubleQuoteMode = false;
        block5: while (i < line.length()) {
            char c = line.charAt(i);
            ++i;
            switch (c) {
                case '\'': {
                    if (isSingleQuoteMode) {
                        isSingleQuoteMode = false;
                    } else if (!isDoubleQuoteMode) {
                        isSingleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\"': {
                    if (isDoubleQuoteMode) {
                        isDoubleQuoteMode = false;
                    } else if (!isSingleQuoteMode) {
                        isDoubleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (isSingleQuoteMode || isDoubleQuoteMode) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    res.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            res.add(current.toString());
        }
        return res;
    }

    public static String getRelativePath(String base, String path) {
        String bstring;
        if (path.equals(base)) {
            return path;
        }
        if (path.startsWith(base + '/')) {
            return path.substring(base.length() + 1);
        }
        if (path.startsWith(base + '\\')) {
            return path.substring(base.length() + 1);
        }
        if (!(path.startsWith("/") || path.startsWith("\\") || path.length() > 2 && path.charAt(2) == ':')) {
            return path;
        }
        StringTokenizer stb = new StringTokenizer(base, "\\/");
        StringTokenizer stp = new StringTokenizer(path, "\\/");
        int match = 0;
        String pstring = null;
        while (stb.hasMoreTokens() && stp.hasMoreTokens() && (bstring = stb.nextToken()).equals(pstring = stp.nextToken())) {
            ++match;
        }
        if (match <= 1) {
            return path;
        }
        StringBuilder s = new StringBuilder();
        while (stb.hasMoreTokens()) {
            String bstring2 = stb.nextToken();
            s.append("..").append(File.separator);
        }
        s.append("..").append(File.separator).append(pstring);
        while (stp.hasMoreTokens()) {
            s.append(File.separator).append(stp.nextToken());
        }
        return s.toString();
    }

    public static String normalizeAbsolutePath(String path) {
        boolean caseSensitive = CndFileUtils.isSystemCaseSensitive();
        if (!caseSensitive && Utilities.isWindows()) {
            path = path.toString().replace('\\', '/');
        }
        String normalized = !caseSensitive || path.endsWith("/.") || path.endsWith("\\.") || path.contains("..") || path.contains("./") || path.contains(".\\") ? FileUtil.normalizeFile((File)new File(path)).getAbsolutePath() : path;
        return normalized;
    }

    public static String convertRelativePathToAbsolute(SourceFileProperties source, String path) {
        if (!(path.startsWith("/") || path.length() > 1 && path.charAt(1) == ':')) {
            path = path.equals(".") ? source.getCompilePath() : source.getCompilePath() + File.separator + path;
            File file = new File(path);
            path = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
        }
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static List<String> gatherCompilerLine(String line, boolean isScriptOutput, List<String> userIncludes, Map<String, String> userMacros, Set<String> libraries, List<String> languageArtifacts) {
        List<String> list = DiscoveryUtils.scanCommandLine(line);
        boolean hasQuotes = false;
        for (String s : list) {
            if (!s.startsWith("\"")) continue;
            hasQuotes = true;
            break;
        }
        if (hasQuotes) {
            ArrayList<String> newList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String s = list.get(i);
                if (s.startsWith("-D") && s.endsWith("=") && i + 1 < list.size() && list.get(i + 1).startsWith("\"")) {
                    String longString = null;
                    int j = i + 1;
                    while (j < list.size() && list.get(j).startsWith("\"")) {
                        longString = longString != null ? longString + " " + list.get(j) : list.get(j);
                        i = j++;
                    }
                    newList.add(s + "`" + longString + "`");
                    continue;
                }
                newList.add(s);
            }
            list = newList;
        }
        Iterator<String> st = list.iterator();
        String option = null;
        if (st.hasNext() && (option = st.next()).equals("+") && st.hasNext()) {
            option = st.next();
        }
        return DiscoveryUtils.gatherCompilerLine(st, isScriptOutput, userIncludes, userMacros, libraries, languageArtifacts);
    }

    public static List<String> gatherCompilerLine(Iterator<String> st, boolean isScriptOutput, List<String> userIncludes, Map<String, String> userMacros, Set<String> libraries, List<String> languageArtifacts) {
        boolean TRACE = false;
        String option = null;
        ArrayList<String> what = new ArrayList<String>(1);
        while (st.hasNext()) {
            String path;
            option = st.next();
            boolean isQuote = false;
            if (isScriptOutput && (option.startsWith("'") && option.endsWith("'") || option.startsWith("\"") && option.endsWith("\""))) {
                option = option.substring(1, option.length() - 1);
                isQuote = true;
            }
            if (option.startsWith("-D")) {
                String macro = option.equals("-D") && st.hasNext() ? st.next() : option.substring(2);
                int i = (macro = DiscoveryUtils.removeQuotes(macro)).indexOf(61);
                if (i > 0) {
                    String value = macro.substring(i + 1).trim();
                    if (value.length() >= 2 && value.charAt(0) == '`' && value.charAt(value.length() - 1) == '`') {
                        value = value.substring(1, value.length() - 1);
                    } else if (!isQuote && value.length() >= 6 && value.charAt(0) == '\"' && value.charAt(1) == '\\' && value.charAt(2) == '\"' && value.charAt(value.length() - 3) == '\\' && value.charAt(value.length() - 2) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(2, value.length() - 3) + "\"";
                    } else if (value.length() >= 4 && value.charAt(0) == '\\' && value.charAt(1) == '\"' && value.charAt(value.length() - 2) == '\\' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 2) + "\"";
                    }
                    userMacros.put(macro.substring(0, i), value);
                    continue;
                }
                userMacros.put(macro, null);
                continue;
            }
            if (option.startsWith("-I")) {
                path = option.substring(2);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                path = DiscoveryUtils.removeQuotes(path);
                userIncludes.add(path);
                continue;
            }
            if (option.startsWith("-isystem")) {
                path = option.substring(8);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                path = DiscoveryUtils.removeQuotes(path);
                userIncludes.add(path);
                continue;
            }
            if (option.startsWith("-include")) {
                path = option.substring(8);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                path = DiscoveryUtils.removeQuotes(path);
                userIncludes.add(path);
                continue;
            }
            if (option.startsWith("-imacros")) {
                path = option.substring(8);
                if (path.length() == 0 && st.hasNext()) {
                    path = st.next();
                }
                path = DiscoveryUtils.removeQuotes(path);
                userIncludes.add(path);
                continue;
            }
            if (option.startsWith("-Y")) {
                String defaultSearchPath = option.substring(2);
                if (defaultSearchPath.length() == 0 && st.hasNext()) {
                    defaultSearchPath = st.next();
                }
                if (!defaultSearchPath.startsWith("I,")) continue;
                defaultSearchPath = defaultSearchPath.substring(2);
                defaultSearchPath = DiscoveryUtils.removeQuotes(defaultSearchPath);
                userIncludes.add(defaultSearchPath);
                continue;
            }
            if (option.startsWith("-idirafter")) {
                if (!option.equals("-idirafter") || !st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-iprefix")) {
                if (!option.equals("-iprefix") || !st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-iwithprefix")) {
                if (!option.equals("-iwithprefix") || !st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-iwithprefixbefore")) {
                if (!option.equals("-iwithprefixbefore") || !st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-isysroot")) {
                if (!option.equals("-isysroot") || !st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-iquote")) {
                if (!option.equals("-iquote") || !st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-U")) {
                if (!option.equals("-U") || !st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-K")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-R")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.startsWith("-l")) {
                String lib = option.substring(2);
                if (lib.length() == 0 && st.hasNext()) {
                    lib = st.next();
                }
                if (lib.length() <= 0 || libraries == null) continue;
                libraries.add(lib);
                continue;
            }
            if (option.equals("-L")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-M")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-h")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-o")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-z")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-x")) {
                if (!st.hasNext()) continue;
                String lang = st.next();
                if (languageArtifacts == null) continue;
                languageArtifacts.add(lang);
                continue;
            }
            if (option.equals("-xMF")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-MF")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-MT")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-MQ")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-aux-info")) {
                if (!st.hasNext()) continue;
                st.next();
                continue;
            }
            if (option.equals("-fopenmp")) {
                userMacros.put("_OPENMP", "200505");
                continue;
            }
            if (option.equals("-xopenmp") || option.equals("-xopenmp=parallel") || option.equals("-xopenmp=noopt")) {
                userMacros.put("_OPENMP", null);
                continue;
            }
            if (option.startsWith("-") || option.startsWith("ccfe")) continue;
            if (option.startsWith(">")) break;
            if (SourcesVisibilityQuery.getDefault().isIgnored(option)) continue;
            if (what.isEmpty()) {
                what.add(option);
                continue;
            }
            if (TRACE) {
                System.out.println("**** What is this [" + option + "] if previous was [" + (String)what.get(0) + "]?");
            }
            if (!SourcesVisibilityQuery.getDefault().isVisible(option)) continue;
            if (what.size() == 1) {
                if (!SourcesVisibilityQuery.getDefault().isVisible((String)what.get(0))) {
                    what.set(0, option);
                    continue;
                }
                what.add(option);
                continue;
            }
            what.add(option);
        }
        return what;
    }

    private static String removeQuotes(String path) {
        if (path.length() >= 2 && (path.charAt(0) == '\'' && path.charAt(path.length() - 1) == '\'' || path.charAt(0) == '\"' && path.charAt(path.length() - 1) == '\"')) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }
}

