/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.buildsupport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CompileSupport
extends CompileOptionsProvider {
    private static final String STORAGE_SUFFIX = "properties";

    public AllOptionsProvider getOptions(Item item) {
        NativeProject nativeProject = item.getNativeProject();
        Lookup.Provider project = nativeProject.getProject();
        if (project instanceof Project) {
            FileObject projectDirectory = ((Project)project).getProjectDirectory();
            MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
            if (makeConfiguration != null) {
                String confName = makeConfiguration.getName();
                String itemPath = item.getAbsolutePath();
                return this.getOptions(projectDirectory, confName, itemPath);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(MakeConfiguration makeConfiguration, String newName) {
        FileObject projectDirectory = makeConfiguration.getBaseFSPath().getFileObject();
        String confName = makeConfiguration.getName();
        FileObject properties = projectDirectory.getFileObject("nbproject/private/" + confName + "." + STORAGE_SUFFIX);
        if (properties != null && properties.isValid()) {
            FileLock lock = null;
            try {
                lock = properties.lock();
                properties.rename(lock, newName, STORAGE_SUFFIX);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MakeConfiguration makeConfiguration) {
        FileObject projectDirectory = makeConfiguration.getBaseFSPath().getFileObject();
        String confName = makeConfiguration.getName();
        FileObject properties = projectDirectory.getFileObject("nbproject/private/" + confName + "." + STORAGE_SUFFIX);
        if (properties != null && properties.isValid()) {
            FileLock lock = null;
            try {
                lock = properties.lock();
                properties.delete(lock);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOptions(MakeConfiguration makeConfiguration, Iterator<String> it) {
        FileObject projectDirectory = makeConfiguration.getBaseFSPath().getFileObject();
        String confName = makeConfiguration.getName();
        FileObject properties = projectDirectory.getFileObject("nbproject/private/" + confName + "." + STORAGE_SUFFIX);
        if (properties == null) {
            try {
                properties = FileUtil.createData((FileObject)projectDirectory, (String)("nbproject/private/" + confName + "." + STORAGE_SUFFIX));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        if (properties != null && properties.isValid()) {
            FileLock lock = null;
            PrintStream outputStream = null;
            try {
                lock = properties.lock();
                outputStream = new PrintStream(properties.getOutputStream(lock), false, "UTF-8");
                while (it.hasNext()) {
                    String next = it.next();
                    if (next == null || next.length() <= 0) continue;
                    outputStream.println(next);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllOptionsProvider getOptions(FileObject projectDirectory, String confName, String itemPath) {
        FileObject properties = projectDirectory.getFileObject("nbproject/private/" + confName + "." + STORAGE_SUFFIX);
        if (properties != null && properties.isValid()) {
            Properties p = new Properties();
            FileLock lock = null;
            BufferedReader in = null;
            try {
                lock = properties.lock();
                in = new BufferedReader(new InputStreamReader(properties.getInputStream(), "UTF-8"));
                String line = null;
                while (!((line = in.readLine()) == null || line.startsWith(itemPath) && line.startsWith(itemPath + "="))) {
                }
                if (line != null) {
                    final String resLine = line.substring(line.indexOf(61) + 1);
                    AllOptionsProvider allOptionsProvider = new AllOptionsProvider(){

                        public String getAllOptions(Tool tool) {
                            return resLine;
                        }
                    };
                    return allOptionsProvider;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
        return null;
    }
}

