/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import javax.swing.Action;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.discovery.projectimport.ReconfigurePanel;
import org.netbeans.modules.cnd.discovery.projectimport.ReconfigureProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;

public class ReconfigureAction
extends NodeAction {
    private static final RequestProcessor RP = new RequestProcessor(ReconfigureAction.class.getName(), 1);

    public static Action getReconfigureAction() {
        return (Action)SharedClassObject.findObject(ReconfigureAction.class, (boolean)true);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ReconfigureAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] activatedNodes) {
        Project p = this.getProject(activatedNodes);
        if (p == null) {
            return false;
        }
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)p.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null || !pdp.gotDescriptor()) {
            return false;
        }
        MakeConfigurationDescriptor mcd = pdp.getConfigurationDescriptor();
        if (mcd == null) {
            return false;
        }
        MakeConfiguration configuration = mcd.getActiveConfiguration();
        if (configuration == null || configuration.getConfigurationType().getValue() != 0) {
            return false;
        }
        CompilerSet2Configuration set = configuration.getCompilerSet();
        if (set == null) {
            return false;
        }
        CompilerSet cs = set.getCompilerSet();
        if (cs == null) {
            return false;
        }
        return new ReconfigureProject(p).isApplicable();
    }

    public void performAction(Node[] activatedNodes) {
        String cxxFlags;
        String cFlags;
        Project p = this.getProject(activatedNodes);
        final ReconfigureProject reconfigurator = new ReconfigureProject(p);
        String linkerFlags = "";
        if (reconfigurator.isSunCompiler()) {
            cFlags = "-g";
            cxxFlags = "-g";
        } else {
            cFlags = "-g3 -gdwarf-2";
            cxxFlags = "-g3 -gdwarf-2";
        }
        ReconfigurePanel panel = new ReconfigurePanel(cFlags, cxxFlags, linkerFlags, reconfigurator.getRestOptions(), this.getLegend(reconfigurator), reconfigurator.getCompilerSet().getDisplayName());
        JButton runButton = new JButton(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureButton"));
        runButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureButtonAD"));
        Object[] options = new Object[]{runButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureDialogTitle"), true, options, (Object)runButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret == runButton) {
            reconfigurator.setConfigureCodeAssistance(true);
            final String c = panel.getCFlags();
            final String cpp = panel.getCppFlags();
            final String link = panel.getLinkerFlags();
            final String other = panel.getOtherOptions();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    reconfigurator.reconfigure(c, cpp, link, other, false, null);
                }
            });
        }
    }

    private String getLegend(ReconfigureProject reconfigurator) {
        ReconfigureProject.CompilerOptions options = reconfigurator.getLastCompilerOptions();
        if (options != null && options.CFlags != null && options.CppFlags != null && options.CCompiler != null && options.CppCompiler != null) {
            String linker = options.LinkerFlags == null ? "" : options.LinkerFlags;
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureLegend", (Object)options.CCompiler, (Object)options.CppCompiler, (Object)options.CFlags, (Object)options.CppFlags, (Object[])new Object[]{linker});
        }
        return "";
    }

    protected boolean asynchronous() {
        return false;
    }

    protected Project getProject(Node[] nodes) {
        if (nodes.length != 1) {
            return null;
        }
        for (int i = 0; i < nodes.length; ++i) {
            Project p = (Project)nodes[i].getLookup().lookup(Project.class);
            if (p == null) continue;
            return p;
        }
        return null;
    }
}

