/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrBranchConverter
extends InstructionConverter {
    public InstrBranchConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    @Override
    public JcInstruction convert() throws Exception {
        int n = this.java_instr.getOpcode();
        switch (n) {
            case 198: {
                return this.IfNull(158);
            }
            case 199: {
                return this.IfNull(159);
            }
            case 153: {
                return this.IfCond(152);
            }
            case 154: {
                return this.IfCond(153);
            }
            case 155: {
                return this.IfCond(154);
            }
            case 156: {
                return this.IfCond(155);
            }
            case 157: {
                return this.IfCond(156);
            }
            case 158: {
                return this.IfCond(157);
            }
            case 159: {
                return this.IfIcmpCond(162, 152);
            }
            case 160: {
                return this.IfIcmpCond(163, 153);
            }
            case 164: {
                return this.IfIcmpCond(167, 157);
            }
            case 161: {
                return this.IfIcmpCond(164, 154);
            }
            case 162: {
                return this.IfIcmpCond(165, 155);
            }
            case 163: {
                return this.IfIcmpCond(166, 156);
            }
            case 165: {
                return this.IfAcmpCond(160);
            }
            case 166: {
                return this.IfAcmpCond(161);
            }
            case 167: {
                return this.Goto(168);
            }
        }
        throw new ConverterInternalError();
    }

    private JcInstruction IfNull(int n) {
        OperandStackEntry operandStackEntry = this.operand_stack.pop();
        int n2 = this.getBranchLabel(((JInstrShortBranch)this.java_instr).getBranchOffset());
        return new JcInstrBranch(n, n2);
    }

    private JcInstruction IfCond(int n) throws Exception {
        OperandStackEntry operandStackEntry = this.operand_stack.pop();
        JInstrShortBranch jInstrShortBranch = (JInstrShortBranch)this.java_instr;
        int n2 = jInstrShortBranch.getBranchOffset();
        int n3 = this.getBranchLabel(n2);
        switch (operandStackEntry.getType()) {
            case 3: {
                this.jc_instr = new JcInstrNoOperands(10);
                this.operand_stack.push(operandStackEntry);
                this.operand_stack.push(3, this.instr_container);
                this.operand_stack.pop();
                this.operand_stack.pop();
                JcInstrNoOperands jcInstrNoOperands = new JcInstrNoOperands(95);
                this.jc_instr.setNextInstr(jcInstrNoOperands);
                jcInstrNoOperands.setPrevInstr(this.jc_instr);
                JcInstrBranch jcInstrBranch = new JcInstrBranch(n, n3);
                jcInstrNoOperands.setNextInstr(jcInstrBranch);
                jcInstrBranch.setPrevInstr(jcInstrNoOperands);
                this.method_converter.getPackageConverter().setIntFlag(true);
                return this.jc_instr;
            }
            case 1: 
            case 2: {
                if (operandStackEntry.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        operandStackEntry.rollBack();
                    } else {
                        Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                        throw new ConversionException();
                    }
                }
                this.jc_instr = new JcInstrBranch(n, n3);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private JcInstruction IfIcmpCond(int n, int n2) throws Exception {
        OperandStackEntry operandStackEntry = this.operand_stack.peek(1);
        OperandStackEntry operandStackEntry2 = this.operand_stack.peek(2);
        JInstrShortBranch jInstrShortBranch = (JInstrShortBranch)this.java_instr;
        int n3 = jInstrShortBranch.getBranchOffset();
        int n4 = this.getBranchLabel(n3);
        if (operandStackEntry.getType() == 3 || operandStackEntry2.getType() == 3) {
            if (operandStackEntry2.getType() != 3) {
                if (this.method_converter.isIntSupported()) {
                    operandStackEntry2.rollBack();
                } else {
                    throw new ConverterInternalError();
                }
            }
            if (operandStackEntry.getType() != 3) {
                if (this.method_converter.isIntSupported()) {
                    operandStackEntry.rollBack();
                } else {
                    throw new ConverterInternalError();
                }
            }
            this.jc_instr = new JcInstrNoOperands(95);
            JcInstrBranch jcInstrBranch = new JcInstrBranch(n2, n4);
            this.jc_instr.setNextInstr(jcInstrBranch);
            jcInstrBranch.setPrevInstr(this.jc_instr);
            this.method_converter.getPackageConverter().setIntFlag(true);
        } else {
            if (operandStackEntry2.hasOverflowPotential()) {
                if (this.method_converter.isIntSupported()) {
                    operandStackEntry2.rollBack();
                } else {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
            }
            if (operandStackEntry.hasOverflowPotential()) {
                if (this.method_converter.isIntSupported()) {
                    operandStackEntry.rollBack();
                } else {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
            }
            this.jc_instr = new JcInstrBranch(n, n4);
        }
        this.operand_stack.pop();
        this.operand_stack.pop();
        return this.jc_instr;
    }

    private JcInstruction IfAcmpCond(int n) {
        OperandStackEntry operandStackEntry = this.operand_stack.pop();
        OperandStackEntry operandStackEntry2 = this.operand_stack.pop();
        JInstrShortBranch jInstrShortBranch = (JInstrShortBranch)this.java_instr;
        int n2 = jInstrShortBranch.getBranchOffset();
        int n3 = this.getBranchLabel(n2);
        this.jc_instr = new JcInstrBranch(n, n3);
        return this.jc_instr;
    }

    private JcInstruction Goto(int n) {
        JInstrShortBranch jInstrShortBranch = (JInstrShortBranch)this.java_instr;
        int n2 = jInstrShortBranch.getBranchOffset();
        int n3 = this.getBranchLabel(n2);
        this.jc_instr = new JcInstrBranch(n, n3);
        return this.jc_instr;
    }

    private int getBranchLabel(int n) {
        int n2 = this.java_instr.getPC() + n;
        for (InstrContainer instrContainer = this.method_converter.getInstrContainers(); instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            int n3 = instrContainer.getJInstr().getPC();
            if (n2 != n3) continue;
            if (instrContainer.getLabel() == -1) {
                throw new ConverterInternalError();
            }
            return instrContainer.getLabel();
        }
        throw new ConverterInternalError();
    }
}

