/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfConstantUtf8;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfConstantClassRef
extends EfConstant {
    private int name_index;
    private String name;
    private EfConstantPool constant_pool;

    public EfConstantClassRef(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfConstantClassRef(EfConstantPool efConstantPool, String string) {
        this.constant_pool = efConstantPool;
        EfConstant[] efConstantArray = this.constant_pool.getConstants();
        this.name = string;
        for (int i = 0; i < efConstantArray.length; ++i) {
            EfConstantUtf8 efConstantUtf8;
            if (!(efConstantArray[i] instanceof EfConstantUtf8) || !(efConstantUtf8 = (EfConstantUtf8)efConstantArray[i]).getUtf8String().equals(string)) continue;
            this.name_index = i;
            return;
        }
        this.name_index = efConstantPool.addConstantUtf8(string);
    }

    @Override
    public void parse(DataInputStream dataInputStream) throws IOException {
        this.name_index = dataInputStream.readUnsignedShort();
    }

    @Override
    public void resolve() {
        this.name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
    }

    @Override
    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        printWriter.println(string + "Constant_Classref_info {");
        printWriter.println(string + "\ttag\t" + 7);
        printWriter.println(string + "\tname_index\t" + this.name_index + "\t\t// " + this.name);
        printWriter.println(string + "}");
    }

    @Override
    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(7);
        dataOutputStream.writeShort(this.name_index);
    }

    public int getClassNameIndex() {
        return this.name_index;
    }

    public String getClassName() {
        return this.name;
    }
}

