/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.Module;
import com.sun.javacard.packager.model.ModuleJCRD;
import com.sun.javacard.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Manifest;

public class ClassicModuleJCRD
extends ModuleJCRD {
    private String classicPackageAID;
    private String RID;

    public ClassicModuleJCRD(Module module, File file) {
        super(module, file);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        this.classicPackageAID = this.getAttributeValue("Classic-Package-AID");
        if (this.classicPackageAID == null) {
            this.addError(ErrorKey.MissingAttribute, "Classic-Package-AID");
            this.RID = StringUtils.getRIDFromAID(this.classicPackageAID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        Manifest manifest = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            manifest = new Manifest(fileInputStream);
            fileInputStream.close();
            manifest.getMainAttributes().putValue("Sealed", "true");
            fileOutputStream = new FileOutputStream(this.file);
            manifest.write(fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getAID() {
        return this.classicPackageAID;
    }

    String getRID() {
        return this.RID;
    }
}

