/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.maven.ActionProviderImpl;
import org.netbeans.modules.maven.Bundle;
import org.netbeans.modules.maven.CacheDirProvider;
import org.netbeans.modules.maven.LogicalViewProviderImpl;
import org.netbeans.modules.maven.M2AuxilaryConfigImpl;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.ProjectOpenedHookImpl;
import org.netbeans.modules.maven.SubprojectProviderImpl;
import org.netbeans.modules.maven.TemplateAttrProvider;
import org.netbeans.modules.maven.TestChecker;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.classpath.CPExtender;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.classpath.MavenSourcesImpl;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.ProjectProfileHandlerImpl;
import org.netbeans.modules.maven.cos.CosChecker;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.debug.DebuggerChecker;
import org.netbeans.modules.maven.debug.MavenDebuggerImpl;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.execute.BackwardCompatibilityWithMevenideChecker;
import org.netbeans.modules.maven.execute.DefaultReplaceTokenProvider;
import org.netbeans.modules.maven.execute.PrereqCheckerMerger;
import org.netbeans.modules.maven.execute.ReactorChecker;
import org.netbeans.modules.maven.operations.OperationsImpl;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.problems.SanityBuildAction;
import org.netbeans.modules.maven.queries.MavenAnnotationProcessingQueryImpl;
import org.netbeans.modules.maven.queries.MavenBinaryForSourceQueryImpl;
import org.netbeans.modules.maven.queries.MavenFileEncodingQueryImpl;
import org.netbeans.modules.maven.queries.MavenFileLocator;
import org.netbeans.modules.maven.queries.MavenForBinaryQueryImpl;
import org.netbeans.modules.maven.queries.MavenSharabilityQueryImpl;
import org.netbeans.modules.maven.queries.MavenSourceLevelImpl;
import org.netbeans.modules.maven.queries.MavenTestForSourceImpl;
import org.netbeans.modules.maven.spi.nodes.SpecialIcon;
import org.netbeans.spi.java.project.support.LookupMergerSupport;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NbMavenProjectImpl
implements Project {
    public static final String PROP_PROJECT = "MavenProject";
    public static final String PROP_RESOURCE = "RESOURCES";
    private static final Logger LOG = Logger.getLogger(NbMavenProjectImpl.class.getName());
    private static RequestProcessor RELOAD_RP = new RequestProcessor("Maven project reloading", 1);
    private FileObject fileObject;
    private FileObject folderFileObject;
    private final File projectFile;
    private final Lookup lookup;
    private final Updater projectFolderUpdater;
    private final Updater userFolderUpdater;
    private Reference<MavenProject> project;
    private ProblemReporterImpl problemReporter;
    private final Info projectInfo;
    private final MavenSharabilityQueryImpl sharability;
    private final SubprojectProviderImpl subs;
    @NonNull
    private final NbMavenProject watcher;
    private final ProjectState state;
    private final M2ConfigProvider configProvider;
    private final ClassPathProviderImpl cppProvider;
    private final M2AuxilaryConfigImpl auxiliary;
    @NonNull
    private final MavenProjectPropsImpl auxprops;
    private ProjectProfileHandlerImpl profileHandler;
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static WatcherAccessor ACCESSOR = null;
    private static final Properties statics;

    NbMavenProjectImpl(FileObject folder, FileObject projectFO, ProjectState projectState) {
        this.projectFile = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)projectFO));
        this.fileObject = projectFO;
        this.folderFileObject = folder;
        this.projectInfo = new Info();
        this.sharability = new MavenSharabilityQueryImpl(this);
        this.watcher = ACCESSOR.createWatcher(this);
        this.subs = new SubprojectProviderImpl(this, this.watcher);
        this.lookup = new LazyLookup(this, this.watcher, this.projectInfo, this.sharability, this.subs, this.fileObject);
        this.projectFolderUpdater = new Updater("nb-configuration.xml", "pom.xml");
        this.userFolderUpdater = new Updater("settings.xml");
        this.state = projectState;
        this.problemReporter = new ProblemReporterImpl(this);
        this.auxiliary = new M2AuxilaryConfigImpl(this);
        this.auxprops = new MavenProjectPropsImpl(this.auxiliary, this);
        this.profileHandler = new ProjectProfileHandlerImpl(this, this.auxiliary);
        this.configProvider = new M2ConfigProvider(this, this.auxiliary, this.profileHandler);
        this.cppProvider = new ClassPathProviderImpl(this);
    }

    public File getPOMFile() {
        return this.projectFile;
    }

    @NonNull
    public NbMavenProject getProjectWatcher() {
        return this.watcher;
    }

    public ProblemReporterImpl getProblemReporter() {
        return this.problemReporter;
    }

    public MavenProject loadMavenProject(MavenEmbedder embedder, List<String> activeProfiles, Properties properties) {
        try {
            MavenExecutionRequest req = embedder.createMavenExecutionRequest();
            req.addActiveProfiles(activeProfiles);
            req.setPom(this.projectFile);
            req.setNoSnapshotUpdates(true);
            req.setUpdateSnapshots(false);
            Properties props = this.createSystemPropsForProjectLoading();
            if (properties != null) {
                props.putAll((Map<?, ?>)properties);
            }
            req.setUserProperties(props);
            req.setInteractiveMode(false);
            req.setOffline(true);
            req.setRecursive(false);
            MavenExecutionResult res = embedder.readProjectWithDependencies(req);
            if (!res.hasExceptions()) {
                return res.getProject();
            }
            List exc = res.getExceptions();
            for (Throwable ex : exc) {
                LOG.log(Level.FINE, "Exception thrown while loading maven project at " + this.getProjectDirectory(), ex);
            }
        }
        catch (RuntimeException exc) {
            LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + this.getProjectDirectory(), exc);
        }
        return this.getFallbackProject();
    }

    public List<String> getCurrentActiveProfiles() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.addAll(this.configProvider.getActiveConfiguration().getActivatedProfiles());
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties cloneStaticProps() {
        Properties properties = statics;
        synchronized (properties) {
            if (statics.isEmpty()) {
                statics.setProperty("netbeans.execution", "true");
                EmbedderFactory.fillEnvVars((Properties)statics);
                statics.putAll((Map<?, ?>)AbstractMavenExecutor.excludeNetBeansProperties(System.getProperties()));
            }
            Properties toRet = new Properties();
            toRet.putAll((Map<?, ?>)statics);
            return toRet;
        }
    }

    private Properties createSystemPropsForProjectLoading() {
        Properties props = NbMavenProjectImpl.cloneStaticProps();
        props.putAll(this.configProvider.getActiveConfiguration().getProperties());
        return props;
    }

    public Map<? extends String, ? extends String> createSystemPropsForPropertyExpressions() {
        Map props = NbCollections.checkedMapByCopy((Map)NbMavenProjectImpl.cloneStaticProps(), String.class, String.class, (boolean)true);
        props.putAll(this.cppProvider.getJavaPlatform().getSystemProperties());
        props.putAll(this.configProvider.getActiveConfiguration().getProperties());
        return props;
    }

    @NonNull
    public synchronized MavenProject getOriginalMavenProject() {
        MavenProject mp;
        MavenProject mavenProject = mp = this.project == null ? null : this.project.get();
        if (mp == null) {
            mp = this.loadOriginalMavenProject();
        }
        this.project = new SoftReference<MavenProject>(mp);
        return mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NonNull
    private MavenProject loadOriginalMavenProject() {
        block10: {
            startLoading = System.currentTimeMillis();
            newproject = null;
            try {
                req = this.getEmbedder().createMavenExecutionRequest();
                this.profileHandler.clearLineageCache();
                req.addActiveProfiles(this.getCurrentActiveProfiles());
                req.setPom(this.projectFile);
                req.setNoSnapshotUpdates(true);
                req.setUpdateSnapshots(false);
                req.setInteractiveMode(false);
                req.setRecursive(false);
                req.setOffline(true);
                req.setUserProperties(this.createSystemPropsForProjectLoading());
                res = this.getEmbedder().readProjectWithDependencies(req);
                newproject = res.getProject();
                if (res.hasExceptions()) {
                    this.reportExceptions(res);
                }
                if (newproject != null) break block10;
            }
            catch (RuntimeException exc) {
                block11: {
                    try {
                        NbMavenProjectImpl.LOG.log(Level.INFO, "Runtime exception thrown while loading maven project at " + this.getProjectDirectory(), exc);
                        wr = new StringWriter();
                        pw = new PrintWriter(wr);
                        exc.printStackTrace(pw);
                        pw.flush();
                        report = new ProblemReport(0, Bundle.TXT_RuntimeException(), Bundle.TXT_RuntimeExceptionLong() + wr.toString(), null);
                        this.problemReporter.addReport(report);
                        if (newproject != null) break block11;
                    }
                    catch (Throwable var8_11) {
                        if (newproject == null) {
                            newproject = this.getFallbackProject();
                        }
                        endLoading = System.currentTimeMillis();
                        NbMavenProjectImpl.LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, this.getProjectDirectory().getPath()});
                        if (NbMavenProjectImpl.LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                            NbMavenProjectImpl.LOG.log(Level.FINE, "Project " + this.getProjectDirectory().getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                        }
                        throw var8_11;
                    }
                    newproject = this.getFallbackProject();
                }
                endLoading = System.currentTimeMillis();
                NbMavenProjectImpl.LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, this.getProjectDirectory().getPath()});
                if (NbMavenProjectImpl.LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
                    NbMavenProjectImpl.LOG.log(Level.FINE, "Project " + this.getProjectDirectory().getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
                } else {
                    ** GOTO lbl59
                }
            }
            newproject = this.getFallbackProject();
        }
        endLoading = System.currentTimeMillis();
        NbMavenProjectImpl.LOG.log(Level.FINE, "Loaded project in {0} msec at {1}", new Object[]{endLoading - startLoading, this.getProjectDirectory().getPath()});
        if (NbMavenProjectImpl.LOG.isLoggable(Level.FINE) && SwingUtilities.isEventDispatchThread()) {
            NbMavenProjectImpl.LOG.log(Level.FINE, "Project " + this.getProjectDirectory().getPath() + " loaded in AWT event dispatching thread!", new RuntimeException());
        }
        if (!NbMavenProjectImpl.$assertionsDisabled && newproject == null) {
            throw new AssertionError();
        }
        return newproject;
    }

    private MavenProject getFallbackProject() throws AssertionError {
        MavenProject newproject = new MavenProject();
        newproject.setGroupId("error");
        newproject.setArtifactId("error");
        newproject.setVersion("0");
        newproject.setPackaging("pom");
        newproject.setName(Bundle.LBL_Incomplete_Project_Name());
        newproject.setDescription(Bundle.LBL_Incomplete_Project_Desc());
        newproject.setFile(this.projectFile);
        return newproject;
    }

    private void reportExceptions(MavenExecutionResult res) throws MissingResourceException {
        for (Throwable e : res.getExceptions()) {
            ProblemReport report;
            LOG.log(Level.FINE, "Error on loading project " + this.projectFile, e);
            String msg = e.getMessage();
            if (e instanceof ArtifactResolutionException) {
                report = new ProblemReport(0, Bundle.TXT_Artifact_Resolution_problem(), msg, null);
                this.problemReporter.addReport(report);
                this.problemReporter.addMissingArtifact(((ArtifactResolutionException)e).getArtifact());
                continue;
            }
            if (e instanceof ArtifactNotFoundException) {
                report = new ProblemReport(0, Bundle.TXT_Artifact_Not_Found(), msg, null);
                this.problemReporter.addReport(report);
                this.problemReporter.addMissingArtifact(((ArtifactNotFoundException)e).getArtifact());
                continue;
            }
            if (e instanceof ProjectBuildingException) {
                this.problemReporter.addReport(new ProblemReport(0, Bundle.TXT_Cannot_Load_Project(), msg, new SanityBuildAction(this)));
                if (!(e.getCause() instanceof ModelBuildingException)) continue;
                ModelBuildingException mbe = (ModelBuildingException)e.getCause();
                for (ModelProblem mp : mbe.getProblems()) {
                    if (mp.getException() instanceof UnresolvableModelException) {
                        UnresolvableModelException ume = (UnresolvableModelException)mp.getException();
                        this.problemReporter.addMissingArtifact(this.getEmbedder().createProjectArtifact(ume.getGroupId(), ume.getArtifactId(), ume.getVersion()));
                        continue;
                    }
                    if (!(mp.getException() instanceof PluginResolutionException)) continue;
                    Plugin plugin = ((PluginResolutionException)mp.getException()).getPlugin();
                    this.problemReporter.addMissingArtifact(this.getEmbedder().createArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), "jar"));
                }
                continue;
            }
            LOG.log(Level.INFO, "Exception thrown while loading maven project at " + this.getProjectDirectory(), e);
            report = new ProblemReport(0, "Error reading project model", msg, null);
            this.problemReporter.addReport(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectReload() {
        if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess() || SwingUtilities.isEventDispatchThread()) {
            RELOAD_RP.post(new Runnable(){

                @Override
                public void run() {
                    NbMavenProjectImpl.this.fireProjectReload();
                }
            });
            return;
        }
        this.problemReporter.clearReports();
        MavenProject prj = this.loadOriginalMavenProject();
        NbMavenProjectImpl nbMavenProjectImpl = this;
        synchronized (nbMavenProjectImpl) {
            this.project = new SoftReference<MavenProject>(prj);
        }
        ACCESSOR.doFireReload(this.watcher);
        this.projectInfo.reset();
        this.problemReporter.doBaseProblemChecks(this.getOriginalMavenProject());
    }

    public static void refreshLocalRepository(NbMavenProjectImpl project) {
        String basedir = project.getEmbedder().getLocalRepository().getBasedir();
        File file = FileUtil.normalizeFile((File)new File(basedir));
        FileUtil.refreshFor((File[])new File[]{file});
    }

    public String getDisplayName() {
        String displayName = this.projectInfo.getDisplayName();
        if (displayName == null) {
            displayName = Bundle.LBL_NoProjectName();
        }
        return displayName;
    }

    public String getShortDescription() {
        String desc = null;
        if (desc == null) {
            desc = this.getOriginalMavenProject().getDescription();
        }
        if (desc == null) {
            desc = Bundle.LBL_DefaultDescription();
        }
        return desc;
    }

    void attachUpdater() {
        this.projectFolderUpdater.attachAll(this.getProjectDirectory());
        this.userFolderUpdater.attachAll(this.getHomeDirectory());
    }

    void detachUpdater() {
        this.projectFolderUpdater.detachAll();
        this.userFolderUpdater.detachAll();
    }

    public String getName() {
        return this.getOriginalMavenProject().getId().replace(':', '_');
    }

    public FileObject getProjectDirectory() {
        return this.folderFileObject;
    }

    public FileObject getHomeDirectory() {
        File homeFile = MavenCli.userMavenConfigurationHome;
        FileObject home = null;
        try {
            home = FileUtil.createFolder((File)homeFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (home == null) {
            LOG.log(Level.WARNING, "Cannot convert home dir to FileObject, some functionality won''t work. It''s usually the case on Windows and UNC paths. The path is {0}", homeFile);
        }
        return home;
    }

    @CheckForNull
    public String getArtifactRelativeRepositoryPath() {
        Artifact artifact = this.getOriginalMavenProject().getArtifact();
        if (artifact == null) {
            return null;
        }
        return this.getArtifactRelativeRepositoryPath(artifact);
    }

    @CheckForNull
    public String getTestArtifactRelativeRepositoryPath() {
        Artifact main = this.getOriginalMavenProject().getArtifact();
        if (main == null) {
            return null;
        }
        ArtifactHandlerManager artifactHandlerManager = (ArtifactHandlerManager)this.getEmbedder().lookupComponent(ArtifactHandlerManager.class);
        assert (artifactHandlerManager != null) : "ArtifactHandlerManager component not found in maven";
        DefaultArtifact test = new DefaultArtifact(main.getGroupId(), main.getArtifactId(), main.getVersionRange(), "test", "test-jar", "tests", artifactHandlerManager.getArtifactHandler("test-jar"));
        return this.getArtifactRelativeRepositoryPath((Artifact)test);
    }

    public String getArtifactRelativeRepositoryPath(@NonNull Artifact artifact) {
        String toRet = this.getEmbedder().getLocalRepository().pathOf(artifact);
        return toRet;
    }

    public MavenEmbedder getEmbedder() {
        return EmbedderFactory.getProjectEmbedder();
    }

    @NonNull
    public MavenProjectPropsImpl getAuxProps() {
        return this.auxprops;
    }

    public URI[] getSourceRoots(boolean test) {
        ArrayList<String> srcs = new ArrayList<String>();
        List s1 = test ? this.getOriginalMavenProject().getTestCompileSourceRoots() : this.getOriginalMavenProject().getCompileSourceRoots();
        srcs.addAll(s1);
        if (!test && this.getProjectDirectory().getFileObject("src/main/aspect") != null) {
            srcs.add(FileUtil.toFile((FileObject)this.getProjectDirectory().getFileObject("src/main/aspect")).getAbsolutePath());
        }
        URI[] uris = new URI[srcs.size() + 2];
        int count = 0;
        for (String str : srcs) {
            uris[count] = FileUtilities.convertStringToUri(str);
            ++count;
        }
        uris[uris.length - 2] = this.getScalaDirectory(test);
        uris[uris.length - 1] = this.getGroovyDirectory(test);
        return uris;
    }

    public URI[] getGeneratedSourceRoots(boolean test) {
        String[] buildHelpers;
        URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), test ? "target/generated-test-sources" : "target/generated-sources");
        HashSet<URI> uris = new HashSet<URI>();
        File[] roots = new File(uri).listFiles();
        if (roots != null) {
            for (File root : roots) {
                File[] kids = root.listFiles();
                if (kids == null || kids.length <= 0) continue;
                uris.add(root.toURI());
            }
        }
        if ((buildHelpers = PluginPropertyUtils.getPluginPropertyList(this, "org.codehaus.mojo", "build-helper-maven-plugin", "sources", "source", test ? "add-test-source" : "add-source")) != null && buildHelpers.length > 0) {
            File root = FileUtil.toFile((FileObject)this.getProjectDirectory());
            for (String helper : buildHelpers) {
                uris.add(FileUtilities.getDirURI(root, helper));
            }
        }
        return uris.toArray(new URI[uris.size()]);
    }

    public URI getWebAppDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-war-plugin", "warSourceDirectory", "war");
        prop = prop == null ? "src/main/webapp" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getSiteDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-site-plugin", "siteDirectory", "site");
        prop = prop == null ? "src/site" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getEarAppDirectory() {
        String prop = PluginPropertyUtils.getPluginProperty(this, "org.apache.maven.plugins", "maven-ear-plugin", "earSourceDirectory", "ear");
        prop = prop == null ? "src/main/application" : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getScalaDirectory(boolean test) {
        String prop = PluginPropertyUtils.getPluginProperty(this.getOriginalMavenProject(), "org.scala.tools", "scala-maven-plugin", "sourceDir", "compile");
        prop = prop == null ? (test ? "src/test/scala" : "src/main/scala") : prop;
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI getGroovyDirectory(boolean test) {
        String prop = test ? "src/test/groovy" : "src/main/groovy";
        return FileUtilities.getDirURI(this.getProjectDirectory(), prop);
    }

    public URI[] getResources(boolean test) {
        ArrayList<URI> toRet = new ArrayList<URI>();
        List res = test ? this.getOriginalMavenProject().getTestResources() : this.getOriginalMavenProject().getResources();
        for (Resource elem : res) {
            String dir = elem.getDirectory();
            if (dir == null || elem.getTargetPath() != null) continue;
            URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), dir);
            toRet.add(uri);
        }
        return toRet.toArray(new URI[toRet.size()]);
    }

    public File[] getOtherRoots(boolean test) {
        URI[] res;
        File[] fls;
        URI uri = FileUtilities.getDirURI(this.getProjectDirectory(), test ? "src/test" : "src/main");
        HashSet<File> toRet = new HashSet<File>();
        File fil = new File(uri);
        if (fil.exists() && (fls = fil.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !"java".equalsIgnoreCase(name) && !"webapp".equalsIgnoreCase(name) && !"groovy".equalsIgnoreCase(name) && !"scala".equalsIgnoreCase(name) && VisibilityQuery.getDefault().isVisible(new File(dir, name));
            }
        })) != null) {
            toRet.addAll(Arrays.asList(fls));
        }
        for (URI rs : res = this.getResources(test)) {
            File fl = new File(rs);
            if (!fl.exists()) continue;
            toRet.add(fl);
        }
        return toRet.toArray(new File[0]);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private boolean checkForForbiddenMergers(Lookup lkp) {
        Collection res = lkp.lookupAll(LookupMerger.class);
        for (LookupMerger lm : res) {
            if (ProjectInformation.class.equals((Object)lm.getMergeableClass())) {
                return false;
            }
            if (SharabilityQueryImplementation.class.equals((Object)lm.getMergeableClass())) {
                return false;
            }
            if (SubprojectProvider.class.equals((Object)lm.getMergeableClass())) {
                return false;
            }
            if (!NbMavenProject.class.equals((Object)lm.getMergeableClass())) continue;
            return false;
        }
        return true;
    }

    private Lookup createBasicLookup() {
        CPExtender extender = new CPExtender(this);
        Lookup staticLookup = Lookups.fixed((Object[])new Object[]{this.projectInfo, this, this.fileObject, new CacheDirProvider(this), new MavenForBinaryQueryImpl(this), new MavenBinaryForSourceQueryImpl(this), new ActionProviderImpl(this), this.auxiliary, this.auxprops, new MavenProjectPropsImpl.Merger(this.auxprops), this.profileHandler, this.configProvider, new CustomizerProviderImpl(this), new LogicalViewProviderImpl(this), this.cppProvider, this.sharability, new MavenTestForSourceImpl(this), this.subs, new MavenSourcesImpl(this), new RecommendedTemplatesImpl(this), new MavenSourceLevelImpl(this), new MavenAnnotationProcessingQueryImpl(this), this.problemReporter, this.watcher, new MavenFileEncodingQueryImpl(this), new TemplateAttrProvider(this), new OperationsImpl(this, this.state), new MavenDebuggerImpl(this), new DefaultReplaceTokenProvider(this), new MavenFileLocator(this), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new ProjectOpenedHookImpl(this)), UILookupMergerSupport.createPrivilegedTemplatesMerger(), UILookupMergerSupport.createRecommendedTemplatesMerger(), LookupProviderSupport.createSourcesMerger(), ProjectClassPathModifier.extenderForModifier((Project)this), extender, LookupMergerSupport.createClassPathModifierMerger(), new BackwardCompatibilityWithMevenideChecker(), new DebuggerChecker(), new CosChecker(this), CosChecker.createResultChecker(), CosChecker.createCoSHook(this), new ReactorChecker(), new PrereqCheckerMerger(), new TestChecker(), new RecommendedTemplates(){

            public String[] getRecommendedTypes() {
                return new String[]{"scala-classes"};
            }
        }});
        return staticLookup;
    }

    public int hashCode() {
        return this.getProjectDirectory().hashCode() * 13;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Project) {
            return this.getProjectDirectory().equals(((Project)obj).getProjectDirectory());
        }
        return false;
    }

    public String toString() {
        return "Maven[" + this.fileObject.getPath() + "]";
    }

    static {
        Class<NbMavenProject> c = NbMavenProject.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        statics = new Properties();
    }

    public static class RefreshAction
    extends AbstractAction
    implements ContextAwareAction {
        private final Lookup context;

        public RefreshAction() {
            this(Lookup.EMPTY);
        }

        private RefreshAction(Lookup lkp) {
            this.context = lkp;
            Collection col = this.context.lookupAll(NbMavenProjectImpl.class);
            if (col.size() > 1) {
                this.putValue("Name", Bundle.ACT_Reload_Projects(col.size()));
            } else {
                this.putValue("Name", Bundle.ACT_Reload_Project());
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            RELOAD_RP.post(new Runnable(){

                @Override
                public void run() {
                    EmbedderFactory.resetCachedEmbedders();
                    for (NbMavenProjectImpl prj : RefreshAction.this.context.lookupAll(NbMavenProjectImpl.class)) {
                        NbMavenProject.fireMavenProjectReload(prj);
                    }
                }
            });
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new RefreshAction(actionContext);
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] JAR_APPLICATION_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "web-service-clients", "REST-clients", "wsdl", "junit", "simple-files"};
        private static final String[] JAR_PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java", "Templates/GUIForms/JPanel.java", "Templates/GUIForms/JFrame.java", "Templates/WebServices/WebServiceClient"};
        private static final String[] POM_APPLICATION_TYPES = new String[]{"XML", "simple-files"};
        private static final String[] POM_PRIVILEGED_NAMES = new String[]{"Templates/XML/XMLWizard", "Templates/Other/Folder"};
        private static final String[] ALL_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "java-beans", "j2ee-types", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "web-service-clients", "REST-clients", "wsdl", "servlet-types", "web-types", "junit", "simple-files", "ear-types"};
        private static final String[] GENERIC_WEB_TYPES = new String[]{"java-classes", "java-main-class", "java-beans", "oasis-XML-catalogs", "XML", "wsdl", "junit", "simple-files"};
        private static final String[] GENERIC_EJB_TYPES = new String[]{"java-classes", "wsdl", "java-beans", "java-main-class", "oasis-XML-catalogs", "XML", "junit", "simple-files"};
        private static final String[] GENERIC_EAR_TYPES = new String[]{"XML", "wsdl", "simple-files"};
        private final List<String> prohibited;
        private final NbMavenProjectImpl project;

        RecommendedTemplatesImpl(NbMavenProjectImpl proj) {
            this.project = proj;
            this.prohibited = new ArrayList<String>();
            this.prohibited.add("ear");
            this.prohibited.add("ejb");
            this.prohibited.add("war");
            this.prohibited.add("nbm");
            this.prohibited.add("bundle");
        }

        public String[] getRecommendedTypes() {
            String packaging = this.project.getProjectWatcher().getPackagingType();
            if (packaging == null) {
                packaging = "jar";
            }
            if ("pom".equals(packaging = packaging.trim())) {
                if (ProjectUtils.getSources((Project)this.project).getSourceGroups("java").length > 0) {
                    return JAR_APPLICATION_TYPES;
                }
                return POM_APPLICATION_TYPES;
            }
            if ("jar".equals(packaging)) {
                return JAR_APPLICATION_TYPES;
            }
            if ("war".equals(packaging)) {
                return GENERIC_WEB_TYPES;
            }
            if ("ejb".equals(packaging)) {
                return GENERIC_EJB_TYPES;
            }
            if ("ear".equals(packaging)) {
                return GENERIC_EAR_TYPES;
            }
            if (this.prohibited.contains(packaging)) {
                return new String[0];
            }
            return ALL_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            String packaging = this.project.getProjectWatcher().getPackagingType();
            if (packaging == null) {
                packaging = "jar";
            }
            if ("pom".equals(packaging = packaging.trim())) {
                return POM_PRIVILEGED_NAMES;
            }
            if (this.prohibited.contains(packaging)) {
                return new String[0];
            }
            return JAR_PRIVILEGED_NAMES;
        }
    }

    private class Updater
    implements FileChangeListener {
        private String[] filesToWatch;
        private long lastTime = 0L;
        private FileObject folder;
        private final FileChangeListener listener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);

        Updater(String ... toWatch) {
            Arrays.sort(toWatch);
            this.filesToWatch = toWatch;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            String nameExt;
            if (!fileEvent.getFile().isFolder() && Arrays.binarySearch(this.filesToWatch, nameExt = fileEvent.getFile().getNameExt()) != -1 && this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            String nameExt;
            if (fileEvent.getFile().isFolder() && Arrays.binarySearch(this.filesToWatch, nameExt = fileEvent.getFile().getNameExt()) != -1 && this.lastTime < fileEvent.getTime()) {
                this.lastTime = System.currentTimeMillis();
                fileEvent.getFile().addFileChangeListener((FileChangeListener)this);
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (!fileEvent.getFile().isFolder()) {
                this.lastTime = System.currentTimeMillis();
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                NbMavenProject.fireMavenProjectReload(NbMavenProjectImpl.this);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        void attachAll(FileObject fo) {
            if (fo != null) {
                this.folder = fo;
                fo.addFileChangeListener(this.listener);
                for (String file : this.filesToWatch) {
                    FileObject fobj = fo.getFileObject(file);
                    if (fobj == null) continue;
                    fobj.addFileChangeListener(this.listener);
                }
            }
        }

        void detachAll() {
            if (this.folder != null) {
                this.folder.removeFileChangeListener(this.listener);
                for (String file : this.filesToWatch) {
                    FileObject fobj = this.folder.getFileObject(file);
                    if (fobj == null) continue;
                    fobj.removeFileChangeListener(this.listener);
                }
                this.folder = null;
            }
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        public void reset() {
            this.firePropertyChange("displayName");
            this.pcs.firePropertyChange("icon", null, this.getIcon());
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            String toReturn = NbMavenProjectImpl.this.getName();
            return toReturn;
        }

        public String getDisplayName() {
            MavenProject pr = NbMavenProjectImpl.this.getOriginalMavenProject();
            if (NbMavenProject.isErrorPlaceholder(pr)) {
                return Bundle.LBL_misconfigured_project(NbMavenProjectImpl.this.getProjectDirectory().getNameExt());
            }
            String toReturn = pr.getName();
            if (toReturn == null) {
                String grId = pr.getGroupId();
                String artId = pr.getArtifactId();
                toReturn = grId != null && artId != null ? grId + ":" + artId : Bundle.TXT_Maven_project_at(NbMavenProjectImpl.this.getProjectDirectory().getPath());
            }
            return toReturn;
        }

        public Icon getIcon() {
            SpecialIcon special = (SpecialIcon)NbMavenProjectImpl.this.getLookup().lookup(SpecialIcon.class);
            return special != null ? special.getIcon() : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif", (boolean)true);
        }

        public Project getProject() {
            return NbMavenProjectImpl.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private static class PackagingTypeDependentLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        private final NbMavenProject watcher;
        private final Lookup lookup;
        private String packaging;

        PackagingTypeDependentLookup(NbMavenProject watcher, Lookup lookup) {
            this.watcher = watcher;
            this.lookup = lookup;
            this.check();
            watcher.addPropertyChangeListener(this);
        }

        private void check() {
            String newPackaging = this.watcher.getPackagingType();
            if (newPackaging == null) {
                newPackaging = "jar";
            }
            if (!newPackaging.equals(this.packaging)) {
                this.packaging = newPackaging;
                this.setLookups(new Lookup[]{LookupProviderSupport.createCompositeLookup((Lookup)this.lookup, (String)("Projects/org-netbeans-modules-maven/" + this.packaging + "/Lookup"))});
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (NbMavenProjectImpl.PROP_PROJECT.equals(evt.getPropertyName())) {
                this.check();
            }
        }
    }

    private class LazyLookup
    extends ProxyLookup {
        private Lookup lookup;
        boolean initialized = false;

        LazyLookup(Project ths, NbMavenProject watcher, ProjectInformation info, SharabilityQueryImplementation shara, SubprojectProvider subs, FileObject projectFO) {
            this.setLookups(new Lookup[]{Lookups.fixed((Object[])new Object[]{ths, watcher, info, shara, subs, projectFO})});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beforeLookup(Lookup.Template<?> template) {
            LazyLookup lazyLookup = this;
            synchronized (lazyLookup) {
                if (!(this.initialized || ProjectInformation.class.equals((Object)template.getType()) || NbMavenProject.class.equals((Object)template.getType()) || NbMavenProjectImpl.class.equals((Object)template.getType()) || Project.class.equals((Object)template.getType()) || SharabilityQueryImplementation.class.equals((Object)template.getType()) || SubprojectProvider.class.equals((Object)template.getType()))) {
                    this.initialized = true;
                    this.lookup = NbMavenProjectImpl.this.createBasicLookup();
                    this.setLookups(new Lookup[]{this.lookup});
                    Lookup lkp = LookupProviderSupport.createCompositeLookup((Lookup)new PackagingTypeDependentLookup(NbMavenProjectImpl.this.watcher, this.lookup), (String)"Projects/org-netbeans-modules-maven/Lookup");
                    assert (NbMavenProjectImpl.this.checkForForbiddenMergers(lkp)) : "Cannot have a LookupMerger for ProjectInformation or SharabilityQueryImplementation";
                    this.setLookups(new Lookup[]{lkp});
                }
            }
            super.beforeLookup(template);
        }
    }

    public static abstract class WatcherAccessor {
        public abstract NbMavenProject createWatcher(NbMavenProjectImpl var1);

        public abstract void doFireReload(NbMavenProject var1);
    }
}

