/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.cos.CopyResourcesOnSave;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.problems.BatchProblemNotifier;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

class ProjectOpenedHookImpl
extends ProjectOpenedHook {
    private static final String PROP_BINARIES_CHECKED = "binariesChecked";
    private static final String PROP_JAVADOC_CHECKED = "javadocChecked";
    private static final String PROP_SOURCE_CHECKED = "sourceChecked";
    private final NbMavenProjectImpl project;
    private List<URI> uriReferences = new ArrayList<URI>();
    static final String UI_LOGGER_NAME = "org.netbeans.ui.maven.project";
    static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.maven.project");
    static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.maven";
    static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.maven");
    private static final Logger LOGGER = Logger.getLogger(ProjectOpenedHookImpl.class.getName());
    private static final AtomicBoolean checkedIndices = new AtomicBoolean();

    ProjectOpenedHookImpl(NbMavenProjectImpl proj) {
        this.project = proj;
    }

    protected void projectOpened() {
        this.checkBinaryDownloads();
        this.checkSourceDownloads();
        this.checkJavadocDownloads();
        this.project.attachUpdater();
        ProjectOpenedHookImpl.registerWithSubmodules(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), new HashSet<File>());
        HashSet<URI> uris = new HashSet<URI>();
        uris.addAll(Arrays.asList(this.project.getSourceRoots(false)));
        uris.addAll(Arrays.asList(this.project.getSourceRoots(true)));
        uris.addAll(Arrays.asList(this.project.getGeneratedSourceRoots(false)));
        uris.addAll(Arrays.asList(this.project.getGeneratedSourceRoots(true)));
        URI rootUri = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).toURI();
        File rootDir = new File(rootUri);
        for (URI uri : uris) {
            if (FileUtilities.getRelativePath(rootDir, new File(uri)) != null) continue;
            FileOwnerQuery.markExternalOwner((URI)uri, (Project)this.project, (int)0);
            this.uriReferences.add(uri);
        }
        ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().register("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        GlobalPathRegistry.getDefault().register("classpath/execute", cpProvider.getProjectClassPaths("classpath/execute"));
        BatchProblemNotifier.opened(this.project);
        LogRecord record = new LogRecord(Level.INFO, "UI_MAVEN_PROJECT_OPENED");
        record.setLoggerName(UI_LOGGER_NAME);
        record.setParameters(new Object[]{this.project.getProjectWatcher().getPackagingType()});
        record.setResourceBundle(NbBundle.getBundle(ProjectOpenedHookImpl.class));
        UI_LOGGER.log(record);
        record = new LogRecord(Level.INFO, "USG_PROJECT_OPEN_MAVEN");
        record.setLoggerName(USG_LOGGER_NAME);
        record.setParameters(new Object[]{this.project.getProjectWatcher().getPackagingType()});
        USG_LOGGER.log(record);
        MavenProject mp = this.project.getOriginalMavenProject();
        for (ArtifactRepository repo : mp.getRemoteArtifactRepositories()) {
            this.register(repo, mp.getModel().getRepositories());
        }
        for (ArtifactRepository repo : mp.getPluginArtifactRepositories()) {
            this.register(repo, mp.getModel().getPluginRepositories());
        }
        CopyResourcesOnSave.opened();
        if (checkedIndices.compareAndSet(false, true) && this.existsDefaultIndexLocation()) {
            final int freq = RepositoryPreferences.getInstance().getIndexUpdateFrequency();
            new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

                @Override
                public void run() {
                    List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
                    for (RepositoryInfo ri : ris) {
                        if (!ri.isRemoteDownloadable() && !ri.isLocal() || freq == 3) continue;
                        boolean run = false;
                        if (freq == 2) {
                            LOGGER.log(Level.FINER, "Index At Startup :{0}", ri.getId());
                            run = true;
                        } else if (freq == 1 && ProjectOpenedHookImpl.this.checkDiff(ri.getId(), 86400000L)) {
                            LOGGER.log(Level.FINER, "Index Once a Day :{0}", ri.getId());
                            run = true;
                        } else if (freq == 0 && ProjectOpenedHookImpl.this.checkDiff(ri.getId(), 604800000L)) {
                            LOGGER.log(Level.FINER, "Index once a Week :{0}", ri.getId());
                            run = true;
                        }
                        if (!run || !ri.isRemoteDownloadable()) continue;
                        RepositoryIndexer.indexRepo((RepositoryInfo)ri);
                    }
                }
            }, 120000);
        }
    }

    private void register(ArtifactRepository repo, List<Repository> definitions) {
        String id;
        String displayName = id = repo.getId();
        for (Repository r : definitions) {
            String n;
            if (!id.equals(r.getId()) || (n = r.getName()) == null) continue;
            displayName = n;
            break;
        }
        List mirrors = repo.getMirroredRepositories();
        try {
            RepositoryPreferences.getInstance().addTransientRepository((Object)this, id, displayName, mirrors.size() == 1 ? ((ArtifactRepository)mirrors.get(0)).getUrl() : repo.getUrl());
        }
        catch (URISyntaxException x) {
            LOGGER.log(Level.WARNING, "Ignoring repo with malformed URL: {0}", x.getMessage());
        }
    }

    private boolean existsDefaultIndexLocation() {
        File cacheDir = new File(Places.getCacheDirectory(), "mavenindex");
        return cacheDir.exists() && cacheDir.isDirectory();
    }

    private boolean checkDiff(String repoid, long amount) {
        Date date = RepositoryPreferences.getInstance().getLastIndexUpdate(repoid);
        Date now = new Date();
        LOGGER.log(Level.FINER, "Check Date Diff :{0}", repoid);
        LOGGER.log(Level.FINER, "Last Indexed Date :{0}", SimpleDateFormat.getInstance().format(date));
        LOGGER.log(Level.FINER, "Now :{0}", SimpleDateFormat.getInstance().format(now));
        long diff = now.getTime() - date.getTime();
        LOGGER.log(Level.FINER, "Diff :{0}", diff);
        return diff < 0L || diff > amount;
    }

    protected void projectClosed() {
        this.uriReferences.clear();
        this.project.detachUpdater();
        ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().unregister("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        GlobalPathRegistry.getDefault().unregister("classpath/execute", cpProvider.getProjectClassPaths("classpath/execute"));
        BatchProblemNotifier.closed(this.project);
        CopyResourcesOnSave.closed();
        RepositoryPreferences.getInstance().removeTransientRepositories((Object)this);
    }

    private void checkBinaryDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getBinaryDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.synchronousDependencyDownload();
            prefs.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_BINARIES_CHECKED, false))) {
            watcher.synchronousDependencyDownload();
            prefs.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void checkJavadocDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getJavadocDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.triggerSourceJavadocDownload(true);
            prefs.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_JAVADOC_CHECKED, false))) {
            watcher.triggerSourceJavadocDownload(true);
            prefs.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void checkSourceDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getSourceDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.triggerSourceJavadocDownload(false);
            prefs.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_SOURCE_CHECKED, false))) {
            watcher.triggerSourceJavadocDownload(false);
            prefs.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void registerWithSubmodules(File basedir, Set<File> registered) {
        Element project;
        block19: {
            if (!registered.add(basedir)) {
                return;
            }
            File pom = new File(basedir, "pom.xml");
            if (!pom.isFile()) {
                return;
            }
            try {
                project = XMLUtil.parse((InputSource)new InputSource(pom.toURI().toString()), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null).getDocumentElement();
            }
            catch (Exception x) {
                LOGGER.log(Level.FINE, "could not parse " + pom, x);
                return;
            }
            Element parent = XMLUtil.findElement((Element)project, (String)"parent", null);
            Element groupIdE = XMLUtil.findElement((Element)project, (String)"groupId", null);
            if (groupIdE == null && (groupIdE = XMLUtil.findElement((Element)parent, (String)"groupId", null)) == null) {
                LOGGER.log(Level.WARNING, "no groupId in {0}", pom);
                return;
            }
            String groupId = XMLUtil.findText((Node)groupIdE);
            Element artifactIdE = XMLUtil.findElement((Element)project, (String)"artifactId", null);
            if (artifactIdE == null && (artifactIdE = XMLUtil.findElement((Element)parent, (String)"artifactId", null)) == null) {
                LOGGER.log(Level.WARNING, "no artifactId in {0}", pom);
                return;
            }
            String artifactId = XMLUtil.findText((Node)artifactIdE);
            if (groupId.contains("${") || artifactId.contains("${")) {
                LOGGER.log(Level.FINE, "Unevaluated groupId/artifactId in {0}", basedir);
                FileObject basedirFO = FileUtil.toFileObject((File)basedir);
                if (basedirFO != null) {
                    try {
                        Project p = ProjectManager.getDefault().findProject(basedirFO);
                        if (p != null) {
                            NbMavenProjectImpl nbmp = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
                            if (nbmp != null) {
                                MavenFileOwnerQueryImpl.getInstance().registerProject(nbmp);
                            } else {
                                LOGGER.log(Level.FINE, "not a Maven project in {0}", basedir);
                            }
                            break block19;
                        }
                        LOGGER.log(Level.FINE, "no project in {0}", basedir);
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.FINE, null, x);
                    }
                } else {
                    LOGGER.log(Level.FINE, "no FileObject for {0}", basedir);
                }
            } else {
                try {
                    MavenFileOwnerQueryImpl.getInstance().registerCoordinates(groupId, artifactId, basedir.toURI().toURL());
                }
                catch (MalformedURLException x) {
                    LOGGER.log(Level.FINE, null, x);
                }
            }
        }
        ProjectOpenedHookImpl.scanForSubmodulesIn(project, basedir, registered);
        Element profiles = XMLUtil.findElement((Element)project, (String)"profiles", null);
        if (profiles != null) {
            for (Element profile : XMLUtil.findSubElements((Element)profiles)) {
                if (!profile.getTagName().equals("profile")) continue;
                ProjectOpenedHookImpl.scanForSubmodulesIn(profile, basedir, registered);
            }
        }
    }

    private static void scanForSubmodulesIn(Element projectOrProfile, File basedir, Set<File> registered) throws IllegalArgumentException {
        Element modules = XMLUtil.findElement((Element)projectOrProfile, (String)"modules", null);
        if (modules != null) {
            for (Element module : XMLUtil.findSubElements((Element)modules)) {
                if (!module.getTagName().equals("module")) continue;
                ProjectOpenedHookImpl.registerWithSubmodules(FileUtilities.resolveFilePath(basedir, XMLUtil.findText((Node)module)), registered);
            }
        }
    }
}

