/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.scm.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class CheckoutUI
extends JPanel {
    private static File lastFolder = new File(System.getProperty("user.home"));
    private final JButton checkoutButton;
    private Scm scm;
    private MavenProject project;
    private JButton btnFile;
    private ButtonGroup buttonGroup1;
    private JCheckBox chkPrintDebugInfo;
    private JRadioButton defaultConnection;
    private JRadioButton developerConnection;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblActhenticationHint;
    private JLabel lblAuthenticationDescription;
    private JLabel lblConnection;
    private JLabel lblDescription;
    private JLabel lblFolderError;
    private JLabel lblLocalFolder;
    private JLabel lblLocalFolderDescription;
    private JLabel lblPassword;
    private JLabel lblUser;
    private JTextField txtFolder;
    private JPasswordField txtPassword;
    private JTextField txtUrl;
    private JTextField txtUser;

    public CheckoutUI(MavenProject proj) {
        this.project = proj;
        this.scm = proj.getScm();
        StringBuilder buffer = new StringBuilder();
        buffer.append("<b>");
        buffer.append(proj.getArtifactId());
        buffer.append("</b>");
        buffer.append(":");
        buffer.append("<b>");
        buffer.append(proj.getVersion());
        buffer.append("</b>");
        this.initComponents();
        this.lblDescription.setText(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Description", (Object)buffer.toString()));
        this.checkoutButton = new JButton(NbBundle.getMessage(CheckoutUI.class, (String)"BTN_Checkout"));
        this.load();
        this.txtFolder.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CheckoutUI.this.validateFolder();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CheckoutUI.this.validateFolder();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CheckoutUI.this.validateFolder();
            }
        });
        this.txtFolder.setText(ProjectChooser.getProjectsFolder().getAbsolutePath() + File.separator + this.project.getArtifactId());
    }

    private void validateFolder() {
        File file = new File(this.txtFolder.getText().trim());
        if (file.exists() && file.list() != null && file.list().length > 0) {
            this.checkoutButton.setEnabled(false);
            this.lblFolderError.setForeground(Color.red);
            this.lblFolderError.setText(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Folder_Error"));
        } else {
            this.lblFolderError.setText(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Folder"));
            this.checkoutButton.setEnabled(true);
            this.lblFolderError.setForeground(Color.BLACK);
        }
    }

    private void load() {
        if (this.scm.getConnection() != null) {
            this.defaultConnection.setSelected(true);
            this.txtUrl.setText(this.scm.getConnection());
        } else {
            this.defaultConnection.setEnabled(false);
        }
        if (this.scm.getDeveloperConnection() == null) {
            this.developerConnection.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblDescription = new JLabel();
        this.lblConnection = new JLabel();
        this.defaultConnection = new JRadioButton();
        this.developerConnection = new JRadioButton();
        this.lblLocalFolderDescription = new JLabel();
        this.txtFolder = new JTextField();
        this.btnFile = new JButton();
        this.lblLocalFolder = new JLabel();
        this.lblAuthenticationDescription = new JLabel();
        this.lblUser = new JLabel();
        this.txtUser = new JTextField();
        this.lblPassword = new JLabel();
        this.txtPassword = new JPasswordField();
        this.lblActhenticationHint = new JLabel();
        this.chkPrintDebugInfo = new JCheckBox();
        this.txtUrl = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblFolderError = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Description"));
        this.lblConnection.setForeground(new Color(0, 0, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblConnection, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Connection"));
        this.buttonGroup1.add(this.defaultConnection);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultConnection, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_DefaultConnection"));
        this.defaultConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckoutUI.this.defaultConnectionActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.developerConnection);
        Mnemonics.setLocalizedText((AbstractButton)this.developerConnection, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_DeveloperConnection"));
        this.developerConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckoutUI.this.developerConnectionActionPerformed(evt);
            }
        });
        this.lblLocalFolderDescription.setForeground(new Color(0, 0, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblLocalFolderDescription, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_LocalFolderDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFile, (String)NbBundle.getMessage(CheckoutUI.class, (String)"BTN_Browse"));
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckoutUI.this.btnFileActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblLocalFolder, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_LocalFolder"));
        this.lblAuthenticationDescription.setForeground(new Color(0, 0, 102));
        Mnemonics.setLocalizedText((JLabel)this.lblAuthenticationDescription, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_AuthenticationDescription"));
        Mnemonics.setLocalizedText((JLabel)this.lblUser, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_User"));
        Mnemonics.setLocalizedText((JLabel)this.lblPassword, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Password"));
        Mnemonics.setLocalizedText((JLabel)this.lblActhenticationHint, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_ActhenticationHint"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkPrintDebugInfo, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_PrintDebugInfo"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CheckoutUI.class, (String)"CheckoutUI.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CheckoutUI.class, (String)"CheckoutUI.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblFolderError, (String)NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Folder"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLocalFolderDescription, -1, 707, Short.MAX_VALUE).addComponent(this.chkPrintDebugInfo).addComponent(this.lblDescription, -1, 707, Short.MAX_VALUE).addComponent(this.lblAuthenticationDescription, -2, 297, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblUser).addComponent(this.lblPassword)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtPassword, -1, 174, Short.MAX_VALUE).addComponent(this.txtUser, -1, 174, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblActhenticationHint).addGap(166, 166, 166)).addComponent(this.lblConnection, -1, 707, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblLocalFolder).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblFolderError, -1, 586, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.txtFolder, -1, 488, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnFile)))).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.defaultConnection, -1, 97, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel2, -1, 556, Short.MAX_VALUE)).addComponent(this.txtUrl, GroupLayout.Alignment.TRAILING, -1, 566, Short.MAX_VALUE).addComponent(this.developerConnection, -2, 122, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblDescription, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblConnection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.developerConnection).addComponent(this.defaultConnection)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtUrl, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addComponent(this.lblLocalFolderDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnFile).addComponent(this.lblLocalFolder).addComponent(this.txtFolder, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.lblFolderError, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAuthenticationDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUser).addComponent(this.txtUser, -2, -1, -2).addComponent(this.lblActhenticationHint)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.chkPrintDebugInfo).addGap(18, 18, 18)));
    }

    private void btnFileActionPerformed(ActionEvent evt) {
        int ret;
        File fil;
        JFileChooser chooser = new JFileChooser(lastFolder);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(NbBundle.getMessage(CheckoutUI.class, (String)"TIT_Choose"));
        chooser.setMultiSelectionEnabled(false);
        if (this.txtFolder.getText().trim().length() > 0 && (fil = new File(this.txtFolder.getText().trim())).exists()) {
            chooser.setSelectedFile(fil);
        }
        if ((ret = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Select"))) == 0) {
            this.txtFolder.setText(chooser.getSelectedFile().getAbsolutePath());
            this.txtFolder.requestFocusInWindow();
        }
    }

    private void defaultConnectionActionPerformed(ActionEvent evt) {
        if (this.defaultConnection.isEnabled()) {
            this.txtUrl.setText(this.scm.getConnection());
        }
    }

    private void developerConnectionActionPerformed(ActionEvent evt) {
        if (this.developerConnection.isEnabled()) {
            this.txtUrl.setText(this.scm.getDeveloperConnection());
        }
    }

    public File getCheckoutDirectory() {
        return FileUtil.normalizeFile((File)new File(this.txtFolder.getText().trim()));
    }

    public RunConfig getRunConfig() {
        BeanRunConfig brc = new BeanRunConfig();
        brc.setExecutionDirectory(this.getCheckoutDirectory().getParentFile());
        ArrayList<String> goals = new ArrayList<String>();
        goals.add(MavenCommandSettings.getDefault().getCommand("scmCheckout"));
        brc.setGoals(goals);
        brc.setTaskDisplayName(NbBundle.getMessage(CheckoutUI.class, (String)"LBL_Checkout", (Object)(this.project.getArtifactId() + " : " + this.project.getVersion())));
        brc.setExecutionName(brc.getTaskDisplayName());
        brc.setProperty("checkoutDirectory", this.getCheckoutDirectory().getAbsolutePath());
        brc.setProperty("connectionUrl", this.txtUrl.getText());
        if (this.txtUser.getText().trim().length() != 0) {
            brc.setProperty("username", this.txtUser.getText());
            brc.setProperty("password ", new String(this.txtPassword.getPassword()));
        }
        brc.setShowDebug(this.chkPrintDebugInfo.isSelected());
        brc.setShowError(this.chkPrintDebugInfo.isSelected());
        brc.setOffline(false);
        brc.setUpdateSnapshots(false);
        brc.setActivatedProfiles(Collections.<String>emptyList());
        brc.setInteractive(true);
        brc.setActionName("scm-checkout");
        return brc;
    }

    public JButton getCheckoutButton() {
        return this.checkoutButton;
    }
}

