/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.execute;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenCommandLineExecutor;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.LifecycleManager;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class RunUtils {
    private RunUtils() {
    }

    @CheckForNull
    public static ExecutorTask run(RunConfig config) {
        for (PrerequisitesChecker elem : config.getProject().getLookup().lookupAll(PrerequisitesChecker.class)) {
            if (!elem.checkRunConfig(config)) {
                return null;
            }
            if (config.getPreExecution() == null || elem.checkRunConfig(config.getPreExecution())) continue;
            return null;
        }
        return RunUtils.executeMaven(config);
    }

    public static ExecutorTask executeMaven(final RunConfig config) {
        LifecycleManager.getDefault().saveAll();
        MavenCommandLineExecutor exec = new MavenCommandLineExecutor(config);
        ExecutorTask task = RunUtils.executeMavenImpl(config.getTaskDisplayName(), exec);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task _) {
                MavenProject mp = config.getMavenProject();
                if (mp == null) {
                    return;
                }
                ArrayList<Artifact> arts = new ArrayList<Artifact>();
                Artifact main = mp.getArtifact();
                if (main != null) {
                    arts.add(main);
                }
                arts.addAll(mp.getArtifacts());
                RepositoryIndexer.updateIndexWithArtifacts((RepositoryInfo)RepositoryPreferences.getInstance().getLocalRepository(), arts);
            }
        });
        return task;
    }

    public static RunConfig createRunConfig(File execDir, Project prj, String displayName, List<String> goals) {
        BeanRunConfig brc = new BeanRunConfig();
        brc.setExecutionName(displayName);
        brc.setExecutionDirectory(execDir);
        brc.setProject(prj);
        brc.setTaskDisplayName(displayName);
        brc.setGoals(goals);
        return brc;
    }

    private static ExecutorTask executeMavenImpl(String runtimeName, MavenExecutor exec) {
        ExecutorTask task = ExecutionEngine.getDefault().execute(runtimeName, (Runnable)exec, exec.getInputOutput());
        exec.setTask(task);
        return task;
    }

    public static boolean hasApplicationCompileOnSaveEnabled(Project prj) {
        AuxiliaryProperties auxprops = (AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class);
        if (auxprops == null) {
            return false;
        }
        String cos = auxprops.get("netbeans.compile.on.save", true);
        return cos != null && ("all".equalsIgnoreCase(cos) || "app".equalsIgnoreCase(cos));
    }

    public static boolean hasApplicationCompileOnSaveEnabled(RunConfig config) {
        Project prj = config.getProject();
        if (prj != null) {
            return RunUtils.hasApplicationCompileOnSaveEnabled(prj);
        }
        return false;
    }

    public static boolean hasTestCompileOnSaveEnabled(Project prj) {
        AuxiliaryProperties auxprops = (AuxiliaryProperties)prj.getLookup().lookup(AuxiliaryProperties.class);
        if (auxprops == null) {
            return true;
        }
        String cos = auxprops.get("netbeans.compile.on.save", true);
        return cos == null || "all".equalsIgnoreCase(cos) || "test".equalsIgnoreCase(cos);
    }

    public static boolean hasTestCompileOnSaveEnabled(RunConfig config) {
        Project prj = config.getProject();
        if (prj != null) {
            return RunUtils.hasTestCompileOnSaveEnabled(prj);
        }
        return false;
    }
}

