/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class CPExtender
extends ProjectClassPathModifierImplementation {
    private NbMavenProjectImpl project;
    private static final String POM_XML = "pom.xml";
    public static final String CLASSPATH_COMPILE_ONLY = "classpath/compile_only";

    public CPExtender(NbMavenProjectImpl project) {
        this.project = project;
    }

    private boolean addRemoveLibrary(Library library, POMModel model, String scope, boolean add) throws IOException {
        Boolean modified = this.checkLibraryForPoms(library, model, scope, add);
        if (modified == null) {
            List urls = library.getContent("classpath");
            modified = urls.size() > 0;
            assert (model != null);
            for (URL url : urls) {
                File jar = FileUtil.archiveOrDirForURL((URL)url);
                if (jar == null) {
                    throw new IOException("Could find no file corresponding to " + url);
                }
                if (jar.isDirectory()) {
                    throw new IOException("Cannot add folders to Maven projects as dependencies: " + url);
                }
                modified = modified != false && this.addRemoveJAR(jar, model, scope, add);
            }
        }
        return modified;
    }

    private boolean addRemoveJAR(File jar, POMModel mdl, String scope, boolean add) throws IOException {
        if (!add) {
            throw new UnsupportedOperationException("removing JARs not yet supported");
        }
        NBVersionInfo dep = null;
        for (NBVersionInfo _dep : RepositoryQueries.findBySHA1((File)jar, (List)RepositoryPreferences.getInstance().getRepositoryInfos())) {
            if ("unknown.binary".equals(_dep.getGroupId())) continue;
            dep = _dep;
            break;
        }
        if (dep == null) {
            dep = new NBVersionInfo(null, "unknown.binary", jar.getName().replaceFirst("[.]jar$", ""), "SNAPSHOT", null, null, null, null, null);
            this.addJarToPrivateRepo(jar, mdl, dep);
        }
        boolean added = false;
        Dependency dependency = ModelUtils.checkModelDependency(mdl, dep.getGroupId(), dep.getArtifactId(), false);
        if (dependency == null) {
            dependency = ModelUtils.checkModelDependency(mdl, dep.getGroupId(), dep.getArtifactId(), true);
            added = true;
        }
        if (!org.openide.util.Utilities.compareObjects((Object)dep.getVersion(), (Object)dependency.getVersion())) {
            dependency.setVersion(dep.getVersion());
            added = true;
        }
        if (!org.openide.util.Utilities.compareObjects((Object)scope, (Object)dependency.getScope())) {
            dependency.setScope(scope);
            added = true;
        }
        return added;
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private Boolean checkLibraryForPoms(Library library, POMModel model, String scope, boolean add) {
        if (!"j2se".equals(library.getType())) {
            return null;
        }
        Boolean modified = null;
        for (URL pom : library.getContent("maven-pom")) {
            Repository reposit;
            ModelUtils.LibraryDescriptor result = ModelUtils.checkLibrary(pom);
            if (result == null) continue;
            modified = false;
            Dependency dep = ModelUtils.checkModelDependency(model, result.getGroupId(), result.getArtifactId(), false);
            if (!add) {
                if (dep == null || !org.openide.util.Utilities.compareObjects((Object)result.getVersion(), (Object)dep.getVersion()) || !org.openide.util.Utilities.compareObjects((Object)scope, (Object)dep.getScope()) || !org.openide.util.Utilities.compareObjects((Object)result.getClassifier(), (Object)dep.getClassifier())) break;
                model.removeChildComponent((Component)dep);
                modified = true;
                break;
            }
            if (dep == null) {
                dep = ModelUtils.checkModelDependency(model, result.getGroupId(), result.getArtifactId(), true);
                modified = true;
            }
            if (!org.openide.util.Utilities.compareObjects((Object)result.getVersion(), (Object)dep.getVersion())) {
                dep.setVersion(result.getVersion());
                modified = true;
            }
            if (!org.openide.util.Utilities.compareObjects((Object)scope, (Object)dep.getScope())) {
                dep.setScope(scope);
                modified = true;
            }
            if (!org.openide.util.Utilities.compareObjects((Object)result.getClassifier(), (Object)dep.getClassifier())) {
                dep.setClassifier(result.getClassifier());
                modified = true;
            }
            if ((reposit = ModelUtils.addModelRepository(this.project.getOriginalMavenProject(), model, result.getRepoRoot())) == null) continue;
            reposit.setId(library.getName());
            reposit.setLayout(result.getRepoType());
            reposit.setName("Repository for library " + library);
            modified = true;
        }
        return modified;
    }

    public SourceGroup[] getExtensibleSourceGroups() {
        SourceGroup[] web;
        SourceGroup[] res;
        Sources s = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (s != null);
        ArrayList<SourceGroup> grps = new ArrayList<SourceGroup>();
        SourceGroup[] java = s.getSourceGroups("java");
        if (java != null) {
            grps.addAll(Arrays.asList(java));
        }
        if ((res = s.getSourceGroups("resources")) != null) {
            grps.addAll(Arrays.asList(res));
        }
        if ((web = s.getSourceGroups("doc_root")) != null) {
            grps.addAll(Arrays.asList(web));
        }
        return grps.toArray(new SourceGroup[0]);
    }

    public String[] getExtensibleClassPathTypes(SourceGroup arg0) {
        return new String[]{"classpath/compile", "classpath/execute", CLASSPATH_COMPILE_ONLY, "classpath/processor"};
    }

    public boolean addLibraries(Library[] libraries, SourceGroup grp, String type) throws IOException {
        return this.addRemoveLibraries(libraries, grp, type, true);
    }

    public boolean removeLibraries(Library[] libraries, SourceGroup grp, String type) throws IOException {
        return this.addRemoveLibraries(libraries, grp, type, false);
    }

    private boolean addRemoveLibraries(final Library[] libraries, SourceGroup grp, String type, final boolean add) throws IOException {
        final AtomicBoolean modified = new AtomicBoolean();
        final String scope = CPExtender.findScope(grp, type);
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                for (Library library : libraries) {
                    try {
                        modified.compareAndSet(false, CPExtender.this.addRemoveLibrary(library, model, scope, add));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (modified.get()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return modified.get();
    }

    public boolean addRoots(final URL[] urls, SourceGroup grp, String type) throws IOException {
        final AtomicBoolean added = new AtomicBoolean();
        final String scope = CPExtender.findScope(grp, type);
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                for (URL url : urls) {
                    File jar = FileUtil.archiveOrDirForURL((URL)url);
                    if (jar != null && jar.isFile()) {
                        try {
                            added.compareAndSet(false, CPExtender.this.addRemoveJAR(jar, model, scope, true));
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        continue;
                    }
                    Logger.getLogger(CPExtender.class.getName()).log(Level.INFO, "Adding non-jar root to Maven projects makes no sense. ({0})", url);
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (added.get()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
        return added.get();
    }

    protected boolean addProjects(final Project[] projects, SourceGroup sg, String classPathType) throws IOException, UnsupportedOperationException {
        final AtomicBoolean added = new AtomicBoolean();
        final AtomicBoolean nonMavenError = new AtomicBoolean();
        final String scope = CPExtender.findScope(sg, classPathType);
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Set arts = CPExtender.this.project.getOriginalMavenProject().getArtifacts();
                for (Project prj : projects) {
                    NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                    if (nbprj != null) {
                        MavenProject mp = nbprj.getMavenProject();
                        String id = mp.getArtifact().getId();
                        for (Artifact a : arts) {
                            if (!a.getId().equals(id)) continue;
                        }
                        Dependency dependency = ModelUtils.checkModelDependency(model, mp.getGroupId(), mp.getArtifactId(), true);
                        dependency.setVersion(mp.getVersion());
                        if (scope != null) {
                            dependency.setScope(scope);
                        } else if ("ejb".equals(nbprj.getPackagingType()) || "war".equals(nbprj.getPackagingType())) {
                            dependency.setScope("provided");
                        }
                        added.set(true);
                        continue;
                    }
                    nonMavenError.set(true);
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject(POM_XML);
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (nonMavenError.get()) {
            throw new UnsupportedOperationException("Attempting to add a non-Maven project dependency to a Maven project, not supported.");
        }
        return added.get();
    }

    public boolean removeRoots(URL[] arg0, SourceGroup arg1, String arg2) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing binary dependencies is not supported by Maven projects.");
    }

    public boolean addAntArtifacts(AntArtifact[] arg0, URI[] arg1, SourceGroup arg2, String arg3) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add Ant based projects as subprojects to Maven projects.");
    }

    public boolean removeAntArtifacts(AntArtifact[] arg0, URI[] arg1, SourceGroup arg2, String arg3) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove Ant based projects as subprojects from Maven projects.");
    }

    private static String findScope(SourceGroup grp, String type) {
        String scope = "classpath/execute".equals(type) ? "runtime" : null;
        String name = grp.getName();
        if ("2TestSourceRoot".equals(name)) {
            scope = "test";
        }
        if (scope == null && (CLASSPATH_COMPILE_ONLY.equals(type) || "classpath/processor".equals(type))) {
            scope = "provided";
        }
        return scope;
    }

    private void addJarToPrivateRepo(File jar, POMModel mdl, NBVersionInfo dep) throws IOException {
        FileObject file;
        String name;
        List repos = mdl.getProject().getRepositories();
        boolean found = false;
        String path = null;
        if (repos != null) {
            for (Repository repo : repos) {
                if (!"unknown-jars-temp-repo".equals(repo.getId())) continue;
                found = true;
                String url = repo.getUrl();
                if (url.startsWith("file:${project.basedir}/")) {
                    path = url.substring("file:${project.basedir}/".length());
                    break;
                }
                path = "lib";
                break;
            }
        }
        if (!found) {
            Repository repo = mdl.getFactory().createRepository();
            repo.setId("unknown-jars-temp-repo");
            repo.setName("A temporary repository created by NetBeans for libraries and jars it could not identify. Please replace the dependencies in this repository with correct ones and delete this repository.");
            repo.setUrl("file:${project.basedir}/lib");
            mdl.getProject().addRepository(repo);
            path = "lib";
        }
        assert (path != null);
        FileObject root = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), path);
        FileObject grp = FileUtil.createFolder((FileObject)root, (String)dep.getGroupId().replace('.', '/'));
        FileObject art = FileUtil.createFolder((FileObject)grp, (String)dep.getArtifactId());
        FileObject ver = FileUtil.createFolder((FileObject)art, (String)dep.getVersion());
        if (ver.getFileObject(name = dep.getArtifactId() + '-' + dep.getVersion(), (file = FileUtil.toFileObject((File)jar)).getExt()) == null) {
            FileUtil.copyFile((FileObject)file, (FileObject)ver, (String)name, (String)file.getExt());
        }
    }
}

