/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.Bundle;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.OutputTabMaintainer;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public abstract class AbstractMavenExecutor
extends OutputTabMaintainer<TabContext>
implements MavenExecutor,
Cancellable {
    protected RunConfig config;
    private TabContext tabContext = new TabContext();
    private List<String> messages = new ArrayList<String>();
    private List<OutputListener> listeners = new ArrayList<OutputListener>();
    protected ExecutorTask task;
    private static final Set<String> forbidden = new HashSet<String>();
    protected MavenItem item;
    protected final Object SEMAPHORE = new Object();

    @Override
    protected Class<TabContext> tabContextType() {
        return TabContext.class;
    }

    protected AbstractMavenExecutor(RunConfig conf) {
        super(conf.getExecutionName());
        this.config = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setTask(ExecutorTask task) {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            this.task = task;
            this.item = new MavenItem();
            this.SEMAPHORE.notifyAll();
        }
    }

    @Override
    public final void addInitialMessage(String line, OutputListener listener) {
        this.messages.add(line);
        this.listeners.add(listener);
    }

    protected final void processInitialMessage() {
        Iterator<String> it1 = this.messages.iterator();
        Iterator<OutputListener> it2 = this.listeners.iterator();
        InputOutput ioput = this.getInputOutput();
        try {
            while (it1.hasNext()) {
                OutputListener ol = it2.next();
                if (ol != null) {
                    ioput.getErr().println(it1.next(), ol, true);
                    continue;
                }
                ioput.getErr().println(it1.next());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected final void actionStatesAtStart() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.rerun.setEnabled(false);
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.rerunDebug.setEnabled(false);
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.resume.setFinder(null);
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.stop.setEnabled(true);
            }
        });
    }

    protected final void actionStatesAtFinish(final @NullAllowed ResumeFromFinder resumeFromFinder) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.rerun.setEnabled(true);
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.rerunDebug.setEnabled(true);
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.resume.setFinder(resumeFromFinder);
                ((AbstractMavenExecutor)AbstractMavenExecutor.this).tabContext.stop.setEnabled(false);
            }
        });
    }

    @Override
    protected void reassignAdditionalContext(TabContext tabContext) {
        this.tabContext = tabContext;
        tabContext.rerun.setConfig(this.config);
        tabContext.rerunDebug.setConfig(this.config);
        tabContext.resume.setConfig(this.config);
        tabContext.stop.setExecutor(this);
    }

    public static Properties excludeNetBeansProperties(Properties props) {
        Properties toRet = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (forbidden.contains(entry.getKey())) continue;
            toRet.put(entry.getKey(), entry.getValue());
        }
        return toRet;
    }

    @Override
    protected final TabContext createContext() {
        return this.tabContext.clone();
    }

    @Override
    protected Action[] createNewTabActions() {
        this.tabContext.rerun = new ReRunAction(false);
        this.tabContext.rerunDebug = new ReRunAction(true);
        this.tabContext.resume = new ResumeAction();
        this.tabContext.stop = new StopAction();
        this.tabContext.options = new OptionsAction();
        this.tabContext.rerun.setConfig(this.config);
        this.tabContext.rerunDebug.setConfig(this.config);
        this.tabContext.resume.setConfig(this.config);
        this.tabContext.stop.setExecutor(this);
        return new Action[]{this.tabContext.rerun, this.tabContext.rerunDebug, this.tabContext.resume, this.tabContext.stop, this.tabContext.options};
    }

    static {
        forbidden.add("netbeans.logger.console");
        forbidden.add("java.util.logging.config.class");
        forbidden.add("netbeans.autoupdate.language");
        forbidden.add("netbeans.dirs");
        forbidden.add("netbeans.home");
        forbidden.add("sun.awt.exception.handler");
        forbidden.add("org.openide.TopManager.GUI");
        forbidden.add("org.openide.major.version");
        forbidden.add("netbeans.autoupdate.variant");
        forbidden.add("netbeans.dynamic.classpath");
        forbidden.add("netbeans.autoupdate.country");
        forbidden.add("netbeans.hash.code");
        forbidden.add("org.openide.TopManager");
        forbidden.add("org.openide.version");
        forbidden.add("netbeans.buildnumber");
        forbidden.add("javax.xml.parsers.DocumentBuilderFactory");
        forbidden.add("javax.xml.parsers.SAXParserFactory");
        forbidden.add("rave.build");
        forbidden.add("netbeans.accept_license_class");
        forbidden.add("rave.version");
        forbidden.add("netbeans.autoupdate.version");
        forbidden.add("netbeans.importclass");
        forbidden.add("netbeans.user");
    }

    private class MavenItem
    implements BuildExecutionSupport.Item {
        private MavenItem() {
        }

        public String getDisplayName() {
            return AbstractMavenExecutor.this.config.getTaskDisplayName();
        }

        public void repeatExecution() {
            RunUtils.executeMaven(AbstractMavenExecutor.this.config);
        }

        public boolean isRunning() {
            return !AbstractMavenExecutor.this.task.isFinished();
        }

        public void stopRunning() {
            AbstractMavenExecutor.this.cancel();
        }
    }

    private static final class OptionsAction
    extends AbstractAction {
        OptionsAction() {
            super(Bundle.LBL_OptionsAction(), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/options.png", (boolean)true));
            this.putValue("ShortDescription", Bundle.LBL_OptionsAction());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDisplayer.getDefault().open("Advanced/Maven");
        }
    }

    static class StopAction
    extends AbstractAction {
        private AbstractMavenExecutor exec;

        StopAction() {
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/stop.png", (boolean)false));
            this.putValue("Name", Bundle.TXT_Stop_execution());
            this.putValue("ShortDescription", Bundle.TIP_Stop_Execution());
            this.setEnabled(false);
        }

        void setExecutor(AbstractMavenExecutor ex) {
            this.exec = ex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    StopAction.this.exec.cancel();
                }
            });
        }
    }

    private static class ResumeAction
    extends AbstractAction {
        private static final RequestProcessor RP = new RequestProcessor(ResumeAction.class);
        private RunConfig config;
        private ResumeFromFinder finder;

        ResumeAction() {
            this.setEnabled(false);
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/forward.png", (boolean)true));
            this.putValue("ShortDescription", Bundle.TIP_resume());
        }

        void setConfig(RunConfig config) {
            this.config = config;
        }

        void setFinder(ResumeFromFinder finder) {
            this.finder = finder;
            this.setEnabled(finder != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final Project p = this.config.getProject();
            if (p == null) {
                this.setFinder(null);
                StatusDisplayer.getDefault().setStatusText(Bundle.ResumeAction_could_not_find_module());
                return;
            }
            final AtomicReference t = new AtomicReference();
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)Bundle.ResumeAction_scanning(), (Cancellable)new Cancellable(){

                public boolean cancel() {
                    Thread _t = (Thread)t.get();
                    if (_t != null) {
                        _t.interrupt();
                        return true;
                    }
                    return false;
                }
            });
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    NbMavenProject nbmp;
                    t.set(Thread.currentThread());
                    handle.start();
                    try {
                        nbmp = ResumeAction.this.finder.find(p);
                    }
                    finally {
                        handle.finish();
                    }
                    t.set(null);
                    if (nbmp == null || NbMavenProject.isErrorPlaceholder(nbmp.getMavenProject())) {
                        ResumeAction.this.setFinder(null);
                        StatusDisplayer.getDefault().setStatusText(Bundle.ResumeAction_could_not_find_module());
                        return;
                    }
                    File root = ResumeAction.this.config.getExecutionDirectory();
                    File module = nbmp.getMavenProject().getBasedir();
                    String rel = root != null && module != null ? FileUtilities.relativizeFile(root, module) : null;
                    String id = rel != null ? rel : nbmp.getMavenProject().getGroupId() + ':' + nbmp.getMavenProject().getArtifactId();
                    BeanRunConfig newConfig = new BeanRunConfig(ResumeAction.this.config);
                    ArrayList<String> goals = new ArrayList<String>(ResumeAction.this.config.getGoals());
                    int rf = goals.indexOf("--resume-from");
                    if (rf != -1) {
                        goals.set(rf + 1, id);
                    } else {
                        goals.add(0, "--resume-from");
                        goals.add(1, id);
                    }
                    newConfig.setGoals(goals);
                    RunUtils.executeMaven(newConfig);
                }
            });
        }
    }

    static class ReRunAction
    extends AbstractAction {
        private RunConfig config;
        private boolean debug;

        ReRunAction(boolean debug) {
            this.debug = debug;
            this.putValue("SmallIcon", debug ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refreshdebug.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refresh.png", (boolean)false));
            this.putValue("Name", debug ? Bundle.TXT_Rerun_extra() : Bundle.TXT_Rerun());
            this.putValue("ShortDescription", debug ? Bundle.TIP_Rerun_Extra() : Bundle.TIP_Rerun());
            this.setEnabled(false);
        }

        void setConfig(RunConfig config) {
            this.config = config;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.debug) {
                RunGoalsPanel pnl = new RunGoalsPanel();
                DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Run_maven());
                pnl.readConfig(this.config);
                Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (retValue == DialogDescriptor.OK_OPTION) {
                    BeanRunConfig newConfig = new BeanRunConfig(this.config);
                    pnl.applyValues(newConfig);
                    RunUtils.executeMaven(newConfig);
                }
            } else {
                BeanRunConfig newConfig = new BeanRunConfig(this.config);
                RunUtils.executeMaven(newConfig);
            }
        }
    }

    protected static interface ResumeFromFinder {
        @CheckForNull
        public NbMavenProject find(@NonNull Project var1);
    }

    static final class TabContext {
        ReRunAction rerun;
        ReRunAction rerunDebug;
        ResumeAction resume;
        StopAction stop;
        OptionsAction options;

        TabContext() {
        }

        protected TabContext clone() {
            TabContext c = new TabContext();
            c.rerun = this.rerun;
            c.rerunDebug = this.rerunDebug;
            c.resume = this.resume;
            c.stop = this.stop;
            c.options = this.options;
            return c;
        }
    }
}

