/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.maven.model.Build;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.NbGlobalActionGoalProvider;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Writer;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public final class ActionToGoalUtils {
    private static final String FO_ATTR_CUSTOM_MAPP = "customActionMappings";
    public static ContextAccessor ACCESSOR;

    private ActionToGoalUtils() {
    }

    public static RunConfig createRunConfig(String action, NbMavenProjectImpl project, Lookup lookup) {
        String goal;
        Build bld;
        M2ConfigProvider configs = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
        RunConfig rc = configs.getActiveConfiguration().createConfigForDefaultAction(action, project, lookup);
        if (rc == null && ("build".equals(action) || "rebuild".equals(action)) && (bld = project.getOriginalMavenProject().getBuild()) != null && (goal = bld.getDefaultGoal()) != null && goal.trim().length() > 0) {
            BeanRunConfig brc = new BeanRunConfig();
            brc.setExecutionDirectory(FileUtil.toFile((FileObject)project.getProjectDirectory()));
            brc.setProject(project);
            StringTokenizer tok = new StringTokenizer(goal, " ", false);
            ArrayList<String> toRet = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                toRet.add(tok.nextToken());
            }
            if ("rebuild".equals(action)) {
                toRet.add(0, "clean");
            }
            brc.setGoals(toRet);
            brc.setExecutionName(ProjectUtils.getInformation((Project)project).getDisplayName());
            brc.setActivatedProfiles(Collections.<String>emptyList());
            rc = brc;
        }
        if (rc == null) {
            MavenActionsProvider add;
            Iterator i$ = Lookup.getDefault().lookupAll(MavenActionsProvider.class).iterator();
            while (i$.hasNext() && (!(add = (MavenActionsProvider)i$.next()).isActionEnable(action, project, lookup) || (rc = add.createConfigForDefaultAction(action, project, lookup)) == null)) {
            }
        }
        if (rc != null) {
            ArrayList<String> acts = new ArrayList<String>();
            acts.addAll(rc.getActivatedProfiles());
            acts.addAll(configs.getActiveConfiguration().getActivatedProfiles());
            rc.setActivatedProfiles(acts);
        }
        return rc;
    }

    public static boolean isActionEnable(String action, NbMavenProjectImpl project, Lookup lookup) {
        String goal;
        Build bld;
        M2ConfigProvider configs = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
        if (configs.getActiveConfiguration().isActionEnable(action, project, lookup)) {
            return true;
        }
        if (configs.getDefaultConfig().isActionEnable(action, project, lookup)) {
            return true;
        }
        if (("build".equals(action) || "rebuild".equals(action)) && (bld = project.getOriginalMavenProject().getBuild()) != null && (goal = bld.getDefaultGoal()) != null && goal.trim().length() > 0) {
            return true;
        }
        for (MavenActionsProvider add : Lookup.getDefault().lookupAll(MavenActionsProvider.class)) {
            if (!add.isActionEnable(action, project, lookup)) continue;
            return true;
        }
        return false;
    }

    public static NetbeansActionMapping getActiveMapping(String action, Project project, M2Configuration configuration) {
        NetbeansActionMapping na = null;
        if (configuration != null) {
            na = configuration.getMappingForAction(action, project);
        }
        if (na == null) {
            na = ActionToGoalUtils.getDefaultMapping(action, project);
        }
        return na;
    }

    public static NetbeansActionMapping[] getActiveCustomMappings(NbMavenProjectImpl project) {
        M2ConfigProvider configs = (M2ConfigProvider)project.getLookup().lookup(M2ConfigProvider.class);
        ArrayList<NetbeansActionMapping> toRet = new ArrayList<NetbeansActionMapping>();
        ArrayList<String> names = new ArrayList<String>();
        for (NetbeansActionMapping map : configs.getActiveConfiguration().getCustomMappings()) {
            toRet.add(map);
            names.add(map.getActionName());
        }
        for (NetbeansActionMapping map : configs.getDefaultConfig().getCustomMappings()) {
            if (names.contains(map.getActionName())) continue;
            toRet.add(map);
            names.add(map.getActionName());
        }
        for (MavenActionsProvider prov : Lookup.getDefault().lookupAll(MavenActionsProvider.class)) {
            if (!(prov instanceof NbGlobalActionGoalProvider)) continue;
            for (NetbeansActionMapping map : ((NbGlobalActionGoalProvider)prov).getCustomMappings()) {
                if (names.contains(map.getActionName())) continue;
                toRet.add(map);
            }
        }
        return toRet.toArray(new NetbeansActionMapping[toRet.size()]);
    }

    public static NetbeansActionMapping getDefaultMapping(String action, Project project) {
        MavenActionsProvider add;
        NetbeansActionMapping na = null;
        Lookup.Result res = Lookup.getDefault().lookup(new Lookup.Template(MavenActionsProvider.class));
        Iterator i$ = res.allInstances().iterator();
        while (i$.hasNext() && (na = (add = (MavenActionsProvider)i$.next()).getMappingForAction(action, project)) == null) {
        }
        return na;
    }

    public static ActionToGoalMapping readMappingsFromFileAttributes(FileObject fo) {
        String string = (String)fo.getAttribute(FO_ATTR_CUSTOM_MAPP);
        ActionToGoalMapping mapp = null;
        if (string != null) {
            NetbeansBuildActionXpp3Reader reader = new NetbeansBuildActionXpp3Reader();
            try {
                mapp = reader.read(new StringReader(string));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (XmlPullParserException ex) {
                ex.printStackTrace();
            }
        }
        if (mapp == null) {
            mapp = new ActionToGoalMapping();
        }
        return mapp;
    }

    public static void writeMappingsToFileAttributes(FileObject fo, ActionToGoalMapping mapp) {
        NetbeansBuildActionXpp3Writer writer = new NetbeansBuildActionXpp3Writer();
        StringWriter string = new StringWriter();
        boolean error = false;
        try {
            writer.write(string, mapp);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            error = true;
        }
        if (!error) {
            try {
                fo.setAttribute(FO_ATTR_CUSTOM_MAPP, (Object)string.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static File resolveProjectExecutionBasedir(NetbeansActionMapping mapp, Project prj) {
        File base = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        if (mapp.getBasedir() != null) {
            base = FileUtilities.resolveFilePath(base, mapp.getBasedir());
        }
        return base;
    }

    static {
        block3: {
            ACCESSOR = null;
            Class<ExecutionContext> c = ExecutionContext.class;
            try {
                Class.forName(c.getName(), true, c.getClassLoader());
            }
            catch (Exception ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ex);
            }
        }
        assert (ACCESSOR != null);
    }

    public static abstract class ContextAccessor {
        public abstract ExecutionContext createContext(InputOutput var1, ProgressHandle var2);
    }
}

