/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.modules.maven.nodes.DependenciesNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class BootCPNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(final Project p) {
        return new AbstractMavenNodeList<Void>(){

            public List<Void> keys() {
                return ProjectUtils.getSources((Project)p).getSourceGroups("java").length == 0 ? Collections.emptyList() : Collections.singletonList(null);
            }

            public Node node(Void _) {
                return new BootCPNode(p);
            }
        };
    }

    private static Node jarNode(Project p, final FileObject root) {
        return PackageView.createPackageView((SourceGroup)new SourceGroup(){

            public FileObject getRootFolder() {
                return root;
            }

            public String getName() {
                return root.getNameExt();
            }

            public String getDisplayName() {
                File f = null;
                try {
                    f = FileUtil.archiveOrDirForURL((URL)root.getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                if (f != null) {
                    return f.getName();
                }
                return FileUtil.getFileDisplayName((FileObject)root);
            }

            public Icon getIcon(boolean opened) {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/api/common/project/ui/resources/jar.gif", (boolean)true);
            }

            public boolean contains(FileObject file) {
                return true;
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }
        });
    }

    private static class CPChildren
    extends ChildFactory.Detachable<FileObject>
    implements PropertyChangeListener {
        private final Project p;
        private final ClassPath cp;

        CPChildren(Project p, ClassPath cp) {
            this.p = p;
            this.cp = cp;
        }

        protected void addNotify() {
            this.cp.addPropertyChangeListener((PropertyChangeListener)this);
        }

        protected void removeNotify() {
            this.cp.removePropertyChangeListener((PropertyChangeListener)this);
        }

        protected boolean createKeys(List<FileObject> roots) {
            roots.addAll(Arrays.asList(this.cp.getRoots()));
            return true;
        }

        protected Node createNodeForKey(FileObject root) {
            return BootCPNodeFactory.jarNode(this.p, root);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("roots")) {
                this.refresh(false);
            }
        }
    }

    private static class JRENode
    extends AbstractNode {
        JRENode(Project p) {
            this(p, ((ActiveJ2SEPlatformProvider)p.getLookup().lookup(ActiveJ2SEPlatformProvider.class)).getJavaPlatform());
        }

        private JRENode(Project p, JavaPlatform jp) {
            super(Children.create((ChildFactory)new CPChildren(p, jp.getBootstrapLibraries()), (boolean)true));
            this.setDisplayName(jp.getDisplayName());
            this.setIconBaseWithExtension("org/netbeans/modules/java/api/common/project/ui/resources/platform.gif");
        }
    }

    private static class BootCPChildren
    extends ChildFactory.Detachable<FileObject>
    implements PropertyChangeListener {
        private final Project p;
        private ClassPath[] endorsed;
        private static final FileObject BOOT = FileUtil.createMemoryFileSystem().getRoot();

        BootCPChildren(Project p) {
            this.p = p;
        }

        protected void addNotify() {
            for (ClassPath cp : this.endorsed = ((ProjectSourcesClassPathProvider)this.p.getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectClassPaths("classpath/endorsed")) {
                cp.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        protected void removeNotify() {
            for (ClassPath cp : this.endorsed) {
                cp.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.endorsed = null;
        }

        protected boolean createKeys(List<FileObject> roots) {
            roots.add(BOOT);
            for (ClassPath cp : this.endorsed) {
                roots.addAll(Arrays.asList(cp.getRoots()));
            }
            return true;
        }

        protected Node createNodeForKey(FileObject root) {
            if (root == BOOT) {
                return new JRENode(this.p);
            }
            return BootCPNodeFactory.jarNode(this.p, root);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("roots")) {
                this.refresh(false);
            }
        }
    }

    private static class BootCPNode
    extends AbstractNode {
        BootCPNode(Project p) {
            super(Children.create((ChildFactory)new BootCPChildren(p), (boolean)false));
            this.setName("BootCPNode");
            this.setDisplayName(Bundle.BootCPNode_displayName());
        }

        public Image getIcon(int param) {
            return ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(false), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        }

        public Image getOpenedIcon(int param) {
            return ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(true), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        }
    }
}

