/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SourcesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        NbMavenProjectImpl prj = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        return new NList(prj);
    }

    private static class NList
    extends AbstractMavenNodeList<SourceGroup>
    implements ChangeListener {
        private static final RequestProcessor RP = new RequestProcessor(NList.class);
        private NbMavenProjectImpl project;

        private NList(NbMavenProjectImpl prj) {
            this.project = prj;
        }

        public List<SourceGroup> keys() {
            SourceGroup[] javagroup;
            ArrayList<SourceGroup> list = new ArrayList<SourceGroup>();
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            for (SourceGroup sg : javagroup = srcs.getSourceGroups("java")) {
                list.add(sg);
            }
            return list;
        }

        public Node node(SourceGroup group) {
            Project owner = FileOwnerQuery.getOwner((FileObject)group.getRootFolder());
            if (owner != this.project) {
                if (owner == null) {
                    Logger.getLogger(SourcesNodeFactory.class.getName()).log(Level.INFO, "Cannot find a project owner for folder " + group.getRootFolder());
                    return null;
                }
                AbstractNode erroNode = new AbstractNode(Children.LEAF);
                ProjectInformation info = (ProjectInformation)owner.getLookup().lookup(ProjectInformation.class);
                String prjText = info != null ? info.getDisplayName() : FileUtil.getFileDisplayName((FileObject)owner.getProjectDirectory());
                erroNode.setDisplayName(NbBundle.getMessage(SourcesNodeFactory.class, (String)"ERR_WrongSG", (Object)group.getDisplayName(), (Object)prjText));
                return erroNode;
            }
            return PackageView.createPackageView((SourceGroup)group);
        }

        @Override
        public void addNotify() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            srcs.addChangeListener((ChangeListener)this);
        }

        @Override
        public void removeNotify() {
            Sources srcs = ProjectUtils.getSources((Project)this.project);
            srcs.removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    NList.this.fireChange();
                }
            });
        }
    }
}

