/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.output.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class GlobalOutputProcessor
implements OutputProcessor {
    private static final String SECTION_PROJECT = "project-execute";
    static final Pattern DOWNLOAD = Pattern.compile("^(\\d+(/\\d*)? ?(M|K|b|KB|B|\\?)\\s*)+$");
    private static final Pattern LOW_MVN = Pattern.compile("(.*)Error resolving version for (.*): Plugin requires Maven version (.*)");
    private static final Pattern HELP = Pattern.compile("\\[Help \\d+\\] (https?://.+)");
    static final Pattern MODEL_PROBLEM = Pattern.compile(".+ @ (?:\\S+, (.+), )?line (\\d+), column (\\d+)");
    private static final Logger LOG = Logger.getLogger(GlobalOutputProcessor.class.getName());
    private final RunConfig config;

    GlobalOutputProcessor(RunConfig config) {
        this.config = config;
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return new String[]{SECTION_PROJECT};
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        if (DOWNLOAD.matcher(line).matches()) {
            visitor.skipLine();
            return;
        }
        if ("BUILD SUCCESSFUL".equals(line)) {
            visitor.setColor(Color.GREEN.darker().darker());
            return;
        }
        if (LOW_MVN.matcher(line).matches()) {
            visitor.setLine(line + '\n' + Bundle.TXT_ChangeSettings());
            visitor.setColor(Color.RED);
            visitor.setOutputListener(new OutputListener(){

                public void outputLineSelected(OutputEvent ev) {
                }

                public void outputLineAction(OutputEvent ev) {
                    OptionsDisplayer.getDefault().open("Advanced/Maven");
                }

                public void outputLineCleared(OutputEvent ev) {
                }
            });
            return;
        }
        final Matcher m = HELP.matcher(line);
        if (m.matches()) {
            visitor.setOutputListener(new OutputListener(){

                public void outputLineAction(OutputEvent ev) {
                    try {
                        HtmlBrowser.URLDisplayer.getDefault().showURLExternal(new URL(m.group(1)));
                    }
                    catch (MalformedURLException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }

                public void outputLineSelected(OutputEvent ev) {
                }

                public void outputLineCleared(OutputEvent ev) {
                }
            });
            return;
        }
        final Matcher m2 = MODEL_PROBLEM.matcher(line);
        if (m2.matches()) {
            visitor.setOutputListener(new OutputListener(){

                public void outputLineAction(OutputEvent ev) {
                    DataObject pomDO;
                    String loc = m2.group(1);
                    File pom = loc == null ? new File(GlobalOutputProcessor.this.config.getExecutionDirectory(), "pom.xml") : FileUtil.normalizeFile((File)new File(loc));
                    FileObject pomFO = FileUtil.toFileObject((File)pom);
                    if (pomFO == null) {
                        LOG.log(Level.WARNING, "no such file: {0}", pom);
                        return;
                    }
                    int line = Integer.parseInt(m2.group(2));
                    int column = Integer.parseInt(m2.group(3));
                    try {
                        pomDO = DataObject.find((FileObject)pomFO);
                    }
                    catch (DataObjectNotFoundException x) {
                        LOG.log(Level.INFO, null, x);
                        return;
                    }
                    LineCookie lc = (LineCookie)pomDO.getLookup().lookup(LineCookie.class);
                    if (lc == null) {
                        LOG.log(Level.WARNING, "no LineCookie in {0}", pom);
                        return;
                    }
                    try {
                        lc.getLineSet().getOriginal(line - 1).show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, column - 1);
                    }
                    catch (IndexOutOfBoundsException x) {
                        LOG.log(Level.WARNING, "no such line {0} in {1}: {2}", new Object[]{line, pom, x});
                    }
                }

                public void outputLineSelected(OutputEvent ev) {
                }

                public void outputLineCleared(OutputEvent ev) {
                }
            });
        }
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        if (!sequenceId.startsWith(SECTION_PROJECT)) {
            visitor.setLine("[" + sequenceId.substring("mojo-execute#".length()) + "]");
            visitor.setColor(Color.GRAY);
        }
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }
}

