/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.URL;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenAnnotationProcessingQueryImpl
implements AnnotationProcessingQueryImplementation {
    private final NbMavenProjectImpl prj;

    public MavenAnnotationProcessingQueryImpl(NbMavenProjectImpl prj) {
        this.prj = prj;
    }

    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(FileObject file) {
        return new AnnotationProcessingQuery.Result(){

            public Set<? extends AnnotationProcessingQuery.Trigger> annotationProcessingEnabled() {
                String version = PluginPropertyUtils.getPluginVersion(MavenAnnotationProcessingQueryImpl.this.prj.getOriginalMavenProject(), "org.apache.maven.plugins", "maven-compiler-plugin");
                if (version != null && new ComparableVersion(version).compareTo(new ComparableVersion("2.2")) < 0) {
                    return EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
                }
                String compilerArgument = PluginPropertyUtils.getPluginProperty(MavenAnnotationProcessingQueryImpl.this.prj, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", null);
                if ("-proc:none".equals(compilerArgument)) {
                    return EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
                }
                return EnumSet.allOf(AnnotationProcessingQuery.Trigger.class);
            }

            public Iterable<? extends String> annotationProcessorsToRun() {
                return null;
            }

            public URL sourceOutputDirectory() {
                String generatedSourcesDirectory = PluginPropertyUtils.getPluginProperty(MavenAnnotationProcessingQueryImpl.this.prj, "org.apache.maven.plugins", "maven-compiler-plugin", "generatedSourcesDirectory", null);
                if (generatedSourcesDirectory == null) {
                    generatedSourcesDirectory = "${project.build.directory}/generated-sources/annotations";
                }
                try {
                    return FileUtil.urlForArchiveOrDir((File)new File((String)PluginPropertyUtils.createEvaluator(MavenAnnotationProcessingQueryImpl.this.prj.getOriginalMavenProject()).evaluate(generatedSourcesDirectory)));
                }
                catch (ExpressionEvaluationException ex) {
                    return null;
                }
            }

            public Map<? extends String, ? extends String> processorOptions() {
                LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                options.put("eclipselink.canonicalmodel.use_static_factory", "false");
                return options;
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }
        };
    }
}

