/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui.pda;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.pim.Contact;
import javax.microedition.pim.Event;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.ToDo;

public class PIMBrowser
extends List
implements CommandListener {
    public static final Command SELECT_PIM_ITEM = new Command("Select", 4, 1);
    private int listType = 1;
    private final Command details = new Command("Details", 8, 1);
    private final Command selectList = new Command("Select", 4, 1);
    private final Command back = new Command("Back", 2, 1);
    private Display display;
    private String selectedList;
    private PIMItem selectedItem;
    private CommandListener commandListener;

    public PIMBrowser(Display display, int listType) {
        super("", 3);
        this.display = display;
        this.listType = listType;
        super.setCommandListener((CommandListener)this);
        this.showLists();
    }

    private void showLists() {
        new Thread(new Runnable(){

            public void run() {
                String[] lists = PIM.getInstance().listPIMLists(PIMBrowser.this.listType);
                if (lists.length == 0) {
                    PIMBrowser.this.reportError("No lists for requested PIM type");
                    return;
                }
                if (lists.length == 1) {
                    PIMBrowser.this.loadList(lists[0]);
                    return;
                }
                PIMBrowser.this.setTitle("select list");
                for (int i = 0; i < lists.length; ++i) {
                    PIMBrowser.this.append(lists[i], null);
                }
                PIMBrowser.this.setSelectCommand(PIMBrowser.this.selectList);
            }
        }).start();
    }

    private void reportException(Exception e) {
        this.reportError(e.getMessage());
    }

    private void reportError(String error) {
        Alert alert = new Alert(error, error, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.display.setCurrent(alert, (Displayable)this);
    }

    protected CommandListener getCommandListener() {
        return this.commandListener;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    private void doDismiss() {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            commandListener.commandAction(SELECT_PIM_ITEM, (Displayable)this);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.equals(this.back)) {
            this.removeCommand(this.back);
            this.removeCommand(this.details);
            this.showLists();
        } else if (command.equals(this.selectList)) {
            new Thread(new Runnable(){

                public void run() {
                    PIMBrowser.this.loadList(PIMBrowser.this.getString(PIMBrowser.this.getSelectedIndex()));
                }
            }).start();
            this.addCommand(this.back);
        } else if (command.equals(this.details)) {
            new Thread(new Runnable(){

                public void run() {
                    PIMBrowser.this.selectedItem = PIMBrowser.this.getItem(PIMBrowser.this.selectedList, PIMBrowser.this.getString(PIMBrowser.this.getSelectedIndex()));
                    PIMBrowser.this.showItem(PIMBrowser.this.selectedItem);
                }
            }).start();
        } else if (command.equals(SELECT_PIM_ITEM)) {
            new Thread(new Runnable(){

                public void run() {
                    PIMBrowser.this.selectedItem = PIMBrowser.this.getItem(PIMBrowser.this.selectedList, PIMBrowser.this.getString(PIMBrowser.this.getSelectedIndex()));
                    PIMBrowser.this.doDismiss();
                }
            }).start();
        } else if (this.commandListener != null) {
            this.commandListener.commandAction(command, displayable);
        }
    }

    public int getListType() {
        return this.listType;
    }

    public PIMItem getSelectedItem() {
        return this.selectedItem;
    }

    private void loadList(String listName) {
        this.selectedList = listName;
        Form form = new Form("Loading PIM list");
        form.append("Please wait...");
        this.display.setCurrent((Displayable)form);
        this.deleteAll();
        this.openList(this.selectedList);
    }

    private void openList(String listName) {
        try {
            PIMList list = PIM.getInstance().openPIMList(this.listType, 3, listName);
            if (this.getTitle() == null || this.getTitle().equals("")) {
                this.setTitle(list.getName());
            }
            int fieldCode = this.getFieldCode(this.listType);
            Enumeration items = list.items();
            while (items.hasMoreElements()) {
                this.append(((PIMItem)items.nextElement()).getString(fieldCode, 0), null);
            }
            if (this.size() == 0) {
                this.reportError("List: " + listName + " is Empty");
                return;
            }
            this.addCommand(this.details);
            this.setSelectCommand(SELECT_PIM_ITEM);
            this.display.setCurrent((Displayable)this);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    private PIMItem getItem(String listName, String itemName) {
        try {
            Enumeration items = PIM.getInstance().openPIMList(this.listType, 3, listName).items();
            int fieldCode = this.getFieldCode(this.listType);
            while (items.hasMoreElements()) {
                PIMItem current = (PIMItem)items.nextElement();
                String name = current.getString(fieldCode, 0);
                if (!name.equals(itemName)) continue;
                return current;
            }
        }
        catch (Exception e) {
            this.reportException(e);
        }
        return null;
    }

    private int getFieldCode(int listType) {
        int fieldCode = 0;
        switch (listType) {
            case 1: {
                fieldCode = 105;
                break;
            }
            case 2: {
                fieldCode = 107;
                break;
            }
            case 3: {
                fieldCode = 107;
            }
        }
        return fieldCode;
    }

    private void showItem(PIMItem selectedItem) {
        ItemDisplayScreen screen = new ItemDisplayScreen(selectedItem);
        this.display.setCurrent((Displayable)screen);
    }

    class ItemDisplayScreen
    extends Form
    implements CommandListener {
        private final Command backCommand = new Command("Back", 2, 1);
        private final PIMItem item;
        private final Hashtable fieldTable = new Hashtable();

        public ItemDisplayScreen(PIMItem item) {
            super("PIM Item");
            this.item = item;
            try {
                this.populateForm();
            }
            catch (PIMException ex) {
                ex.printStackTrace();
            }
            this.addCommand(this.backCommand);
            this.setCommandListener(this);
        }

        private boolean isClassField(int field) {
            return this.item instanceof Contact && field == 102 || this.item instanceof Event && field == 101 || this.item instanceof ToDo && field == 100;
        }

        private void populateForm() throws PIMException {
            this.deleteAll();
            this.fieldTable.clear();
            int[] fields = this.item.getPIMList().getSupportedFields();
            for (int i = 0; i < fields.length; ++i) {
                int field = fields[i];
                if (this.isClassField(field) || this.item.countValues(field) == 0) continue;
                int dataType = this.item.getPIMList().getFieldDataType(field);
                String label = this.item.getPIMList().getFieldLabel(field);
                StringItem formItem = null;
                switch (dataType) {
                    case 4: {
                        String sValue = this.item.getString(field, 0);
                        if (sValue == null) {
                            sValue = "";
                        }
                        formItem = new StringItem(label, sValue);
                        break;
                    }
                    case 1: {
                        formItem = new StringItem(label, this.item.getBoolean(field, 0) ? "yes" : "no");
                        break;
                    }
                    case 5: {
                        String[] a = this.item.getStringArray(field, 0);
                        if (a == null) break;
                        formItem = new StringItem(label, this.joinStringArray(a));
                        break;
                    }
                    case 2: {
                        long time = this.item.getDate(field, 0);
                        int style = 3;
                        if (this.item instanceof Contact) {
                            switch (field) {
                                case 101: {
                                    style = 1;
                                }
                            }
                        }
                        formItem = new DateField(label, style);
                        ((DateField)formItem).setDate(new Date(time));
                        break;
                    }
                    case 3: {
                        formItem = new StringItem(label, String.valueOf(this.item.getInt(field, 0)));
                        break;
                    }
                    case 0: {
                        byte[] data = this.item.getBinary(field, 0);
                        if (data == null) break;
                        formItem = new StringItem(label, data.length + " bytes");
                        break;
                    }
                }
                this.append((Item)formItem);
            }
        }

        public void commandAction(Command c, Displayable d) {
            if (c == this.backCommand) {
                PIMBrowser.this.showLists();
                PIMBrowser.this.display.setCurrent((Displayable)PIMBrowser.this);
            }
        }

        private String joinStringArray(String[] a) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == null || a[i].length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(a[i]);
            }
            return sb.toString();
        }
    }
}

