/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;
import org.openide.util.Exceptions;

public class LineBreakHook
implements TypedBreakInterceptor {
    private static final Logger LOG = Logger.getLogger(LineBreakHook.class.getName());

    private void repositionCaret(TypedBreakInterceptor.Context context) throws BadLocationException {
        if (!(context.getDocument() instanceof BaseDocument)) {
            return;
        }
        BaseDocument doc = (BaseDocument)context.getDocument();
        int insertPos = context.getCaretOffset();
        int caretPos = context.getComponent().getCaretPosition();
        int lineStartPos = Utilities.getRowStart((BaseDocument)doc, (int)insertPos);
        int nonWhiteBefore = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)insertPos, (int)lineStartPos);
        if (nonWhiteBefore == -1) {
            return;
        }
        int lineEndPos = Utilities.getRowEnd((BaseDocument)doc, (int)caretPos);
        int nonWhiteAfter = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)caretPos, (int)lineEndPos);
        if (nonWhiteAfter == -1) {
            return;
        }
        TokenHierarchy h = TokenHierarchy.get((Document)doc);
        TokenSequence seq = h.tokenSequence();
        seq.move(nonWhiteBefore + 1);
        int closingIndex = this.followsOpeningTag(seq);
        if (closingIndex == -1) {
            return;
        }
        seq.move(nonWhiteAfter);
        if (!this.precedesClosingTag(seq)) {
            return;
        }
        int startClosingLine = Utilities.getRowStart((BaseDocument)doc, (int)nonWhiteAfter);
        if (startClosingLine == lineStartPos) {
            return;
        }
        int nextLineStart = Utilities.getRowStart((BaseDocument)doc, (int)insertPos, (int)1);
        if (nextLineStart >= startClosingLine) {
            return;
        }
        int newCaretPos = Utilities.getRowEnd((BaseDocument)doc, (int)nextLineStart);
        context.getComponent().getCaret().setDot(newCaretPos);
    }

    public void afterInsert(final TypedBreakInterceptor.Context context) throws BadLocationException {
        context.getDocument().render(new Runnable(){

            @Override
            public void run() {
                try {
                    LineBreakHook.this.repositionCaret(context);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private boolean precedesClosingTag(TokenSequence seq) {
        if (!seq.moveNext()) {
            return false;
        }
        Token tukac = seq.token();
        if (tukac.id() != XMLTokenId.TAG) {
            return false;
        }
        String text = ((Object)tukac.text()).toString();
        return text.startsWith("</");
    }

    private int followsOpeningTag(TokenSequence seq) {
        int closingIndex = -1;
        block5: while (seq.movePrevious()) {
            Token tukac = seq.token();
            switch ((XMLTokenId)tukac.id()) {
                case ARGUMENT: 
                case OPERATOR: 
                case VALUE: {
                    if (closingIndex == -1) {
                        return -1;
                    }
                }
                case WS: {
                    continue block5;
                }
                case TAG: {
                    String text = ((Object)tukac.text()).toString();
                    if (">".equals(text)) {
                        if (closingIndex > -1) {
                            return -1;
                        }
                        closingIndex = seq.offset() + tukac.length();
                        continue block5;
                    }
                    if (text.startsWith("<") && text.length() > 1 && text.charAt(1) != '/') {
                        return closingIndex;
                    }
                    return -1;
                }
            }
            return -1;
        }
        return -1;
    }

    public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void cancelled(TypedBreakInterceptor.Context context) {
    }

    public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
    }

    public static class F
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new LineBreakHook();
        }
    }
}

