/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.xml.text.navigator.FilterActions;
import org.netbeans.modules.xml.text.navigator.FiltersDescription;
import org.netbeans.modules.xml.text.navigator.FiltersManager;
import org.netbeans.modules.xml.text.navigator.NavigatorTreeCellRenderer;
import org.netbeans.modules.xml.text.navigator.TapPanel;
import org.netbeans.modules.xml.text.navigator.TreeNodeAdapter;
import org.netbeans.modules.xml.text.navigator.base.AbstractXMLNavigatorContent;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class NavigatorContent
extends AbstractXMLNavigatorContent {
    private static final boolean DEBUG = false;
    static boolean showAttributes = true;
    static boolean showContent = true;
    private DataObject peerDO = null;
    private WeakHashMap uiCache = new WeakHashMap();
    private boolean editorOpened = false;
    private static final RequestProcessor RP = new RequestProcessor(NavigatorContent.class);

    public NavigatorContent() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void navigate(DataObject d) {
        EditorCookie ec;
        if (this.peerDO != null && this.peerDO != d) {
            this.closeDocument(this.peerDO);
        }
        if ((ec = (EditorCookie)d.getCookie(EditorCookie.class)) == null) {
            ErrorManager.getDefault().log(1, "The DataObject " + d.getName() + "(class=" + d.getClass().getName() + ") has no EditorCookie!?");
        } else {
            try {
                BaseDocument bdoc = (BaseDocument)ec.openDocument();
                if (bdoc != null) {
                    this.navigate(d, bdoc);
                    this.peerDO = d;
                    this.editorOpened = ec.getOpenedPanes() != null && ec.getOpenedPanes().length > 0;
                }
            }
            catch (UserQuestionException uqe) {
                this.showError(AbstractXMLNavigatorContent.ERROR_TOO_LARGE_DOCUMENT);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public void navigate(final DataObject documentDO, final BaseDocument bdoc) {
        NavigatorContentPanel cachedPanel;
        this.showWaitPanel();
        WeakReference panelWR = (WeakReference)this.uiCache.get(documentDO);
        if (panelWR != null) {
            NavigatorContentPanel cp = (NavigatorContentPanel)panelWR.get();
            if (cp != null) {
                NavigatorContentPanel navigatorContentPanel = cachedPanel = bdoc == cp.getDocument() ? cp : null;
                if (cachedPanel == null) {
                    this.uiCache.remove(documentDO);
                }
            } else {
                cachedPanel = null;
            }
        } else {
            cachedPanel = null;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    final DocumentModel model = cachedPanel == null && bdoc.getLength() != 0 ? DocumentModel.getDocumentModel((Document)bdoc) : null;
                    if (cachedPanel != null || model != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                NavigatorContent.this.showWaitPanel();
                                JPanel panel = null;
                                if (cachedPanel == null) {
                                    try {
                                        model.readLock();
                                        panel = new NavigatorContentPanel(model);
                                        NavigatorContent.this.uiCache.put(documentDO, new WeakReference<JPanel>(panel));
                                        EditorCookie.Observable eco = (EditorCookie.Observable)documentDO.getCookie(EditorCookie.Observable.class);
                                        if (eco != null) {
                                            eco.addPropertyChangeListener((PropertyChangeListener)NavigatorContent.this);
                                        }
                                        ErrorManager.getDefault().log(1, "The DataObject " + documentDO.getName() + "(class=" + documentDO.getClass().getName() + ") has no EditorCookie.Observable!");
                                    }
                                    finally {
                                        model.readUnlock();
                                    }
                                } else {
                                    panel = cachedPanel;
                                }
                                NavigatorContent.this.removeAll();
                                NavigatorContent.this.add((Component)panel, "Center");
                                NavigatorContent.this.revalidate();
                                NavigatorContent.this.repaint();
                            }
                        });
                    } else {
                        NavigatorContent.this.showError(AbstractXMLNavigatorContent.ERROR_CANNOT_NAVIGATE);
                    }
                }
                catch (DocumentModelException dme) {
                    ErrorManager.getDefault().notify(1, (Throwable)dme);
                }
            }
        });
    }

    @Override
    public void release() {
        this.removeAll();
        this.repaint();
        this.closeDocument(this.peerDO);
    }

    private void closeDocument(DataObject dobj) {
        EditorCookie ec;
        if (dobj != null && (ec = (EditorCookie)this.peerDO.getCookie(EditorCookie.class)) != null) {
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes == null || panes.length == 0) {
                ((EditorCookie.Observable)ec).removePropertyChangeListener((PropertyChangeListener)this);
                if (this.editorOpened) {
                    ec.close();
                }
            }
            this.editorOpened = false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "document") {
            if (evt.getNewValue() == null) {
                final DataObject dobj = ((DataEditorSupport)evt.getSource()).getDataObject();
                if (dobj != null) {
                    this.editorOpened = false;
                    EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                    if (ec != null) {
                        ((EditorCookie.Observable)ec).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (dobj.isValid()) {
                                NavigatorContent.this.navigate(dobj);
                            }
                        }
                    });
                }
            } else {
                this.editorOpened = true;
            }
        }
    }

    private class NavigatorContentPanel
    extends JPanel
    implements FiltersManager.FilterChangeListener {
        private JTree tree;
        private FiltersManager filters;
        private Document doc;
        public static final String ATTRIBUTES_FILTER = "attrs";
        public static final String CONTENT_FILTER = "content";

        public NavigatorContentPanel(DocumentModel dm) {
            this.doc = dm.getDocument();
            this.setLayout(new BorderLayout());
            this.tree = new PatchedJTree();
            TreeModel model = this.createTreeModel(dm);
            this.tree.setModel(model);
            this.tree.setShowsRootHandles(true);
            this.tree.setRootVisible(false);
            this.tree.setCellRenderer(new NavigatorTreeCellRenderer());
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int selRow = NavigatorContentPanel.this.tree.getRowForLocation(e.getX(), e.getY());
                    if (selRow != -1) {
                        TreePath selPath = NavigatorContentPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                        TreeNodeAdapter tna = (TreeNodeAdapter)selPath.getLastPathComponent();
                        if (e.getClickCount() == 2) {
                            NavigatorContentPanel.this.openAndFocusElement(tna, false);
                        }
                        if (e.getClickCount() == 1) {
                            NavigatorContentPanel.this.openAndFocusElement(tna, true);
                        }
                    }
                }
            };
            this.tree.addMouseListener(ml);
            final DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(selectionModel);
            this.tree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "open");
            this.tree.getActionMap().put("open", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selPath = selectionModel.getLeadSelectionPath();
                    if (selPath != null) {
                        TreeNodeAdapter tna = (TreeNodeAdapter)selPath.getLastPathComponent();
                        NavigatorContentPanel.this.openAndFocusElement(tna, false);
                    }
                }
            });
            JScrollPane treeView = new JScrollPane(this.tree);
            treeView.setBorder(BorderFactory.createEmptyBorder());
            treeView.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)treeView, "Center");
            TapPanel filtersPanel = new TapPanel();
            JLabel filtersLbl = new JLabel(NbBundle.getMessage(NavigatorContent.class, (String)"LBL_Filter"));
            filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
            filtersPanel.add(filtersLbl);
            filtersPanel.setOrientation(2);
            KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            String keyText = Utilities.keyToString((KeyStroke)toggleKey);
            filtersPanel.setToolTipText(NbBundle.getMessage(NavigatorContent.class, (String)"TIP_TapPanel", (Object)keyText));
            this.filters = this.createFilters();
            this.filters.hookChangeListener(this);
            filtersPanel.add(this.filters.getComponent());
            this.add((Component)filtersPanel, "South");
            MouseAdapter pmml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 1 && e.getModifiers() == 4) {
                        JPopupMenu pm = new JPopupMenu();
                        JMenuItem[] items = new FilterActions(NavigatorContentPanel.this.filters).createMenuItems();
                        for (int i = 0; i < items.length; ++i) {
                            pm.add(items[i]);
                        }
                        pm.pack();
                        pm.show(NavigatorContentPanel.this.tree, e.getX(), e.getY());
                    }
                }
            };
            this.tree.addMouseListener(pmml);
            TreeNode rootNode = (TreeNode)model.getRoot();
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                TreeNode node = rootNode.getChildAt(i);
                if (node.getChildCount() <= 0) continue;
                this.tree.expandPath(new TreePath(new TreeNode[]{rootNode, node}));
            }
        }

        public Document getDocument() {
            return this.doc;
        }

        private void openAndFocusElement(final TreeNodeAdapter selected, final boolean selectLineOnly) {
            BaseDocument bdoc = (BaseDocument)selected.getDocumentElement().getDocument();
            DataObject dobj = NbEditorUtilities.getDataObject((Document)bdoc);
            if (dobj == null) {
                return;
            }
            final EditorCookie.Observable ec = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class);
            if (ec == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JEditorPane[] panes = ec.getOpenedPanes();
                    if (panes != null && panes.length > 0) {
                        NavigatorContentPanel.this.selectElementInPane(panes[0], selected, !selectLineOnly);
                    } else if (!selectLineOnly) {
                        ec.open();
                        try {
                            ec.openDocument();
                            panes = ec.getOpenedPanes();
                            if (panes != null && panes.length > 0) {
                                NavigatorContentPanel.this.selectElementInPane(panes[0], selected, true);
                            }
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioe);
                        }
                    }
                }
            });
        }

        private void selectElementInPane(final JEditorPane pane, final TreeNodeAdapter tna, boolean focus) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    pane.setCaretPosition(tna.getDocumentElement().getStartOffset());
                }
            });
            if (focus) {
                Container temp = pane;
                while (!(temp instanceof TopComponent)) {
                    temp = temp.getParent();
                }
                ((TopComponent)temp).requestActive();
            }
        }

        private TreeModel createTreeModel(DocumentModel dm) {
            DocumentElement rootElement = dm.getRootElement();
            DefaultTreeModel dtm = new DefaultTreeModel(null);
            TreeNodeAdapter rootTna = new TreeNodeAdapter(rootElement, dtm, this.tree, null);
            dtm.setRoot(rootTna);
            return dtm;
        }

        private FiltersManager createFilters() {
            FiltersDescription desc = new FiltersDescription();
            desc.addFilter(ATTRIBUTES_FILTER, NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowAttributes"), NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowAttributesTip"), showAttributes, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/xml/text/navigator/resources/a.png", (boolean)false), null);
            desc.addFilter(CONTENT_FILTER, NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowContent"), NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowContentTip"), showContent, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/xml/text/navigator/resources/content.png", (boolean)false), null);
            return FiltersDescription.createManager(desc);
        }

        @Override
        public void filterStateChanged(ChangeEvent e) {
            showAttributes = this.filters.isSelected(ATTRIBUTES_FILTER);
            showContent = this.filters.isSelected(CONTENT_FILTER);
            this.tree.repaint();
        }

        private class PatchedJTree
        extends JTree {
            private boolean firstPaint = true;

            @Override
            public void paint(Graphics g) {
                if (this.firstPaint) {
                    int height = g.getFontMetrics(this.getFont()).getHeight();
                    this.setRowHeight(height + 2);
                    this.firstPaint = false;
                }
                super.paint(g);
            }
        }
    }
}

