/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;

class WSITRenamePackagePlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(WSITRenamePackagePlugin.class.getName());
    private RenameRefactoring refactoring;

    WSITRenamePackagePlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
    }

    public void cancelRequest() {
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        FileObject fileObject = ((NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder();
        String string = JavaIdentifiers.getQualifiedName((FileObject)fileObject);
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
        if (jAXWSSupport == null) {
            LOG.log(Level.FINE, "No JAX-WS support for project found");
            return null;
        }
        List list = jAXWSSupport.getServices();
        for (Object e : list) {
            Service service = (Service)e;
            String string2 = service.getImplementationClass();
            if (string2 == null || !string2.startsWith(string)) continue;
            this.doPrepare(fileObject, string2, refactoringElementsBag);
        }
        return null;
    }

    private void doPrepare(FileObject fileObject, String string, RefactoringElementsBag refactoringElementsBag) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        WSDLModel wSDLModel = null;
        if (project == null) {
            return;
        }
        FileObject fileObject2 = this.getJavaFile(string, project);
        if (fileObject2 == null) {
            return;
        }
        try {
            wSDLModel = WSITModelSupport.getModelForServiceFromJava(fileObject2, project, false, null);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, null, iOException);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, null, exception);
        }
        if (wSDLModel == null) {
            return;
        }
        refactoringElementsBag.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new PackageRenameElement(JavaIdentifiers.getQualifiedName((FileObject)fileObject), this.refactoring.getNewName(), wSDLModel));
    }

    private FileObject getJavaFile(String string, Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray.length > 0) {
            ClassPath classPath = null;
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                FileObject fileObject;
                classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[i].getRootFolder(), (String)"classpath/source");
                if (classPath == null || (fileObject = classPath.findResource(string.replace('.', '/') + ".java")) == null) continue;
                return fileObject;
            }
        }
        return null;
    }

    private static class PackageRenameElement
    extends WSITRefactoringPlugin.AbstractRenameConfigElement {
        PackageRenameElement(String string, String string2, WSDLModel wSDLModel) {
            super(wSDLModel);
            String string3 = this.getParentFile().getName();
            this.setOldConfigName(string3);
            this.setNewConfigName(string3.replace(string, string2));
        }
    }
}

