/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.xml.retriever.impl.CertificationPanel;
import org.netbeans.modules.xml.retriever.impl.URLResourceRetriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SecureURLResourceRetriever
extends URLResourceRetriever {
    private static Set<X509Certificate> acceptedCertificates;
    private static final String URI_SCHEME = "https";

    @Override
    public boolean accept(String baseAddr, String currentAddr) throws URISyntaxException {
        URI baseURI;
        URI currURI = new URI(currentAddr);
        if (currURI.isAbsolute() && currURI.getScheme().equalsIgnoreCase(URI_SCHEME)) {
            return true;
        }
        return baseAddr != null && (baseURI = new URI(baseAddr)).getScheme().equalsIgnoreCase(URI_SCHEME);
    }

    @Override
    public HashMap<String, InputStream> retrieveDocument(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        String effAddr = this.getEffectiveAddress(baseAddress, documentAddress);
        if (effAddr == null) {
            return null;
        }
        URI currURI = new URI(effAddr);
        HashMap<String, InputStream> result = null;
        if (acceptedCertificates == null) {
            acceptedCertificates = new HashSet<X509Certificate>();
        }
        InputStream is = this.getInputStreamOfURL(currURI.toURL(), ProxySelector.getDefault().select(currURI).get(0));
        result = new HashMap<String, InputStream>();
        result.put(this.effectiveURL.toString(), is);
        return result;
    }

    @Override
    protected void configureURLConnection(URLConnection ucn) {
        super.configureURLConnection(ucn);
        if (ucn instanceof HttpsURLConnection) {
            this.setRetrieverTrustManager((HttpsURLConnection)ucn);
        }
    }

    private void setRetrieverTrustManager(HttpsURLConnection con) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                if (certs != null) {
                    for (int i = 0; i < certs.length; ++i) {
                        if (acceptedCertificates.contains(certs[i])) continue;
                        DialogDescriptor desc = new DialogDescriptor((Object)new CertificationPanel(certs[i]), NbBundle.getMessage(SecureURLResourceRetriever.class, (String)"TTL_CertifiedWebSite"), true, 0, DialogDescriptor.YES_OPTION, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        if (DialogDescriptor.YES_OPTION.equals(desc.getValue())) {
                            acceptedCertificates.add(certs[i]);
                            continue;
                        }
                        throw new CertificateException(NbBundle.getMessage(SecureURLResourceRetriever.class, (String)"ERR_NotTrustedCertificate"));
                    }
                }
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            con.setSSLSocketFactory(sslContext.getSocketFactory());
            con.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    @Override
    public String getEffectiveAddress(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        URI currURI = new URI(documentAddress);
        String result = null;
        if (currURI.isAbsolute()) {
            result = currURI.toString();
            return result;
        }
        if (baseAddress != null) {
            URI baseURI = new URI(baseAddress);
            URI finalURI = baseURI.resolve(currURI);
            result = finalURI.toString();
            return result;
        }
        return null;
    }
}

