/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.spi.indexing.ConstrainedBinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Exceptions;

public class SpringBinaryIndexer
extends ConstrainedBinaryIndexer {
    public static final Logger LOGGER = Logger.getLogger(SpringBinaryIndexer.class.getSimpleName());
    static final String INDEXER_NAME = "SpringBinary";
    static final int INDEX_VERSION = 1;
    private static final String XSD_SUFFIX = ".xsd";
    static final String XSD_MIME = "text/xsd+xml";
    static final String REQUIRED_RESOURCE = "org/springframework";
    static final String LIBRARY_MARK_KEY = "xsdSpringSchema";
    static final String NAMESPACE_MARK_KEY = "namespace";
    private String version;

    protected void index(Map<String, ? extends Iterable<? extends FileObject>> files, Context context) {
        LOGGER.log(Level.FINE, "indexing " + context.getRoot());
        FileObject root = context.getRoot();
        if (root == null) {
            return;
        }
        assert (root.getFileObject(REQUIRED_RESOURCE) != null);
        this.version = this.findVersion(root);
        if (this.version != null) {
            this.processXsds(files, context);
        }
    }

    private void processXsds(Map<String, ? extends Iterable<? extends FileObject>> files, Context context) {
        for (FileObject fileObject : this.findSpringLibraryDescriptors(files.get(XSD_MIME), XSD_SUFFIX)) {
            try {
                ModelSource source = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
                SchemaModel model = SchemaModelFactory.getDefault().getModel(source);
                Schema schema = model.getSchema();
                String targetNamespace = schema.getTargetNamespace();
                if (targetNamespace == null) continue;
                IndexingSupport sup = IndexingSupport.getInstance((Context)context);
                IndexDocument doc = sup.createDocument(fileObject);
                doc.addPair(NAMESPACE_MARK_KEY, targetNamespace, true, true);
                doc.addPair(LIBRARY_MARK_KEY, Boolean.TRUE.toString(), true, true);
                sup.addDocument(doc);
                LOGGER.log(Level.INFO, "The file " + fileObject + " indexed as a XSD (namespace=" + targetNamespace + ")");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private Collection<FileObject> findSpringLibraryDescriptors(Iterable<? extends FileObject> res, String suffix) {
        assert (res != null);
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (FileObject fileObject : res) {
            String fileName = fileObject.getNameExt().toLowerCase();
            if (fileName == null || !fileName.endsWith(suffix) || !this.version.startsWith(this.findXsdVersion(fileObject))) continue;
            files.add(fileObject);
        }
        return files;
    }

    private String findXsdVersion(FileObject file) {
        String v = file.getName();
        v = v.substring(v.lastIndexOf("-") + 1);
        return v;
    }

    private String findVersion(FileObject classpathRoot) {
        ClassPath cp = ClassPath.getClassPath((FileObject)classpathRoot, (String)"classpath/compile");
        if (cp == null) {
            return null;
        }
        String classRelativePath = "org.springframework.core.SpringVersion".replace('.', '/') + ".class";
        try {
            FileObject resource = cp.findResource(classRelativePath);
            if (resource == null) {
                return null;
            }
            FileObject ownerRoot = cp.findOwnerRoot(resource);
            if (ownerRoot != null && ownerRoot.getFileSystem() instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)ownerRoot.getFileSystem();
                return SpringUtilities.getImplementationVersion(jarFileSystem);
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }
}

