/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit.codegeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.simpleunit.utils.CodeGenerationUtils;
import org.netbeans.modules.cnd.utils.FSPath;

public class CUnitCodeGenerator {
    private CUnitCodeGenerator() {
    }

    public static Map<String, Object> generateTemplateParamsForFunctions(String testName, FSPath testFilePath, List<CsmFunction> functions) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        if (functions != null) {
            StringBuilder testFunctions = new StringBuilder("");
            StringBuilder testCalls = new StringBuilder("");
            StringBuilder testIncludes = new StringBuilder("");
            testCalls.append("if ( ");
            ArrayList<String> testFunctionsNames = new ArrayList<String>();
            ArrayList<String> addedTestIncludes = new ArrayList<String>();
            int functionNumber = 0;
            for (CsmFunction fun : functions) {
                CsmIncludeResolver inclResolver = CsmIncludeResolver.getDefault();
                String include = inclResolver.getLocalIncludeDerectiveByFilePath(testFilePath, (CsmObject)fun);
                if (!include.isEmpty()) {
                    if (!addedTestIncludes.contains(include)) {
                        testIncludes.append(include);
                        testIncludes.append("\n");
                    }
                    addedTestIncludes.add(include);
                } else {
                    testFunctions.append(CodeGenerationUtils.generateFunctionDeclaration((CsmFunction)fun));
                    testFunctions.append("\n\n");
                }
                String funName = ((Object)fun.getName()).toString();
                String testFunctionName = "test" + Character.toUpperCase(funName.charAt(0)) + funName.substring(1);
                if (testFunctionsNames.contains(testFunctionName)) {
                    int i = 0;
                    while (testFunctionsNames.contains(testFunctionName + i)) {
                        ++i;
                    }
                    testFunctionName = testFunctionName + i;
                }
                testFunctionsNames.add(testFunctionName);
                testFunctions.append("void ").append(testFunctionName).append("() {\n");
                Collection params = fun.getParameters();
                int i = 2;
                for (CsmParameter param : params) {
                    testFunctions.append("    ");
                    testFunctions.append(CodeGenerationUtils.generateParameterDeclaration((CsmParameter)param, (int)i));
                    testFunctions.append("\n");
                    ++i;
                }
                testFunctions.append(CodeGenerationUtils.generateFunctionCall((CsmFunction)fun));
                testFunctions.append("    if(1 /*check result*/) {\n");
                testFunctions.append("        CU_ASSERT(0);");
                testFunctions.append("    }\n");
                testFunctions.append("}\n\n");
                if (functionNumber != 0) {
                    testCalls.append("||\n        ");
                }
                testCalls.append("(NULL == CU_add_test(pSuite, \"" + testFunctionName + "\", " + testFunctionName + ")) ");
                ++functionNumber;
            }
            testCalls.append(")\n");
            testCalls.append("    {\n");
            testCalls.append("        CU_cleanup_registry();\n");
            testCalls.append("        return CU_get_error();\n");
            testCalls.append("    }\n");
            if (functionNumber != 0) {
                templateParams.put("testFunctions", testFunctions.toString());
                templateParams.put("testCalls", testCalls.toString());
                templateParams.put("testIncludes", testIncludes.toString());
            }
        }
        return templateParams;
    }
}

