/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit.editor.filecreation;

import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.cncppunit.editor.filecreation.NewTestCUnitPanelGUI;
import org.netbeans.modules.cnd.cncppunit.editor.filecreation.NewTestCppUnitPanel;
import org.netbeans.modules.cnd.cncppunit.editor.filecreation.TestLibChecker;
import org.netbeans.modules.cnd.editor.filecreation.CndPanel;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanel;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NewTestCUnitPanel
extends CndPanel {
    private static final String CUNIT = "cunit";
    private final MIMEExtensions es;
    private final String defaultExt;
    private final boolean fileWithoutExtension;
    private final String baseTestName;
    private RequestProcessor.Task libCheckTask;
    private volatile boolean libCheckResult;

    NewTestCUnitPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, MIMEExtensions es, String defaultExt, String baseTestName) {
        super(project, folders, bottomPanel);
        this.baseTestName = null;
        this.es = es;
        this.defaultExt = defaultExt;
        this.fileWithoutExtension = "".equals(defaultExt);
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new NewTestCUnitPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.es, this.defaultExt, this.baseTestName);
            this.gui.addChangeListener((ChangeListener)((Object)this));
        }
        return this.gui;
    }

    NewTestCUnitPanelGUI getGui() {
        return (NewTestCUnitPanelGUI)this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("CreateTestWizardP2");
    }

    public void stateChanged(ChangeEvent e) {
        if (e instanceof TestLibChecker.LibCheckerChangeEvent) {
            this.libCheckResult = ((TestLibChecker.LibCheckerChangeEvent)e).getResult();
            this.libCheckTask = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewTestCUnitPanel.this.getGui().setControlsEnabled(true);
                }
            });
        }
        super.stateChanged(e);
    }

    public void readSettings(WizardDescriptor settings) {
        super.readSettings(settings);
        this.setErrorMessage("");
        this.getGui().setControlsEnabled(false);
        AbstractCompiler cCompiler = TestLibChecker.getCCompiler(this.project);
        this.libCheckTask = cCompiler != null ? TestLibChecker.asyncCheck(CUNIT, cCompiler, (ChangeListener)((Object)this)) : null;
    }

    protected void doStoreSettings(WizardDescriptor settings) {
        if (this.getTargetExtension().length() > 0) {
            if (((NewTestCUnitPanelGUI)this.gui).useTargetExtensionAsDefault()) {
                this.es.setDefaultExtension(this.getTargetExtension());
            } else {
                this.es.addExtension(this.getTargetExtension());
            }
        }
    }

    public boolean isValid() {
        String errorMessage;
        this.setInfoMessage(null);
        this.setErrorMessage(null);
        if (this.libCheckTask != null) {
            this.setInfoMessage(NbBundle.getMessage(NewTestCppUnitPanel.class, (String)"MSG_Checking_Library", (Object)CUNIT, (Object)TestLibChecker.getExecutionEnvironment(this.project)));
            return false;
        }
        if (!this.libCheckResult) {
            this.setErrorMessage(NbBundle.getMessage(NewTestCppUnitPanel.class, (String)"MSG_Missing_Library", (Object)CUNIT));
        }
        if (!super.isValid()) {
            return false;
        }
        String documentName = this.gui.getTargetName();
        if (!this.fileWithoutExtension && this.getTargetExtension().length() == 0 || documentName.charAt(0) == '.') {
            this.setErrorMessage(NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_Invalid_File_Name"));
            return false;
        }
        if (!this.fileWithoutExtension && !this.es.getValues().contains(this.getTargetExtension())) {
            String msg = NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_new_extension_introduced", (Object)this.getTargetExtension());
            this.setErrorMessage(msg);
        }
        if ((errorMessage = NewTestCUnitPanel.canUseFileName((FileObject)this.gui.getTargetGroup().getRootFolder(), (String)this.gui.getTargetFolder(), (String)documentName, (boolean)false)) != null) {
            this.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    private String getTargetExtension() {
        return ((NewTestCUnitPanelGUI)this.gui).getTargetExtension();
    }

    public static FileObject getTemplateFileObject(String formType) {
        return FileUtil.getConfigFile((String)("Templates/testFiles/" + formType));
    }

    public static DataObject getTemplateDataObject(String formType) {
        FileObject fileObj = NewTestCUnitPanel.getTemplateFileObject(formType);
        if (fileObj != null) {
            try {
                return DataObject.find((FileObject)fileObj);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getTemplateDisplayName(String formType) {
        DataObject dataObj = NewTestCUnitPanel.getTemplateDataObject(formType);
        if (dataObj != null) {
            return dataObj.getNodeDelegate().getDisplayName();
        }
        return formType;
    }
}

