/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class ClassImplSpecialization
extends ClassImpl
implements CsmTemplate {
    private CharSequence qualifiedNameSuffix = CharSequences.empty();
    private SpecializationDescriptor specializationDesctiptor;

    protected ClassImplSpecialization(AST ast, NameHolder name, CsmFile file) {
        super(name, ast, file);
    }

    protected ClassImplSpecialization(AST ast, NameHolder name, CsmFile file, int start, int end) {
        super(name, ast, file, start, end);
    }

    @Override
    protected final void init(CsmScope scope, AST ast, boolean register) {
        this.initScope(scope);
        ClassImplSpecialization.temporaryRepositoryRegistration(register, this);
        this.render(ast, !register);
        this.initQualifiedName(ast, scope, register);
        if (register) {
            this.register(this.getScope(), false);
        }
    }

    protected final void initQualifiedName(AST ast, CsmScope scope, boolean register) {
        AST qIdToken = AstUtil.findChildOfType(ast, 510);
        assert (qIdToken != null);
        this.qualifiedNameSuffix = NameCache.getManager().getString((CharSequence)TemplateUtils.getSpecializationSuffix(qIdToken, this.getTemplateParameters()));
        this.initQualifiedName(scope);
        this.specializationDesctiptor = SpecializationDescriptor.createIfNeeded(ast, this.getContainingFile(), scope, register);
    }

    public static ClassImplSpecialization create(AST ast, CsmScope scope, CsmFile file, boolean register, DeclarationsContainer container) {
        ClassImpl clsImpl = ClassImplSpecialization.findExistingClassImplInContainer(container, ast);
        ClassImplSpecialization impl = null;
        if (clsImpl instanceof ClassImplSpecialization) {
            impl = (ClassImplSpecialization)clsImpl;
        }
        NameHolder nameHolder = null;
        if (impl == null) {
            nameHolder = NameHolder.createClassName(ast);
            impl = new ClassImplSpecialization(ast, nameHolder, file);
        }
        impl.init(scope, ast, register);
        if (nameHolder != null) {
            nameHolder.addReference(file, impl);
        }
        return impl;
    }

    @Override
    public boolean isTemplate() {
        return true;
    }

    @Override
    public boolean isSpecialization() {
        return true;
    }

    @Override
    public boolean isExplicitSpecialization() {
        return false;
    }

    @Override
    public String getQualifiedNamePostfix() {
        return super.getQualifiedNamePostfix() + ((Object)this.qualifiedNameSuffix).toString();
    }

    protected String getQualifiedNameWithoutSuffix() {
        CsmScope scope = this.getScope();
        String name = ((Object)this.getName()).toString();
        if (CsmKindUtilities.isNamespace((Object)scope)) {
            return Utils.getQualifiedName(name, (CsmNamespace)scope);
        }
        if (CsmKindUtilities.isClass((CsmObject)scope)) {
            String n = name;
            if (name.contains("::")) {
                name = name.substring(name.lastIndexOf("::") + 2);
            }
            return ((CsmClass)scope).getQualifiedName() + "::" + name;
        }
        return name;
    }

    public List<CsmSpecializationParameter> getSpecializationParameters() {
        return this.specializationDesctiptor != null ? this.specializationDesctiptor.getSpecializationParameters() : Collections.emptyList();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeUTF(this.qualifiedNameSuffix, output);
        PersistentUtils.writeSpecializationDescriptor(this.specializationDesctiptor, output);
    }

    public ClassImplSpecialization(RepositoryDataInput input) throws IOException {
        super(input);
        this.qualifiedNameSuffix = PersistentUtils.readUTF(input, NameCache.getManager());
        this.specializationDesctiptor = PersistentUtils.readSpecializationDescriptor(input);
    }

    @Override
    public String getDisplayName() {
        return this.getName() + ((Object)this.qualifiedNameSuffix).toString();
    }
}

