/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.EnumeratorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class EnumImpl
extends ClassEnumBase<CsmEnum>
implements CsmEnum {
    private final List<CsmUID<CsmEnumerator>> enumerators;

    private EnumImpl(AST ast, NameHolder name, CsmFile file) {
        super(name, file, ast);
        this.enumerators = new ArrayList<CsmUID<CsmEnumerator>>();
    }

    private EnumImpl(String name, String qName, CsmFile file, int startOffset, int endOffset) {
        super(name, qName, file, startOffset, endOffset);
        this.enumerators = new ArrayList<CsmUID<CsmEnumerator>>();
    }

    private void init(CsmScope scope, AST ast, CsmFile file, boolean register) {
        this.initScope(scope);
        EnumImpl.temporaryRepositoryRegistration(register, this);
        this.initEnumeratorList(ast, file, register);
        if (register) {
            this.register(scope, true);
        }
    }

    public static EnumImpl create(AST ast, CsmScope scope, CsmFile file, boolean register) {
        NameHolder nameHolder = NameHolder.createEnumName(ast);
        EnumImpl impl = new EnumImpl(ast, nameHolder, file);
        impl.init(scope, ast, file, register);
        nameHolder.addReference(file, impl);
        return impl;
    }

    void addEnumerator(String name, int startOffset, int endOffset, boolean register) {
        EnumeratorImpl ei = EnumeratorImpl.create(this, name, startOffset, endOffset, register);
        CsmUID<EnumeratorImpl> uid = UIDCsmConverter.objectToUID(ei);
        this.enumerators.add(uid);
    }

    private void initEnumeratorList(AST ast, CsmFile file, boolean global) {
        AST token;
        for (token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            if (token.getType() != 504) continue;
            this.addList(token, file, global);
            return;
        }
        token = ast.getNextSibling();
        if (token != null) {
            AST enumList = null;
            if (token.getType() == 90) {
                token = token.getNextSibling();
            }
            if (token.getType() == 16) {
                enumList = token.getNextSibling();
            }
            if (enumList != null && enumList.getType() == 504) {
                this.addList(enumList, file, global);
            }
        }
    }

    private void addList(AST token, CsmFile file, boolean global) {
        for (AST t = token.getFirstChild(); t != null; t = t.getNextSibling()) {
            if (t.getType() != 90) continue;
            EnumeratorImpl ei = EnumeratorImpl.create(t, file, this, global);
            CsmUID<EnumeratorImpl> uid = UIDCsmConverter.objectToUID(ei);
            this.enumerators.add(uid);
        }
    }

    public Collection<CsmEnumerator> getEnumerators() {
        Collection<CsmEnumerator> out = UIDCsmConverter.UIDsToDeclarations(this.enumerators);
        return out;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getEnumerators();
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUM;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._clearEnumerators();
    }

    private void _clearEnumerators() {
        Collection<CsmEnumerator> enumers = this.getEnumerators();
        Utils.disposeAll(enumers);
        RepositoryUtils.remove(this.enumerators);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enumerators, output, false);
    }

    public EnumImpl(RepositoryDataInput input) throws IOException {
        super(input);
        int collSize = input.readInt();
        this.enumerators = collSize < 0 ? new ArrayList<CsmUID<CsmEnumerator>>(0) : new ArrayList<CsmUID<CsmEnumerator>>(collSize);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enumerators, input, collSize);
    }
}

