/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.EnumImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public final class EnumeratorImpl
extends OffsetableDeclarationBase<CsmEnumerator>
implements CsmEnumerator {
    private final CharSequence name;
    private CsmEnum enumerationRef;
    private final CsmUID<CsmEnum> enumerationUID;

    private EnumeratorImpl(AST ast, NameHolder name, EnumImpl enumeration) {
        super(enumeration.getContainingFile(), EnumeratorImpl.getStartOffset(ast), EnumeratorImpl.getEndOffset(ast));
        this.name = NameCache.getManager().getString(name.getName());
        this.enumerationUID = UIDCsmConverter.declarationToUID(enumeration);
        this.enumerationRef = null;
    }

    public static EnumeratorImpl create(AST ast, CsmFile file, EnumImpl enumeration, boolean global) {
        NameHolder holder = NameHolder.createSimpleName(ast);
        EnumeratorImpl ei = new EnumeratorImpl(ast, holder, enumeration);
        EnumeratorImpl.postObjectCreateRegistration(global, ei);
        holder.addReference(file, ei);
        return ei;
    }

    private EnumeratorImpl(EnumImpl enumeration, String name, int startOffset, int endOffset) {
        super(enumeration.getContainingFile(), startOffset, endOffset);
        this.name = NameCache.getManager().getString((CharSequence)name);
        this.enumerationUID = UIDCsmConverter.declarationToUID(enumeration);
        this.enumerationRef = null;
    }

    public static EnumeratorImpl create(EnumImpl enumeration, String name, int startOffset, int endOffset, boolean global) {
        EnumeratorImpl ei = new EnumeratorImpl(enumeration, name, startOffset, endOffset);
        EnumeratorImpl.postObjectCreateRegistration(global, ei);
        return ei;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmExpression getExplicitValue() {
        return null;
    }

    public CsmEnum getEnumeration() {
        return this._getEnumeration();
    }

    public CsmScope getScope() {
        return this.getEnumeration();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUMERATOR;
    }

    public CharSequence getQualifiedName() {
        return CharSequences.create((CharSequence)(this._getEnumeration().getQualifiedName() + "::" + this.getQualifiedNamePostfix()));
    }

    private synchronized CsmEnum _getEnumeration() {
        CsmEnum enumeration = this.enumerationRef;
        if (enumeration == null) {
            enumeration = UIDCsmConverter.UIDtoDeclaration(this.enumerationUID);
            assert (enumeration != null || this.enumerationUID == null) : "null object for UID " + this.enumerationUID;
        }
        return enumeration;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.enumerationRef == null) {
            this.enumerationRef = UIDCsmConverter.UIDtoDeclaration(this.enumerationUID);
            assert (this.enumerationRef != null || this.enumerationUID == null) : "no object for UID " + this.enumerationUID;
        }
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        assert (this.enumerationUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.enumerationUID, output);
    }

    public EnumeratorImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        this.enumerationUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        assert (this.enumerationUID != null);
        this.enumerationRef = null;
    }
}

