/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmExpressionBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.impl.services.MemberResolverImpl;
import org.netbeans.modules.cnd.modelimpl.impl.services.SelectImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;

public class Instantiation<T extends CsmOffsetableDeclaration>
extends OffsetableIdentifiableBase<CsmInstantiation>
implements CsmOffsetableDeclaration,
CsmInstantiation,
CsmIdentifiable {
    private static final int MAX_INHERITANCE_DEPTH = 20;
    protected final T declaration;
    protected final Map<CsmTemplateParameter, CsmSpecializationParameter> mapping;

    private Instantiation(T declaration, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        super(declaration.getContainingFile(), declaration.getStartOffset(), declaration.getEndOffset());
        this.declaration = declaration;
        this.mapping = mapping;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CsmObject)) {
            return false;
        }
        CsmObject csmobj = (CsmObject)obj;
        if (!CsmKindUtilities.isInstantiation((CsmObject)csmobj)) {
            return false;
        }
        CsmInstantiation inst = (CsmInstantiation)csmobj;
        Map<CsmTemplateParameter, CsmSpecializationParameter> mapping1 = this.getMapping();
        Map mapping2 = inst.getMapping();
        if (mapping1.size() != mapping2.size()) {
            return false;
        }
        for (CsmTemplateParameter csmTemplateParameter : mapping1.keySet()) {
            if (this.getMapping().get(csmTemplateParameter).equals(mapping2.get(csmTemplateParameter))) continue;
            return false;
        }
        return this.getTemplateDeclaration().equals(inst.getTemplateDeclaration());
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (this.declaration != null ? this.declaration.hashCode() : 0);
        hash = 31 * hash + (this.mapping != null ? ((Object)this.mapping).hashCode() : 0);
        return hash;
    }

    private CsmObject getTemplateParameterDefultValue(CsmTemplate declaration, CsmTemplateParameter param, int index) {
        CsmTemplateParameter p;
        List templateParameters;
        CsmClass cls;
        CsmClassForwardDeclaration fdecl;
        CsmObject res = param.getDefaultValue();
        if (res != null) {
            return res;
        }
        if (CsmKindUtilities.isClass((CsmObject)declaration) && (fdecl = this.findCsmClassForwardDeclaration((CsmScope)(cls = (CsmClass)declaration).getContainingFile(), cls)) != null && (templateParameters = ((CsmTemplate)fdecl).getTemplateParameters()).size() > index && (p = (CsmTemplateParameter)templateParameters.get(index)) != null && (res = p.getDefaultValue()) != null) {
            return res;
        }
        return res;
    }

    private CsmClassForwardDeclaration findCsmClassForwardDeclaration(CsmScope scope, CsmClass cls) {
        if (scope != null) {
            CsmClassForwardDeclaration fdecl;
            CsmOffsetableDeclaration decl;
            Iterator it;
            Iterator declarations;
            CsmSelect.CsmFilter filter;
            if (CsmKindUtilities.isFile((CsmObject)scope)) {
                CsmFile file = (CsmFile)scope;
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION});
                it = declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    if (!((CsmClassForwardDeclaration)decl).getCsmClass().equals(cls)) continue;
                    return (CsmClassForwardDeclaration)decl;
                }
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
                it = declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    fdecl = this.findCsmClassForwardDeclaration((CsmScope)((CsmNamespaceDefinition)decl), cls);
                    if (fdecl == null) continue;
                    return fdecl;
                }
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)scope)) {
                CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)scope;
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION});
                it = declarations = CsmSelect.getDeclarations((CsmNamespaceDefinition)nsd, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    if (!((CsmClassForwardDeclaration)decl).getCsmClass().equals(cls)) continue;
                    return (CsmClassForwardDeclaration)decl;
                }
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
                it = declarations = CsmSelect.getDeclarations((CsmNamespaceDefinition)nsd, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    fdecl = this.findCsmClassForwardDeclaration((CsmScope)((CsmNamespaceDefinition)decl), cls);
                    if (fdecl == null) continue;
                    return fdecl;
                }
            }
        }
        return null;
    }

    public T getTemplateDeclaration() {
        return this.declaration;
    }

    public Map<CsmTemplateParameter, CsmSpecializationParameter> getMapping() {
        return this.mapping;
    }

    public boolean isValid() {
        return CsmBaseUtilities.isValid(this.declaration);
    }

    public static CsmObject create(CsmTemplate template, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        if (template instanceof CsmClass) {
            CsmFile file;
            Class newClass = new Class((CsmClass)template, mapping);
            if (UIDProviderIml.isPersistable(newClass.getUID()) && (file = newClass.getContainingFile()) instanceof FileImpl) {
                ((FileImpl)file).addInstantiation(newClass);
            }
            return newClass;
        }
        if (template instanceof CsmFunction) {
            return new Function((CsmFunction)template, mapping);
        }
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("Unknown class " + template.getClass() + " for template instantiation:" + template));
        }
        return template;
    }

    @Override
    public CsmFile getContainingFile() {
        return this.getTemplateDeclaration().getContainingFile();
    }

    @Override
    public CharSequence getText() {
        return this.getTemplateDeclaration().getText();
    }

    public CsmDeclaration.Kind getKind() {
        return this.getTemplateDeclaration().getKind();
    }

    public CharSequence getUniqueName() {
        return this.getTemplateDeclaration().getUniqueName();
    }

    public CharSequence getQualifiedName() {
        return this.getTemplateDeclaration().getQualifiedName();
    }

    public CharSequence getName() {
        return this.getTemplateDeclaration().getName();
    }

    public CsmScope getScope() {
        return this.getTemplateDeclaration().getScope();
    }

    @Override
    protected CsmUID<?> createUID() {
        return Instantiation.createInstantiationUID(this);
    }

    public static <T extends CsmInstantiation> CsmUID<?> createInstantiationUID(CsmInstantiation inst) {
        if (CsmKindUtilities.isClass((CsmObject)inst) && inst.getTemplateDeclaration() instanceof ClassImpl) {
            Map mapping = inst.getMapping();
            boolean persistable = !mapping.keySet().isEmpty();
            for (CsmTemplateParameter param : mapping.keySet()) {
                CsmSpecializationParameter specParam = (CsmSpecializationParameter)mapping.get(param);
                if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)specParam)) {
                    if (PersistentUtils.isPersistable(((CsmTypeBasedSpecializationParameter)specParam).getType())) continue;
                    persistable = false;
                    continue;
                }
                persistable = false;
            }
            if (persistable) {
                return UIDUtilities.createInstantiationUID(inst);
            }
        }
        return new InstantiationSelfUID((Instantiation)inst);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.declaration instanceof ClassImpl);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUID(UIDCsmConverter.declarationToUID(this.declaration), output);
        ArrayList keys = new ArrayList();
        ArrayList<CsmSpecializationParameter> vals = new ArrayList<CsmSpecializationParameter>();
        for (CsmTemplateParameter key : this.mapping.keySet()) {
            keys.add(UIDCsmConverter.declarationToUID(key));
            vals.add(this.mapping.get(key));
        }
        factory.writeUIDCollection(keys, output, true);
        PersistentUtils.writeSpecializationParameters(vals, output);
    }

    public Instantiation(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        CsmUID declUID = factory.readUID(input);
        this.declaration = (CsmOffsetableDeclaration)declUID.getObject();
        ArrayList keys = new ArrayList();
        ArrayList<CsmSpecializationParameter> vals = new ArrayList<CsmSpecializationParameter>();
        factory.readUIDCollection(keys, input);
        PersistentUtils.readSpecializationParameters(vals, input);
        this.mapping = new HashMap<CsmTemplateParameter, CsmSpecializationParameter>();
        for (int i = 0; i < keys.size() && i < vals.size(); ++i) {
            this.mapping.put((CsmTemplateParameter)((CsmUID)keys.get(i)).getObject(), (CsmSpecializationParameter)vals.get(i));
        }
    }

    public static CsmType createType(CsmType type, CsmInstantiation instantiation) {
        CsmType instantiatedType;
        if (CsmKindUtilities.isTemplateParameterType((CsmObject)type) && ((instantiatedType = Instantiation.resolveTemplateParameterType(type, instantiation)) == null || CsmKindUtilities.isTemplateParameterType((CsmObject)instantiatedType))) {
            return new TemplateParameterType(type, instantiation);
        }
        if (type instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType || type instanceof NestedType) {
            return new NestedType(type, instantiation);
        }
        return new Type(type, instantiation);
    }

    private static CsmType resolveTemplateParameterType(CsmType type, CsmInstantiation instantiation) {
        if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
            CsmSpecializationParameter nextInstantiatedType;
            Map<CsmTemplateParameter, CsmSpecializationParameter> mapping = TemplateUtils.gatherMapping(instantiation);
            CsmSpecializationParameter instantiatedType = mapping.get(((CsmTemplateParameterType)type).getParameter());
            for (int iteration = 20; CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instantiatedType) && CsmKindUtilities.isTemplateParameterType((CsmObject)((CsmTypeBasedSpecializationParameter)instantiatedType).getType()) && iteration != 0 && (nextInstantiatedType = mapping.get(((CsmTemplateParameterType)((CsmTypeBasedSpecializationParameter)instantiatedType).getType()).getParameter())) != null; --iteration) {
                instantiatedType = nextInstantiatedType;
            }
            if (instantiatedType != null && instantiatedType instanceof CsmTypeBasedSpecializationParameter) {
                return ((CsmTypeBasedSpecializationParameter)instantiatedType).getType();
            }
        }
        return type;
    }

    private static CsmClassifier getNestedClassifier(MemberResolverImpl memberResolver, CsmClassifier parentClassifier, CharSequence ownText) {
        return org.netbeans.modules.cnd.modelimpl.csm.NestedType.getNestedClassifier(memberResolver, parentClassifier, ownText);
    }

    public static CharSequence getInstantiatedText(CsmType type) {
        if (type instanceof Type) {
            return ((Type)type).getInstantiatedText();
        }
        return type.getText();
    }

    public static CharSequence getInstantiationCanonicalText(List<CsmSpecializationParameter> params) {
        StringBuilder sb = new StringBuilder();
        if (!params.isEmpty()) {
            sb.append('<');
            boolean first = true;
            for (CsmSpecializationParameter param : params) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                    sb.append(TypeImpl.getCanonicalText(((CsmTypeBasedSpecializationParameter)param).getType()));
                }
                if (!CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)param)) continue;
                sb.append(((CsmExpressionBasedSpecializationParameter)param).getText());
            }
            TemplateUtils.addGREATERTHAN(sb);
        }
        return sb;
    }

    /* synthetic */ Instantiation(CsmOffsetableDeclaration x0, Map x1, 1 x2) {
        this(x0, x1);
    }

    public static final class InstantiationSelfUID
    implements CsmUID<CsmInstantiation>,
    SelfPersistent {
        private final Instantiation ref;

        private InstantiationSelfUID(Instantiation ref) {
            this.ref = ref;
        }

        public Instantiation getObject() {
            return this.ref;
        }

        public void write(RepositoryDataOutput output) throws IOException {
        }

        public InstantiationSelfUID(RepositoryDataInput input) throws IOException {
            this.ref = null;
        }
    }

    private static class NestedType
    extends Type {
        private final CsmType parentType;

        private NestedType(CsmType type, CsmInstantiation instantiation) {
            super(type, instantiation);
            if (type instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                org.netbeans.modules.cnd.modelimpl.csm.NestedType t = (org.netbeans.modules.cnd.modelimpl.csm.NestedType)type;
                CsmType parent = t.getParent();
                this.parentType = parent != null ? Instantiation.createType(parent, instantiation) : null;
            } else if (type instanceof NestedType) {
                NestedType t = (NestedType)type;
                CsmType parent = t.parentType;
                this.parentType = parent != null ? Instantiation.createType(parent, instantiation) : null;
            } else {
                this.parentType = null;
            }
        }

        @Override
        public CsmClassifier getClassifier() {
            return this.getClassifier(new ArrayList<CsmInstantiation>(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CsmClassifier getClassifier(List<CsmInstantiation> instantiations, boolean specialize) {
            instantiations.add(this.instantiation);
            if (this.resolved == null) {
                CsmMember tdMember;
                Resolver resolver;
                CsmObject obj;
                CsmInstantiationProvider ip;
                if (!this.instantiationHappened()) {
                    CsmClassifier parentClassifier;
                    if (this.parentType != null && CsmBaseUtilities.isValid((CsmObject)(parentClassifier = this.parentType instanceof TypeImpl ? ((TypeImpl)this.parentType).getClassifier(instantiations, false) : (this.parentType instanceof Type ? ((Type)this.parentType).getClassifier(instantiations, false) : this.parentType.getClassifier())))) {
                        MemberResolverImpl memberResolver = new MemberResolverImpl();
                        if (this.instantiatedType instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                            this.resolved = Instantiation.getNestedClassifier(memberResolver, parentClassifier, ((org.netbeans.modules.cnd.modelimpl.csm.NestedType)this.instantiatedType).getOwnText());
                        } else if (this.instantiatedType instanceof NestedType) {
                            this.resolved = Instantiation.getNestedClassifier(memberResolver, parentClassifier, ((NestedType)this.instantiatedType).getOwnText());
                        }
                    }
                    if (this.isInstantiation() && CsmKindUtilities.isTemplate((CsmObject)this.resolved) && !((CsmTemplate)this.resolved).getTemplateParameters().isEmpty()) {
                        block22: {
                            ip = CsmInstantiationProvider.getDefault();
                            obj = null;
                            if (ip instanceof InstantiationProviderImpl) {
                                resolver = ResolverFactory.createResolver((CsmOffsetable)this);
                                try {
                                    if (!resolver.isRecursionOnResolving(200)) {
                                        obj = ((InstantiationProviderImpl)ip).instantiate((CsmTemplate)this.resolved, this, specialize);
                                        break block22;
                                    }
                                    CsmClassifier csmClassifier = null;
                                    return csmClassifier;
                                }
                                finally {
                                    ResolverFactory.releaseResolver(resolver);
                                }
                            }
                            obj = ip.instantiate((CsmTemplate)this.resolved, (CsmType)this);
                        }
                        if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                            this.resolved = (CsmClassifier)obj;
                        }
                    }
                }
                if (this.resolved == null) {
                    this.resolved = this.instantiatedType instanceof TypeImpl ? ((TypeImpl)this.instantiatedType).getClassifier(instantiations, false) : (this.instantiatedType instanceof Type ? ((Type)this.instantiatedType).getClassifier(instantiations, false) : this.instantiatedType.getClassifier());
                    if (this.isInstantiation() && CsmKindUtilities.isTemplate((CsmObject)this.resolved) && !((CsmTemplate)this.resolved).getTemplateParameters().isEmpty()) {
                        block23: {
                            ip = CsmInstantiationProvider.getDefault();
                            obj = null;
                            if (ip instanceof InstantiationProviderImpl) {
                                resolver = ResolverFactory.createResolver((CsmOffsetable)this);
                                try {
                                    if (!resolver.isRecursionOnResolving(200)) {
                                        obj = ((InstantiationProviderImpl)ip).instantiate((CsmTemplate)this.resolved, this.instantiation, specialize);
                                        break block23;
                                    }
                                    CsmClassifier csmClassifier = null;
                                    return csmClassifier;
                                }
                                finally {
                                    ResolverFactory.releaseResolver(resolver);
                                }
                            }
                            obj = ip.instantiate((CsmTemplate)this.resolved, (CsmType)this);
                        }
                        if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                            this.resolved = (CsmClassifier)obj;
                        }
                    }
                }
                if (CsmKindUtilities.isTypedef((CsmObject)this.resolved) && CsmKindUtilities.isClassMember((CsmObject)this.resolved) && CsmKindUtilities.isTemplate((CsmObject)(tdMember = (CsmMember)this.resolved).getContainingClass())) {
                    this.resolved = new Typedef((CsmTypedef)this.resolved, this.instantiation);
                    return this.resolved;
                }
            }
            return this.resolved;
        }

        @Override
        public boolean isInstantiation() {
            return this.parentType != null && this.parentType.isInstantiation() || super.isInstantiation();
        }
    }

    private static class Type
    implements CsmType,
    Resolver.SafeTemplateBasedProvider {
        protected final CsmType originalType;
        protected final CsmInstantiation instantiation;
        protected final CsmType instantiatedType;
        protected final boolean inst;
        protected CsmClassifier resolved;
        protected CsmTemplateParameter parameter;

        private Type(CsmType type, CsmInstantiation instantiation) {
            this.instantiation = instantiation;
            this.inst = type.isInstantiation();
            CsmType origType = type;
            CsmType newType = type;
            this.parameter = null;
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
                CsmTemplateParameterType paramType = (CsmTemplateParameterType)type;
                this.parameter = paramType.getParameter();
                newType = Instantiation.resolveTemplateParameterType(type, instantiation);
                if (newType != null) {
                    List paramInstParams;
                    CsmType paramTemplateType;
                    newType = TypeFactory.createType(newType, origType.getPointerDepth(), origType.isReference(), origType.getArrayDepth(), origType.isConst());
                    CsmTemplateParameter p = paramType.getParameter();
                    if (CsmKindUtilities.isTemplate((CsmObject)p) && (paramTemplateType = paramType.getTemplateType()) != null && !(paramInstParams = paramTemplateType.getInstantiationParams()).isEmpty()) {
                        ArrayList<CsmSpecializationParameter> newInstParams = new ArrayList<CsmSpecializationParameter>(newType.getInstantiationParams());
                        boolean updateInstParams = false;
                        for (CsmSpecializationParameter param : paramInstParams) {
                            if (newInstParams.contains(param)) continue;
                            newInstParams.add(param);
                            updateInstParams = true;
                        }
                        if (updateInstParams) {
                            newType = TypeFactory.createType(newType, newInstParams);
                        }
                    }
                    origType = paramType.getTemplateType();
                } else {
                    newType = type;
                }
            }
            if (!this.isRecursion(this, 20)) {
                this.originalType = origType;
                this.instantiatedType = newType;
            } else {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Infinite recursion in file " + this.getContainingFile() + " type " + this.toString()));
                this.originalType = origType;
                this.instantiatedType = origType;
            }
        }

        public boolean instantiationHappened() {
            return this.originalType != this.instantiatedType;
        }

        public CharSequence getClassifierText() {
            return ((Object)this.instantiatedType.getClassifierText()).toString() + TypeImpl.getInstantiationText(this);
        }

        private CharSequence getInstantiatedText() {
            return this.getTextImpl(true);
        }

        public CharSequence getText() {
            return this.getTextImpl(false);
        }

        private CharSequence getTextImpl(boolean instantiate) {
            if (this.originalType instanceof TypeImpl) {
                CsmClassifier classifier = null;
                if (instantiate && (classifier = this.getClassifier()) != null) {
                    classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)this.getContainingFile());
                }
                CharSequence clsText = classifier == null || CsmKindUtilities.isInstantiation((CsmObject)classifier) ? this.getClassifierText() : classifier.getName();
                return ((TypeImpl)this.originalType).decorateText(clsText, this, false, null);
            }
            if (this.originalType instanceof NestedType) {
                return ((NestedType)this.originalType).getOwnText();
            }
            return this.originalType.getText();
        }

        public CharSequence getOwnText() {
            if (this.originalType instanceof TypeImpl) {
                return ((TypeImpl)this.originalType).getOwnText();
            }
            return this.originalType.getText();
        }

        public CsmOffsetable.Position getStartPosition() {
            return this.instantiatedType.getStartPosition();
        }

        public int getStartOffset() {
            return this.instantiatedType.getStartOffset();
        }

        public CsmOffsetable.Position getEndPosition() {
            return this.instantiatedType.getEndPosition();
        }

        public int getEndOffset() {
            return this.instantiatedType.getEndOffset();
        }

        public CsmFile getContainingFile() {
            return this.instantiatedType.getContainingFile();
        }

        public boolean isInstantiation() {
            return this.instantiatedType.isInstantiation();
        }

        private boolean isRecursion(CsmType type, int i) {
            if (i == 0) {
                return true;
            }
            if (type instanceof NestedType) {
                NestedType t = (NestedType)type;
                if (t.parentType != null) {
                    return this.isRecursion(t.parentType, i - 1);
                }
                return this.isRecursion(t.instantiatedType, i - 1);
            }
            if (type instanceof Type) {
                return this.isRecursion(((Type)type).instantiatedType, i - 1);
            }
            if (type instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                org.netbeans.modules.cnd.modelimpl.csm.NestedType t = (org.netbeans.modules.cnd.modelimpl.csm.NestedType)type;
                if (t.getParent() != null) {
                    return this.isRecursion(t.getParent(), i - 1);
                }
                return false;
            }
            if (type instanceof TypeImpl) {
                return false;
            }
            if (type instanceof TemplateParameterTypeImpl) {
                return this.isRecursion(((TemplateParameterTypeImpl)type).getTemplateType(), i - 1);
            }
            return false;
        }

        public boolean isTemplateBased() {
            return this.isTemplateBased(new HashSet<CsmType>());
        }

        @Override
        public boolean isTemplateBased(Set<CsmType> visited) {
            if (this.instantiatedType == null) {
                return true;
            }
            if (visited.contains(this)) {
                return false;
            }
            visited.add(this);
            if (this.instantiatedType instanceof Resolver.SafeTemplateBasedProvider) {
                return ((Resolver.SafeTemplateBasedProvider)this.instantiatedType).isTemplateBased(visited);
            }
            return this.instantiatedType.isTemplateBased();
        }

        public boolean isReference() {
            if (this.instantiationHappened()) {
                return this.originalType.isReference() || this.instantiatedType.isReference();
            }
            return this.originalType.isReference();
        }

        public boolean isPointer() {
            if (this.instantiationHappened()) {
                return this.originalType.isPointer() || this.instantiatedType.isPointer();
            }
            return this.originalType.isPointer();
        }

        public boolean isConst() {
            if (this.instantiationHappened()) {
                return this.originalType.isConst() || this.instantiatedType.isConst();
            }
            return this.originalType.isConst();
        }

        public boolean isBuiltInBased(boolean resolveTypeChain) {
            return this.instantiatedType.isBuiltInBased(resolveTypeChain);
        }

        public List<CsmSpecializationParameter> getInstantiationParams() {
            if (!this.originalType.isInstantiation()) {
                return Collections.emptyList();
            }
            ArrayList<CsmSpecializationParameter> res = new ArrayList<CsmSpecializationParameter>();
            for (CsmSpecializationParameter instParam : this.originalType.getInstantiationParams()) {
                if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instParam) && CsmKindUtilities.isTemplateParameterType((CsmObject)((CsmTypeBasedSpecializationParameter)instParam).getType())) {
                    CsmTemplateParameterType paramType = (CsmTemplateParameterType)((CsmTypeBasedSpecializationParameter)instParam).getType();
                    CsmSpecializationParameter newTp = (CsmSpecializationParameter)this.instantiation.getMapping().get(paramType.getParameter());
                    if (newTp != null && newTp != instParam) {
                        res.add(newTp);
                        continue;
                    }
                    res.add(instParam);
                    continue;
                }
                res.add(instParam);
            }
            return res;
        }

        public int getPointerDepth() {
            if (this.instantiationHappened()) {
                return this.instantiatedType.getPointerDepth();
            }
            return this.originalType.getPointerDepth();
        }

        public CsmClassifier getClassifier() {
            return this.getClassifier(new ArrayList<CsmInstantiation>(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public CsmClassifier getClassifier(List<CsmInstantiation> instantiations, boolean specialize) {
            instantiations.add(this.instantiation);
            if (this.resolved == null) {
                if (!this.instantiationHappened()) {
                    classifier = this.originalType instanceof TypeImpl != false ? ((TypeImpl)this.originalType).getClassifier(instantiations, false) : (this.originalType instanceof Type != false ? ((Type)this.originalType).getClassifier(instantiations, false) : this.originalType.getClassifier());
                    if (this.inst && CsmKindUtilities.isTemplate((CsmObject)classifier)) {
                        ip = CsmInstantiationProvider.getDefault();
                        obj = null;
                        if (ip instanceof InstantiationProviderImpl) {
                            resolver = ResolverFactory.createResolver((CsmOffsetable)this);
                            try {
                                if (!resolver.isRecursionOnResolving(200)) {
                                    if (this.isTemplateParameterTypeBased() && this.instantiation.getMapping().keySet().contains(this.getResolvedTemplateParameter())) ** GOTO lbl22
                                    obj = ((InstantiationProviderImpl)ip).instantiate((CsmTemplate)classifier, this.instantiation, specialize);
                                }
                                var7_7 = null;
                                return var7_7;
                            }
                            finally {
                                ResolverFactory.releaseResolver(resolver);
                            }
                        } else {
                            obj = ip.instantiate((CsmTemplate)classifier, this.instantiation);
                        }
lbl22:
                        // 3 sources

                        if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                            this.resolved = (CsmClassifier)obj;
                            return this.resolved;
                        }
                    }
                    this.resolved = classifier;
                } else {
                    this.resolved = this.instantiatedType instanceof TypeImpl != false ? ((TypeImpl)this.instantiatedType).getClassifier(instantiations, false) : (this.instantiatedType instanceof Type != false ? ((Type)this.instantiatedType).getClassifier(instantiations, false) : this.instantiatedType.getClassifier());
                }
                if (CsmKindUtilities.isTypedef((CsmObject)this.resolved) && CsmKindUtilities.isClassMember((CsmObject)this.resolved) && CsmKindUtilities.isTemplate((CsmObject)(tdMember = (CsmMember)this.resolved).getContainingClass())) {
                    this.resolved = new Typedef((CsmTypedef)this.resolved, this.instantiation);
                    return this.resolved;
                }
            }
            return this.resolved;
        }

        public CharSequence getCanonicalText() {
            return this.originalType.getCanonicalText();
        }

        public int getArrayDepth() {
            if (this.instantiationHappened()) {
                return this.originalType.getArrayDepth() + this.instantiatedType.getArrayDepth();
            }
            return this.originalType.getArrayDepth();
        }

        public CsmInstantiation getInstantiation() {
            return this.instantiation;
        }

        public boolean isTemplateParameterTypeBased() {
            CsmType baseType = this.originalType;
            while (baseType instanceof Type) {
                if (((Type)baseType).instantiationHappened()) {
                    return true;
                }
                baseType = ((Type)baseType).originalType;
            }
            return false;
        }

        public CsmTemplateParameter getResolvedTemplateParameter() {
            CsmType baseType = this.originalType;
            while (baseType instanceof Type) {
                if (((Type)baseType).parameter != null) {
                    return ((Type)baseType).parameter;
                }
                baseType = ((Type)baseType).originalType;
            }
            return null;
        }

        public String toString() {
            String res = "INSTANTIATION OF TYPE: " + this.originalType + " with types (" + this.instantiation.getMapping() + ")";
            if (this.instantiationHappened()) {
                res = res + " becomes " + this.instantiatedType;
            }
            return res;
        }
    }

    private static class TemplateParameterType
    extends Type
    implements CsmTemplateParameterType {
        public TemplateParameterType(CsmType type, CsmInstantiation instantiation) {
            super(type, instantiation);
        }

        public CsmTemplateParameter getParameter() {
            return ((CsmTemplateParameterType)this.instantiatedType).getParameter();
        }

        public CsmType getTemplateType() {
            return ((CsmTemplateParameterType)this.instantiatedType).getTemplateType();
        }
    }

    private static class Parameter
    extends Instantiation<CsmParameter>
    implements CsmParameter {
        private final CsmType type;

        public Parameter(CsmParameter parameter, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)parameter, instantiation.getMapping(), null);
            this.type = parameter.isVarArgs() ? TypeFactory.getVarArgType() : Parameter.createType(parameter.getType(), instantiation);
        }

        public boolean isExtern() {
            return ((CsmParameter)this.declaration).isExtern();
        }

        public CsmType getType() {
            return this.type;
        }

        public CsmExpression getInitialValue() {
            return ((CsmParameter)this.declaration).getInitialValue();
        }

        public CharSequence getDisplayText() {
            return ((CsmParameter)this.declaration).getDisplayText();
        }

        public CsmVariableDefinition getDefinition() {
            return ((CsmParameter)this.declaration).getDefinition();
        }

        public CharSequence getDeclarationText() {
            return ((CsmParameter)this.declaration).getDeclarationText();
        }

        public boolean isVarArgs() {
            return ((CsmParameter)this.declaration).isVarArgs();
        }

        @Override
        public String toString() {
            return "INSTANTIATION OF FUN PARAM: " + this.getTemplateDeclaration() + " with types (" + this.mapping + ")";
        }
    }

    private static class Method
    extends Instantiation<CsmMethod>
    implements CsmMethod,
    CsmFunctionDefinition {
        private final CsmInstantiation instantiation;
        private final CsmType retType;
        private CsmFunctionDefinition definition = null;
        private CsmClass containingClass = null;

        public Method(CsmMethod method, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)method, instantiation.getMapping(), null);
            this.instantiation = instantiation;
            this.retType = Method.createType(method.getReturnType(), instantiation);
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmMethod)this.declaration).getScopeElements();
        }

        public boolean isStatic() {
            return ((CsmMethod)this.declaration).isStatic();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMethod)this.declaration).getVisibility();
        }

        public CsmClass getContainingClass() {
            if (this.containingClass == null) {
                this.containingClass = this._getContainingClass();
            }
            return this.containingClass;
        }

        public CsmClass _getContainingClass() {
            CsmObject inst;
            CsmInstantiationProvider p;
            CsmClass containingClass = ((CsmMethod)this.declaration).getContainingClass();
            if (CsmKindUtilities.isTemplate((CsmObject)containingClass) && (p = CsmInstantiationProvider.getDefault()) instanceof InstantiationProviderImpl && (inst = ((InstantiationProviderImpl)p).instantiate((CsmTemplate)containingClass, this.instantiation)) instanceof CsmClass) {
                return (CsmClass)inst;
            }
            return containingClass;
        }

        public boolean isTemplate() {
            return ((CsmTemplate)this.declaration).isTemplate();
        }

        public boolean isInline() {
            return ((CsmMethod)this.declaration).isInline();
        }

        public CharSequence getSignature() {
            return ((CsmMethod)this.declaration).getSignature();
        }

        public CsmType getReturnType() {
            return this.retType;
        }

        public CsmFunctionParameterList getParameterList() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmFunction)this.declaration).getParameterList().getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            return FunctionParameterListImpl.create(((CsmFunction)this.declaration).getParameterList(), res);
        }

        public Collection<CsmParameter> getParameters() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmMethod)this.declaration).getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this.instantiation));
            }
            return res;
        }

        public CsmFunctionDefinition getDefinition() {
            if (this.definition == null) {
                this.definition = this._getDefinition();
            }
            return this.definition;
        }

        public CsmFunctionDefinition _getDefinition() {
            CsmClass cls = this.getContainingClass();
            if (CsmKindUtilities.isSpecialization((CsmObject)cls) && this.declaration instanceof FunctionImpl) {
                FunctionImpl decl = (FunctionImpl)this.declaration;
                return decl.getDefinition(cls);
            }
            return ((CsmMethod)this.declaration).getDefinition();
        }

        public CharSequence getDeclarationText() {
            return ((CsmMethod)this.declaration).getDeclarationText();
        }

        public boolean isVirtual() {
            return ((CsmMethod)this.declaration).isVirtual();
        }

        public boolean isExplicit() {
            return ((CsmMethod)this.declaration).isExplicit();
        }

        public boolean isConst() {
            return ((CsmMethod)this.declaration).isConst();
        }

        public boolean isAbstract() {
            return ((CsmMethod)this.declaration).isAbstract();
        }

        public boolean isOperator() {
            return ((CsmMethod)this.declaration).isOperator();
        }

        public CsmFunction.OperatorKind getOperatorKind() {
            return ((CsmMethod)this.declaration).getOperatorKind();
        }

        public CsmCompoundStatement getBody() {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.declaration)) {
                return ((CsmFunctionDefinition)this.declaration).getBody();
            }
            return null;
        }

        public CsmFunction getDeclaration() {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.declaration)) {
                return ((CsmFunctionDefinition)this.declaration).getDeclaration();
            }
            return this;
        }

        @Override
        public String toString() {
            return "INSTANTIATION OF METHOD: " + this.getTemplateDeclaration() + " with types (" + this.mapping + ")";
        }
    }

    private static class ClassForward
    extends Instantiation<CsmClassForwardDeclaration>
    implements CsmClassForwardDeclaration,
    CsmMember {
        private CsmClass csmClass = null;

        public ClassForward(CsmClassForwardDeclaration forward, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)forward, mapping, null);
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }

        public CsmClass getCsmClass() {
            if (this.csmClass == null) {
                CsmClass declClassifier = ((CsmClassForwardDeclaration)this.declaration).getCsmClass();
                this.csmClass = CsmKindUtilities.isTemplate((CsmObject)declClassifier) ? (CsmClass)Instantiation.create((CsmTemplate)declClassifier, this.getMapping()) : declClassifier;
            }
            return this.csmClass;
        }

        @Override
        public String toString() {
            return "INSTANTIATION OF CLASS FORWARD: " + this.getTemplateDeclaration() + " with types (" + this.mapping + ")";
        }
    }

    private static class Typedef
    extends Instantiation<CsmTypedef>
    implements CsmTypedef,
    CsmMember {
        private final CsmType type;

        public Typedef(CsmTypedef typedef, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)typedef, instantiation.getMapping(), null);
            this.type = Typedef.createType(typedef.getType(), instantiation);
        }

        public boolean isTypeUnnamed() {
            return ((CsmTypedef)this.declaration).isTypeUnnamed();
        }

        public CsmType getType() {
            return this.type;
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }

        @Override
        public String toString() {
            return "INSTANTIATION OF TYPEDEF: " + this.getTemplateDeclaration() + " with types (" + this.mapping + ")";
        }
    }

    private static class Field
    extends Instantiation<CsmField>
    implements CsmField {
        private final CsmType type;

        public Field(CsmField field, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)field, instantiation.getMapping(), null);
            this.type = Field.createType(field.getType(), instantiation);
        }

        public boolean isExtern() {
            return ((CsmField)this.declaration).isExtern();
        }

        public CsmType getType() {
            return this.type;
        }

        public CsmExpression getInitialValue() {
            return ((CsmField)this.declaration).getInitialValue();
        }

        public CharSequence getDisplayText() {
            return ((CsmField)this.declaration).getDisplayText();
        }

        public CsmVariableDefinition getDefinition() {
            return ((CsmField)this.declaration).getDefinition();
        }

        public CharSequence getDeclarationText() {
            return ((CsmField)this.declaration).getDeclarationText();
        }

        public boolean isStatic() {
            return ((CsmField)this.declaration).isStatic();
        }

        public CsmVisibility getVisibility() {
            return ((CsmField)this.declaration).getVisibility();
        }

        public CsmClass getContainingClass() {
            return ((CsmField)this.declaration).getContainingClass();
        }

        @Override
        public String toString() {
            return "INSTANTIATION OF FIELD: " + this.getTemplateDeclaration() + " with types (" + this.mapping + ")";
        }
    }

    private static class Function
    extends Instantiation<CsmFunction>
    implements CsmFunction {
        private final CsmType retType;

        public Function(CsmFunction function, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)function, mapping, null);
            this.retType = Function.createType(function.getReturnType(), this);
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmFunction)this.declaration).getScopeElements();
        }

        public boolean isTemplate() {
            return ((CsmTemplate)this.declaration).isTemplate();
        }

        public boolean isInline() {
            return ((CsmFunction)this.declaration).isInline();
        }

        public boolean isOperator() {
            return ((CsmFunction)this.declaration).isOperator();
        }

        public CsmFunction.OperatorKind getOperatorKind() {
            return ((CsmFunction)this.declaration).getOperatorKind();
        }

        public CharSequence getSignature() {
            return ((CsmFunction)this.declaration).getSignature();
        }

        public CsmType getReturnType() {
            return this.retType;
        }

        public CsmFunctionParameterList getParameterList() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmFunction)this.declaration).getParameterList().getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            res.trimToSize();
            return FunctionParameterListImpl.create(((CsmFunction)this.declaration).getParameterList(), res);
        }

        public Collection<CsmParameter> getParameters() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmFunction)this.declaration).getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            return res;
        }

        public CsmFunctionDefinition getDefinition() {
            return ((CsmFunction)this.declaration).getDefinition();
        }

        public CsmFunction getDeclaration() {
            return ((CsmFunction)this.declaration).getDeclaration();
        }

        public CharSequence getDeclarationText() {
            return ((CsmFunction)this.declaration).getDeclarationText();
        }

        @Override
        public String toString() {
            return "INSTANTIATION OF FUNCTION: " + this.getTemplateDeclaration() + " with types (" + this.mapping + ")";
        }

        public boolean isStatic() {
            return false;
        }
    }

    private static class Inheritance
    implements CsmInheritance {
        private final CsmInheritance inheritance;
        private final CsmType type;
        private CsmClassifier resolvedClassifier;

        public Inheritance(CsmInheritance inheritance, Instantiation instantiation) {
            this.inheritance = inheritance;
            this.type = Instantiation.createType(inheritance.getAncestorType(), instantiation);
        }

        public CsmType getAncestorType() {
            return this.type;
        }

        public CharSequence getText() {
            return this.inheritance.getText();
        }

        public CsmOffsetable.Position getStartPosition() {
            return this.inheritance.getStartPosition();
        }

        public int getStartOffset() {
            return this.inheritance.getStartOffset();
        }

        public CsmOffsetable.Position getEndPosition() {
            return this.inheritance.getEndPosition();
        }

        public int getEndOffset() {
            return this.inheritance.getEndOffset();
        }

        public CsmFile getContainingFile() {
            return this.inheritance.getContainingFile();
        }

        public boolean isVirtual() {
            return this.inheritance.isVirtual();
        }

        public CsmVisibility getVisibility() {
            return this.inheritance.getVisibility();
        }

        public CsmClassifier getClassifier() {
            if (this.resolvedClassifier == null) {
                CsmType t = this.getAncestorType();
                this.resolvedClassifier = t.getClassifier();
            }
            return this.resolvedClassifier;
        }

        public CsmScope getScope() {
            return this.inheritance.getScope();
        }

        public String toString() {
            return "INSTANTION OF INHERITANCE: " + this.inheritance + " with " + this.type;
        }
    }

    public static class Class
    extends Instantiation<CsmClass>
    implements CsmClass,
    CsmMember,
    CsmTemplate,
    SelectImpl.FilterableMembers {
        public Class(CsmClass clazz, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)clazz, mapping, null);
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmClass)this.declaration).getScopeElements();
        }

        public Collection<CsmTypedef> getEnclosingTypedefs() {
            return ((CsmClass)this.declaration).getEnclosingTypedefs();
        }

        public Collection<CsmVariable> getEnclosingVariables() {
            return ((CsmClass)this.declaration).getEnclosingVariables();
        }

        public boolean isTemplate() {
            return ((CsmTemplate)this.declaration).isTemplate();
        }

        public boolean isSpecialization() {
            return ((CsmTemplate)this.declaration).isSpecialization();
        }

        public boolean isExplicitSpecialization() {
            return ((CsmTemplate)this.declaration).isExplicitSpecialization();
        }

        private boolean isRecursion(CsmTemplate type, int i) {
            if (i == 0) {
                return true;
            }
            if (type instanceof Class) {
                Class t = (Class)type;
                return this.isRecursion((CsmTemplate)t.declaration, i - 1);
            }
            return false;
        }

        private CsmMember createMember(CsmMember member) {
            if (member instanceof CsmField) {
                return new Field((CsmField)member, this);
            }
            if (member instanceof CsmMethod) {
                return new Method((CsmMethod)member, this);
            }
            if (member instanceof CsmTypedef) {
                return new Typedef((CsmTypedef)member, this);
            }
            if (member instanceof CsmClass) {
                CsmFile file;
                Class newClass = new Class((CsmClass)member, this.getMapping());
                if (UIDProviderIml.isPersistable(newClass.getUID()) && (file = newClass.getContainingFile()) instanceof FileImpl) {
                    ((FileImpl)file).addInstantiation(newClass);
                }
                return newClass;
            }
            if (member instanceof CsmClassForwardDeclaration) {
                return new ClassForward((CsmClassForwardDeclaration)member, this.getMapping());
            }
            if (member instanceof CsmEnum) {
                return member;
            }
            if (member instanceof CsmUsingDeclaration) {
                return member;
            }
            assert (false) : "Unknown class for member instantiation:" + member + " of class:" + member.getClass();
            return member;
        }

        public Collection<CsmMember> getMembers() {
            ArrayList<CsmMember> res = new ArrayList<CsmMember>();
            for (CsmMember member : ((CsmClass)this.declaration).getMembers()) {
                res.add(this.createMember(member));
            }
            return res;
        }

        @Override
        public Iterator<CsmMember> getMembers(CsmSelect.CsmFilter filter) {
            ArrayList<CsmMember> res = new ArrayList<CsmMember>();
            Iterator it = CsmSelect.getClassMembers((CsmClass)((CsmClass)this.declaration), (CsmSelect.CsmFilter)filter);
            while (it.hasNext()) {
                res.add(this.createMember((CsmMember)it.next()));
            }
            return res.iterator();
        }

        public int getLeftBracketOffset() {
            return ((CsmClass)this.declaration).getLeftBracketOffset();
        }

        public Collection<CsmFriend> getFriends() {
            return ((CsmClass)this.declaration).getFriends();
        }

        public Collection<CsmInheritance> getBaseClasses() {
            ArrayList<CsmInheritance> res = new ArrayList<CsmInheritance>();
            for (CsmInheritance inh : ((CsmClass)this.declaration).getBaseClasses()) {
                res.add(new Inheritance(inh, this));
            }
            return res;
        }

        @Override
        public String toString() {
            return "INSTANTIATION OF CLASS: " + this.getTemplateDeclaration() + " with types (" + this.mapping + ")";
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }

        public CharSequence getDisplayName() {
            return ((CsmTemplate)this.declaration).getDisplayName();
        }

        public List<CsmTemplateParameter> getTemplateParameters() {
            return ((CsmTemplate)this.declaration).getTemplateParameters();
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
        }

        public Class(RepositoryDataInput input) throws IOException {
            super(input);
        }
    }
}

