/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public final class NamespaceAliasImpl
extends OffsetableDeclarationBase<CsmNamespaceAlias>
implements CsmNamespaceAlias,
RawNamable {
    private final CharSequence alias;
    private final CharSequence namespace;
    private final CharSequence rawName;
    private CsmUID<CsmNamespace> referencedNamespaceUID = null;
    private CsmUID<CsmScope> scopeUID = null;

    private NamespaceAliasImpl(AST ast, CsmFile file, CsmScope scope) {
        super(file, NamespaceAliasImpl.getStartOffset(ast), NamespaceAliasImpl.getEndOffset(ast));
        AST token;
        this._setScope(scope);
        this.rawName = NamespaceAliasImpl.createRawName(ast);
        this.alias = NameCache.getManager().getString(AstUtil.getText(ast));
        for (token = ast.getFirstChild(); token != null && token.getType() != 6; token = token.getNextSibling()) {
        }
        StringBuilder sb = new StringBuilder();
        if (token == null) {
            if (FileImpl.reportErrors) {
                int ln = ast.getLine();
                int col = ast.getColumn();
                AST child = ast.getFirstChild();
                if (child != null) {
                    ln = child.getLine();
                    col = child.getColumn();
                }
                System.err.println("Corrupted AST for namespace alias in " + file.getAbsolutePath() + ' ' + ln + ":" + col);
            }
            this.namespace = CharSequences.empty();
        } else {
            for (token = token.getNextSibling(); token != null; token = token.getNextSibling()) {
                sb.append(token.getText());
            }
            this.namespace = QualifiedNameCache.getManager().getString((CharSequence)sb.toString());
        }
    }

    public static NamespaceAliasImpl create(AST ast, CsmFile file, CsmScope scope, boolean global) {
        NamespaceAliasImpl namespaceAliasImpl = new NamespaceAliasImpl(ast, file, scope);
        if (!global) {
            Utils.setSelfUID(namespaceAliasImpl);
        }
        return namespaceAliasImpl;
    }

    private void _setScope(CsmScope scope) {
        this.scopeUID = UIDCsmConverter.scopeToUID(scope);
        assert (this.scopeUID != null || scope == null);
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        assert (scope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        return scope;
    }

    public CsmNamespace getReferencedNamespace() {
        CsmScope scope;
        CsmNamespace res = ((ProjectBase)this.getContainingFile().getProject()).findNamespace(this.namespace, true);
        if (res == null && (scope = this.getScope()) instanceof CsmNamespace) {
            StringBuilder sb = new StringBuilder(((CsmNamespace)scope).getQualifiedName());
            sb.append("::");
            sb.append(this.namespace);
            res = ((ProjectBase)this.getContainingFile().getProject()).findNamespace(sb, true);
        }
        return res;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_ALIAS;
    }

    public CharSequence getAlias() {
        return this.alias;
    }

    public CharSequence getName() {
        return this.getAlias();
    }

    public CharSequence getQualifiedName() {
        CharSequence scopeQName;
        CsmScope scope = this.getScope();
        if ((scope instanceof CsmNamespace || scope instanceof CsmNamespaceDefinition) && (scopeQName = ((CsmQualifiedNamedElement)scope).getQualifiedName()) != null && scopeQName.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)scopeQName).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    private static CharSequence createRawName(AST node) {
        AST token;
        for (token = node.getFirstChild(); token != null && token.getType() != 6; token = token.getNextSibling()) {
        }
        if (token != null && (token = token.getNextSibling()) != null && token.getType() == 510) {
            return AstUtil.getRawName(token.getFirstChild());
        }
        return CharSequences.empty();
    }

    @Override
    public CharSequence[] getRawName() {
        return AstUtil.toRawName(this.rawName);
    }

    @Override
    public String toString() {
        return "" + this.getKind() + ' ' + this.alias + '=' + this.namespace + this.getPositionString();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        CsmScope scope = this._getScope();
        if (scope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)scope).removeDeclaration(this);
        }
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.alias != null);
        PersistentUtils.writeUTF(this.alias, output);
        assert (this.namespace != null);
        PersistentUtils.writeUTF(this.namespace, output);
        PersistentUtils.writeUTF(this.rawName, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedNamespaceUID, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
    }

    public NamespaceAliasImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.alias = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.alias != null);
        this.namespace = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.namespace != null);
        this.rawName = PersistentUtils.readUTF(input, NameCache.getManager());
        this.referencedNamespaceUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }
}

