/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainerNamespace;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public class NamespaceImpl
implements CsmNamespace,
MutableDeclarationsContainer,
Persistent,
SelfPersistent,
Disposable,
CsmIdentifiable {
    private static final CharSequence GLOBAL = CharSequences.create((CharSequence)"$Global$");
    private Object projectRef;
    private final CsmUID<CsmProject> projectUID;
    private CsmNamespace parentRef;
    private final CsmUID<CsmNamespace> parentUID;
    private final CharSequence name;
    private final CharSequence qualifiedName;
    private final Map<CharSequence, CsmUID<CsmNamespace>> nestedNamespaces;
    private final Key declarationsSorageKey;
    private final Set<CsmUID<CsmOffsetableDeclaration>> unnamedDeclarations;
    private final TreeMap<FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> nsDefinitions;
    private final ReadWriteLock nsDefinitionsLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock projectLock = new ReentrantReadWriteLock();
    private final boolean global;
    private static final boolean CHECK_PARENT = false;
    private static final String UNNAMED_PREFIX = "<unnamed>";
    private Set<Integer> unnamedNrs = new HashSet<Integer>();
    private WeakReference<DeclarationContainerNamespace> weakDeclarationContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
    private int preventMultiplyDiagnosticExceptions = 0;
    private CsmUID<CsmNamespace> uid = null;
    public static final Comparator<FileNameSortedKey> defenitionComparator = new Comparator<FileNameSortedKey>(){

        @Override
        public int compare(FileNameSortedKey o1, FileNameSortedKey o2) {
            return o1.compareTo(o2);
        }
    };

    private NamespaceImpl(ProjectBase project, boolean fake) {
        this.name = GLOBAL;
        this.qualifiedName = CharSequences.empty();
        this.parentUID = null;
        this.parentRef = null;
        this.global = true;
        assert (project != null);
        this.projectUID = UIDCsmConverter.projectToUID(project);
        assert (this.projectUID != null);
        this.unnamedDeclarations = Collections.synchronizedSet(new HashSet());
        this.nestedNamespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
        this.nsDefinitions = new TreeMap(defenitionComparator);
        this.projectRef = new WeakReference<ProjectBase>(project);
        this.declarationsSorageKey = fake ? null : new DeclarationContainerNamespace(this).getKey();
    }

    public static NamespaceImpl create(ProjectBase project, boolean fake) {
        NamespaceImpl namespaceImpl = new NamespaceImpl(project, fake);
        if (!fake) {
            project.registerNamespace(namespaceImpl);
        }
        return namespaceImpl;
    }

    protected NamespaceImpl(ProjectBase project, NamespaceImpl parent, String name, String qualifiedName) {
        this.name = NameCache.getManager().getString((CharSequence)name);
        this.global = false;
        assert (project != null);
        this.projectUID = UIDCsmConverter.projectToUID(project);
        assert (this.projectUID != null);
        this.unnamedDeclarations = Collections.synchronizedSet(new HashSet());
        this.nestedNamespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
        this.nsDefinitions = new TreeMap(defenitionComparator);
        this.projectRef = new WeakReference<ProjectBase>(project);
        this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)qualifiedName);
        this.parentUID = UIDCsmConverter.namespaceToUID(parent);
        assert (this.parentUID != null || parent == null);
        this.parentRef = null;
        this.declarationsSorageKey = new DeclarationContainerNamespace(this).getKey();
    }

    public static NamespaceImpl create(ProjectBase project, NamespaceImpl parent, String name, String qualifiedName) {
        NamespaceImpl namespaceImpl = new NamespaceImpl(project, parent, name, qualifiedName);
        project.registerNamespace(namespaceImpl);
        if (parent != null) {
            parent.addNestedNamespace(namespaceImpl);
        }
        namespaceImpl.notify(namespaceImpl, NotifyEvent.NAMESPACE_ADDED);
        return namespaceImpl;
    }

    protected void notify(CsmObject obj, NotifyEvent kind) {
        switch (kind) {
            case DECLARATION_ADDED: {
                assert (obj instanceof CsmOffsetableDeclaration);
                if (ForwardClass.isForwardClass((CsmDeclaration)((CsmOffsetableDeclaration)obj))) break;
                Notificator.instance().registerNewDeclaration((CsmOffsetableDeclaration)obj);
                break;
            }
            case DECLARATION_REMOVED: {
                assert (obj instanceof CsmOffsetableDeclaration);
                if (ForwardClass.isForwardClass((CsmDeclaration)((CsmOffsetableDeclaration)obj))) break;
                Notificator.instance().registerRemovedDeclaration((CsmOffsetableDeclaration)obj);
                break;
            }
            case NAMESPACE_ADDED: {
                assert (obj instanceof CsmNamespace);
                assert (!((CsmNamespace)obj).isGlobal());
                Notificator.instance().registerNewNamespace((CsmNamespace)obj);
                break;
            }
            case NAMESPACE_REMOVED: {
                assert (obj instanceof CsmNamespace);
                assert (!((CsmNamespace)obj).isGlobal());
                Notificator.instance().registerRemovedNamespace((CsmNamespace)obj);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected kind " + (Object)((Object)kind));
            }
        }
    }

    @Override
    public void dispose() {
        this.onDispose();
        this.notify(this, NotifyEvent.NAMESPACE_REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispose() {
        this.projectLock.writeLock().lock();
        try {
            if (this.projectRef == null) {
                this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (this.projectRef != null || this.projectUID == null) : "no object for UID " + this.projectUID;
            }
            if (this.parentRef == null) {
                this.parentRef = UIDCsmConverter.UIDtoNamespace(this.parentUID);
                assert (this.parentRef != null || this.parentUID == null) : "no object for UID " + this.parentUID;
            }
        }
        finally {
            this.projectLock.writeLock().unlock();
        }
        this.weakDeclarationContainer = null;
    }

    public String getNameForUnnamedElement() {
        String out = UNNAMED_PREFIX;
        int minVal = this.getMinUnnamedValue();
        if (minVal != 0) {
            out = out + minVal;
        }
        this.unnamedNrs.add(minVal);
        return out;
    }

    private int getMinUnnamedValue() {
        for (int i = 0; i < this.unnamedNrs.size(); ++i) {
            if (this.unnamedNrs.contains(i)) continue;
            return i;
        }
        return this.unnamedNrs.size();
    }

    public CsmNamespace getParent() {
        return this._getParentNamespace();
    }

    public Collection<CsmNamespace> getNestedNamespaces() {
        Collection<CsmNamespace> out = UIDCsmConverter.UIDsToNamespaces(new ArrayList(this.nestedNamespaces.values()));
        return out;
    }

    private DeclarationContainerNamespace getDeclarationsSorage() {
        if (this.declarationsSorageKey == null) {
            return DeclarationContainerNamespace.empty();
        }
        DeclarationContainerNamespace dc = null;
        WeakReference<DeclarationContainerNamespace> weak = null;
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && (weak = this.weakDeclarationContainer) != null && (dc = (DeclarationContainerNamespace)weak.get()) != null) {
            return dc;
        }
        dc = (DeclarationContainerNamespace)RepositoryUtils.get(this.declarationsSorageKey);
        if (dc == null && this.preventMultiplyDiagnosticExceptions < 3) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get DeclarationsSorage by key " + this.declarationsSorageKey));
            ++this.preventMultiplyDiagnosticExceptions;
        }
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && dc != null && this.weakDeclarationContainer != null) {
            this.weakDeclarationContainer = new WeakReference<DeclarationContainerNamespace>(dc);
        }
        return dc != null ? dc : DeclarationContainerNamespace.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        DeclarationContainerNamespace declStorage = this.getDeclarationsSorage();
        Collection uids = declStorage.getDeclarationsUIDs();
        Set<CsmUID<CsmOffsetableDeclaration>> set = this.unnamedDeclarations;
        synchronized (set) {
            uids.addAll(this.unnamedDeclarations);
        }
        Collection<CsmOffsetableDeclaration> decls = UIDCsmConverter.UIDsToDeclarations(uids);
        return decls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter filter) {
        DeclarationContainerNamespace declStorage = this.getDeclarationsSorage();
        Collection uids = declStorage.getDeclarationsUIDs();
        Set<CsmUID<CsmOffsetableDeclaration>> set = this.unnamedDeclarations;
        synchronized (set) {
            uids.addAll(this.unnamedDeclarations);
        }
        return UIDCsmConverter.UIDsToDeclarations(uids, filter);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> findUidsByPrefix(String prefix) {
        char maxChar = '\u00ff';
        return this.findUidsRange(prefix, prefix + maxChar);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> findUidsRange(String from, String to) {
        DeclarationContainerNamespace declStorage = this.getDeclarationsSorage();
        return declStorage.getUIDsRange(from, to);
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence fqn, CsmDeclaration.Kind[] kinds) {
        DeclarationContainerNamespace declStorage = this.getDeclarationsSorage();
        return declStorage.getDeclarationsRange(fqn, kinds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUnnamedUids() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> uids;
        Set<CsmUID<CsmOffsetableDeclaration>> set = this.unnamedDeclarations;
        synchronized (set) {
            uids = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.unnamedDeclarations);
        }
        return uids;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public CharSequence getQualifiedName() {
        return this.qualifiedName;
    }

    public CharSequence getName() {
        return this.name;
    }

    private void addNestedNamespace(NamespaceImpl nsp) {
        assert (nsp != null);
        CsmUID<NamespaceImpl> nestedNsUid = RepositoryUtils.put(nsp);
        assert (nestedNsUid != null);
        this.nestedNamespaces.put(nsp.getQualifiedName(), nestedNsUid);
        RepositoryUtils.put(this);
    }

    private void removeNestedNamespace(NamespaceImpl nsp) {
        assert (nsp != null);
        CsmUID<CsmNamespace> nestedNsUid = this.nestedNamespaces.remove(nsp.getQualifiedName());
        assert (nestedNsUid != null);
        if (nsp.getName().length() == 0) {
            String fqn = ((Object)nsp.getQualifiedName()).toString();
            int greaterInd = fqn.lastIndexOf(62);
            assert (greaterInd >= 0);
            if (greaterInd + 1 < fqn.length()) {
                try {
                    Integer index = Integer.parseInt(fqn.substring(greaterInd + 1));
                    this.unnamedNrs.remove(index);
                }
                catch (NumberFormatException ex) {
                    DiagnosticExceptoins.register(ex);
                }
            } else {
                this.unnamedNrs.remove(0);
            }
        }
        RepositoryUtils.put(this);
    }

    public static boolean isNamespaceScope(VariableImpl<?> var, boolean isFileLevel) {
        if (((FileImpl)var.getContainingFile()).isHeaderFile() && !CsmKindUtilities.isVariableDefinition(var)) {
            return true;
        }
        if (var.isStatic()) {
            return false;
        }
        return !var.isConst() || !isFileLevel || var.isExtern();
    }

    public static boolean isNamespaceScope(FunctionImpl<?> func) {
        if (((FileImpl)func.getContainingFile()).isHeaderFile() && !func.isPureDefinition()) {
            return true;
        }
        return !func.isStatic();
    }

    public static boolean isNamespaceScope(CsmFile file, boolean pureDefinition, boolean _static) {
        if (((FileImpl)file).isHeaderFile() && !pureDefinition) {
            return true;
        }
        return !_static;
    }

    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, int end, CharSequence name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(CsmOffsetableDeclaration declaration) {
        boolean unnamed;
        boolean bl = unnamed = !Utils.canRegisterDeclaration((CsmDeclaration)declaration);
        if (unnamed && !CsmKindUtilities.isEnum((CsmObject)declaration)) {
            return;
        }
        if (declaration instanceof VariableImpl) {
            VariableImpl v = (VariableImpl)declaration;
            if (NamespaceImpl.isNamespaceScope(v, this.isGlobal())) {
                v.setScope((CsmScope)this);
            } else {
                return;
            }
        }
        if (unnamed) {
            this.unnamedDeclarations.add(UIDCsmConverter.declarationToUID(declaration));
        } else {
            this.getDeclarationsSorage().putDeclaration(declaration);
        }
        RepositoryUtils.put(this);
        this.notify((CsmObject)declaration, NotifyEvent.DECLARATION_ADDED);
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration declaration) {
        if (declaration.getName().length() == 0) {
            CsmUID declarationUid = UIDs.get((Object)declaration);
            this.unnamedDeclarations.remove(declarationUid);
        } else {
            this.getDeclarationsSorage().removeDeclaration(declaration);
        }
        RepositoryUtils.put(this);
        this.notify((CsmObject)declaration, NotifyEvent.DECLARATION_REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmNamespaceDefinition> getDefinitions() {
        ArrayList uids = new ArrayList();
        try {
            this.nsDefinitionsLock.readLock().lock();
            uids.addAll(this.nsDefinitions.values());
        }
        finally {
            this.nsDefinitionsLock.readLock().unlock();
        }
        Collection<CsmNamespaceDefinition> defs = UIDCsmConverter.UIDsToDeclarations(uids);
        return defs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespaceDefinition(CsmNamespaceDefinition def) {
        CsmUID<CsmNamespaceDefinition> definitionUid = RepositoryUtils.put(def);
        boolean add = false;
        try {
            this.nsDefinitionsLock.writeLock().lock();
            add = this.nsDefinitions.isEmpty();
            this.nsDefinitions.put(NamespaceImpl.getSortKey(def), definitionUid);
        }
        finally {
            this.nsDefinitionsLock.writeLock().unlock();
        }
        RepositoryUtils.put(this);
        if (add) {
            this.addRemoveInParentNamespace(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addRemoveInParentNamespace(boolean add) {
        if (add) {
            NamespaceImpl parent = (NamespaceImpl)this._getParentNamespace();
            if (parent != null) {
                parent.addNestedNamespace(this);
            }
            this._getProject().registerNamespace(this);
        } else {
            try {
                this.nsDefinitionsLock.readLock().lock();
                if (!this.nsDefinitions.isEmpty()) {
                    return;
                }
            }
            finally {
                this.nsDefinitionsLock.readLock().unlock();
            }
            NamespaceImpl parent = (NamespaceImpl)this._getParentNamespace();
            if (parent != null) {
                parent.removeNestedNamespace(this);
            }
            this.projectRef = this._getProject();
            ((ProjectBase)this.projectRef).unregisterNamesace(this);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespaceDefinition(CsmNamespaceDefinition def) {
        assert (!this.isGlobal());
        boolean remove = false;
        CsmUID<CsmNamespaceDefinition> definitionUid = null;
        try {
            this.nsDefinitionsLock.writeLock().lock();
            definitionUid = this.nsDefinitions.remove(NamespaceImpl.getSortKey(def));
            remove = this.nsDefinitions.isEmpty();
        }
        finally {
            this.nsDefinitionsLock.writeLock().unlock();
        }
        RepositoryUtils.put(this);
        if (remove) {
            this.addRemoveInParentNamespace(false);
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return (List)this.getDeclarations();
    }

    public CsmProject getProject() {
        return this._getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmNamespace> getUID() {
        CsmUID<CsmNamespace> out = this.uid;
        if (out == null) {
            NamespaceImpl namespaceImpl = this;
            synchronized (namespaceImpl) {
                if (this.uid == null) {
                    this.uid = out = this.createUID();
                }
            }
        }
        return this.uid;
    }

    protected CsmUID<CsmNamespace> createUID() {
        return UIDUtilities.createNamespaceUID(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBase _getProject() {
        ProjectBase prj;
        Object o = this.projectRef;
        if (o instanceof ProjectBase) {
            return (ProjectBase)o;
        }
        if (o instanceof Reference && (prj = (ProjectBase)((Reference)o).get()) != null) {
            return prj;
        }
        this.projectLock.readLock().lock();
        try {
            prj = null;
            if (this.projectRef instanceof ProjectBase) {
                prj = (ProjectBase)this.projectRef;
            } else if (this.projectRef instanceof Reference) {
                Reference ref = (Reference)this.projectRef;
                prj = (ProjectBase)ref.get();
            }
            if (prj == null) {
                prj = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (prj != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
                this.projectRef = new WeakReference<ProjectBase>(prj);
            }
            ProjectBase projectBase = prj;
            return projectBase;
        }
        finally {
            this.projectLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmNamespace _getParentNamespace() {
        this.projectLock.readLock().lock();
        try {
            CsmNamespace ns = this.parentRef;
            if (ns == null) {
                ns = UIDCsmConverter.UIDtoNamespace(this.parentUID);
                assert (ns != null || this.parentUID == null) : "null object for UID " + this.parentUID;
            }
            CsmNamespace csmNamespace = ns;
            return csmNamespace;
        }
        finally {
            this.projectLock.readLock().unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(' ');
        sb.append(this.getQualifiedName());
        sb.append(" NamespaceImpl @");
        sb.append(this.hashCode());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(RepositoryDataOutput output) throws IOException {
        output.writeBoolean(this.global);
        UIDObjectFactory theFactory = UIDObjectFactory.getDefaultFactory();
        assert (this.projectUID != null);
        theFactory.writeUID(this.projectUID, output);
        theFactory.writeUID(this.parentUID, output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        assert (this.qualifiedName != null);
        PersistentUtils.writeUTF(this.qualifiedName, output);
        theFactory.writeStringToUIDMap(this.nestedNamespaces, output, true);
        ProjectComponent.writeKey(this.declarationsSorageKey, output);
        try {
            this.nsDefinitionsLock.readLock().lock();
            theFactory.writeNameSortedToUIDMap2(this.nsDefinitions, output, false);
        }
        finally {
            this.nsDefinitionsLock.readLock().unlock();
        }
        theFactory.writeUIDCollection(this.unnamedDeclarations, output, true);
    }

    public NamespaceImpl(RepositoryDataInput input) throws IOException {
        this.global = input.readBoolean();
        UIDObjectFactory theFactory = UIDObjectFactory.getDefaultFactory();
        this.projectUID = theFactory.readUID(input);
        this.parentUID = theFactory.readUID(input);
        assert (this.projectUID != null);
        this.projectRef = null;
        this.parentRef = null;
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        this.qualifiedName = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.qualifiedName != null);
        int collSize = input.readInt();
        this.nestedNamespaces = collSize <= 0 ? new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(0) : new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(collSize);
        theFactory.readStringToUIDMap(this.nestedNamespaces, input, QualifiedNameCache.getManager(), collSize);
        this.declarationsSorageKey = ProjectComponent.readKey(input);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        this.nsDefinitions = theFactory.readNameSortedToUIDMap2(input, null);
        collSize = input.readInt();
        this.unnamedDeclarations = collSize < 0 ? Collections.synchronizedSet(new HashSet(0)) : Collections.synchronizedSet(new HashSet(collSize));
        theFactory.readUIDCollection(this.unnamedDeclarations, input, collSize);
    }

    private static FileNameSortedKey getSortKey(CsmNamespaceDefinition def) {
        return new FileNameSortedKey(def);
    }

    public static class FileNameSortedKey
    implements Comparable<FileNameSortedKey>,
    Persistent,
    SelfPersistent {
        private final int start;
        private final int fileIndex;

        private FileNameSortedKey(CsmNamespaceDefinition def) {
            this(UIDUtilities.getFileID(((FileImpl)def.getContainingFile()).getUID()), def.getStartOffset());
        }

        private FileNameSortedKey(int fileIndex, int start) {
            this.start = start;
            this.fileIndex = fileIndex;
        }

        @Override
        public int compareTo(FileNameSortedKey o) {
            int res = this.fileIndex - o.fileIndex;
            if (res == 0) {
                res = this.start - o.start;
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileNameSortedKey) {
                FileNameSortedKey key = (FileNameSortedKey)obj;
                return this.compareTo(key) == 0;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + this.start;
            hash = 37 * hash + this.fileIndex;
            return hash;
        }

        public String toString() {
            return "FileNameSortedKey: " + this.fileIndex + "[" + this.start;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeInt(this.start);
            output.writeInt(this.fileIndex);
        }

        public FileNameSortedKey(RepositoryDataInput input) throws IOException {
            this.start = input.readInt();
            this.fileIndex = input.readInt();
        }
    }

    protected static enum NotifyEvent {
        DECLARATION_ADDED,
        DECLARATION_REMOVED,
        NAMESPACE_ADDED,
        NAMESPACE_REMOVED;

    }
}

