/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileIncludesKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentIncludes
extends FileComponent
implements Persistent,
SelfPersistent {
    private Set<CsmUID<CsmInclude>> includes = this.createIncludes();
    private Set<CsmUID<CsmInclude>> brokenIncludes = new LinkedHashSet<CsmUID<CsmInclude>>(0);
    private final ReadWriteLock includesLock = new ReentrantReadWriteLock();
    private static final FileComponentIncludes EMPTY = new FileComponentIncludes(){

        @Override
        public void put() {
        }
    };
    private static final Comparator<CsmUID<?>> UID_START_OFFSET_COMPARATOR = new Comparator<CsmUID<?>>(){

        @Override
        public int compare(CsmUID<?> o1, CsmUID<?> o2) {
            if (o1 == o2) {
                return 0;
            }
            Comparable i1 = (Comparable)o1;
            assert (i1 != null);
            return i1.compareTo(o2);
        }
    };

    public static FileComponentIncludes empty() {
        return EMPTY;
    }

    public FileComponentIncludes(FileImpl file) {
        super(new FileIncludesKey(file));
        this.put();
    }

    public FileComponentIncludes(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.readUIDCollection(this.includes, input);
        factory.readUIDCollection(this.brokenIncludes, input);
    }

    private FileComponentIncludes() {
        super((Key)null);
    }

    void clean() {
        this._clearIncludes();
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearIncludes() {
        try {
            this.includesLock.writeLock().lock();
            RepositoryUtils.remove(this.includes);
            this.brokenIncludes.clear();
            this.includes = this.createIncludes();
        }
        finally {
            this.includesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addInclude(IncludeImpl includeImpl, boolean broken) {
        CsmUID<IncludeImpl> inclUID = RepositoryUtils.put(includeImpl);
        assert (inclUID != null);
        try {
            this.includesLock.writeLock().lock();
            this.includes.add(inclUID);
            if (broken) {
                this.brokenIncludes.add(inclUID);
            } else {
                this.brokenIncludes.remove(inclUID);
            }
        }
        finally {
            this.includesLock.writeLock().unlock();
        }
        this.put();
        return !this.brokenIncludes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmInclude> getIncludes() {
        Collection<CsmInclude> out;
        try {
            this.includesLock.readLock().lock();
            out = UIDCsmConverter.UIDsToIncludes(this.includes);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmInclude> getIncludes(CsmSelect.CsmFilter filter) {
        Iterator<CsmInclude> out;
        try {
            this.includesLock.readLock().lock();
            out = UIDCsmConverter.UIDsToIncludes(this.includes, filter);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmInclude> getBrokenIncludes() {
        Collection<CsmInclude> out;
        try {
            this.includesLock.readLock().lock();
            out = UIDCsmConverter.UIDsToIncludes(this.brokenIncludes);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return out;
    }

    private Set<CsmUID<CsmInclude>> createIncludes() {
        return new TreeSet<CsmUID<CsmInclude>>(UID_START_OFFSET_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        try {
            this.includesLock.readLock().lock();
            factory.writeUIDCollection(this.includes, output, false);
            factory.writeUIDCollection(this.brokenIncludes, output, false);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
    }
}

