/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.util.WeakList;
import org.openide.util.Lookup;

public class ProgressSupport {
    private static final ProgressSupport instance = new ProgressSupport();
    private final WeakList<CsmProgressListener> progressListeners = new WeakList();

    private ProgressSupport() {
    }

    static ProgressSupport instance() {
        return instance;
    }

    void addProgressListener(CsmProgressListener listener) {
        this.progressListeners.add(listener);
    }

    void removeProgressListener(CsmProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    private Iterable<? extends CsmProgressListener> getProgressListeners() {
        Collection services = Lookup.getDefault().lookupAll(CsmProgressListener.class);
        return services.isEmpty() ? this.progressListeners : this.progressListeners.join(services);
    }

    void fireFileInvalidated(FileImpl file) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileInvalidated " + file.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileInvalidated((CsmFile)file);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireFileAddedToParse(FileImpl file) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileAddedToParse " + file.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileAddedToParse((CsmFile)file);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireFileParsingStarted(FileImpl file) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileParsingStarted " + file.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileParsingStarted((CsmFile)file);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireFileParsingFinished(FileImpl file) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireFileParsingFinished " + file.getAbsolutePath());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.fileParsingFinished((CsmFile)file);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireProjectParsingStarted(ProjectBase project) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectParsingStarted " + project.getName());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectParsingStarted((CsmProject)project);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireProjectParsingFinished(ProjectBase project) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectParsingFinished " + project.getName());
        }
        FileImpl.incParseCount();
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectParsingFinished((CsmProject)project);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireProjectLoaded(ProjectBase project) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectLoaded " + project.getName());
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectLoaded((CsmProject)project);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireIdle() {
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.parserIdle();
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }

    void fireProjectFilesCounted(ProjectBase project, int cnt) {
        if (TraceFlags.TRACE_PARSER_QUEUE || TraceFlags.TRACE_PARSER_PROGRESS) {
            System.err.println("fireProjectFilesCounted " + project.getName() + ' ' + cnt);
        }
        for (CsmProgressListener csmProgressListener : this.getProgressListeners()) {
            try {
                csmProgressListener.projectFilesCounted((CsmProject)project, cnt);
            }
            catch (Throwable e) {
                DiagnosticExceptoins.register(e);
            }
        }
    }
}

