/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.debug;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;

public class DiagnosticUnresolved {
    private Map<String, UnresolvedInfoBase> map = new HashMap<String, UnresolvedInfoBase>();
    private int level;

    public DiagnosticUnresolved(int level) {
        this.level = level;
    }

    private static String glueName(CharSequence[] nameTokens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nameTokens.length; ++i) {
            if (i > 0) {
                sb.append("::");
            }
            sb.append(nameTokens[i]);
        }
        return sb.toString();
    }

    public void onUnresolved(CharSequence[] nameTokens, CsmFile file, int offset) {
        if (this.level < 1) {
            return;
        }
        String name = DiagnosticUnresolved.glueName(nameTokens);
        UnresolvedInfoBase u = this.map.get(name);
        if (u == null) {
            u = this.level == 1 ? new UnresolvedInfoBase(name) : new UnresolvedInfoEx(name);
            this.map.put(name, u);
        }
        u.registerOccurence(file, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStatictics(String fileName, boolean append) throws FileNotFoundException {
        PrintStream out = new PrintStream(new FileOutputStream(fileName, append), true);
        try {
            this.dumpStatictics(out);
        }
        finally {
            out.close();
        }
    }

    protected void dumpStatictics(PrintStream out) {
        out.println("\n**** Unresolved names statistics\n");
        Comparator<UnresolvedInfoBase> comp = new Comparator<UnresolvedInfoBase>(){

            @Override
            public int compare(UnresolvedInfoBase ui1, UnresolvedInfoBase ui2) {
                if (ui1 == ui2) {
                    return 0;
                }
                return ui1.getCount() > ui2.getCount() ? -1 : 1;
            }
        };
        ArrayList<UnresolvedInfoBase> infos = new ArrayList<UnresolvedInfoBase>(this.map.values());
        int total = 0;
        Collections.sort(infos, comp);
        for (UnresolvedInfoBase ui : infos) {
            ui.dumpStatistics(out);
            total += ui.getCount();
        }
        out.println("Totally " + total + " unresolved");
    }

    private static class UnresolvedInfoEx
    extends UnresolvedInfoBase {
        private Map<CsmFile, IntArray> files = new HashMap<CsmFile, IntArray>();

        public UnresolvedInfoEx(String name) {
            super(name);
        }

        @Override
        public void registerOccurence(CsmFile file, int offset) {
            super.registerOccurence(file, offset);
            IntArray ia = this.files.get(file);
            if (ia == null) {
                ia = new IntArray();
                this.files.put(file, ia);
            }
            ia.add(offset);
        }

        @Override
        public void dumpStatistics(PrintStream out) {
            out.println(this.getName() + ' ' + this.getCount());
            out.println(" By files:");
            Comparator<CsmFile> comp = new Comparator<CsmFile>(){

                @Override
                public int compare(CsmFile o1, CsmFile o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    IntArray ia1 = (IntArray)UnresolvedInfoEx.this.files.get(o1);
                    IntArray ia2 = (IntArray)UnresolvedInfoEx.this.files.get(o2);
                    return ia1.size() > ia2.size() ? -1 : 1;
                }
            };
            ArrayList<CsmFile> list = new ArrayList<CsmFile>(this.files.keySet());
            Collections.sort(list, comp);
            for (CsmFile file : list) {
                IntArray ia = this.files.get(file);
                int cnt = ia == null ? -1 : ia.size();
                out.println("    " + file.getAbsolutePath() + ' ' + cnt);
            }
        }
    }

    private static class UnresolvedInfoBase {
        private String name;
        private int count;

        public UnresolvedInfoBase(String name) {
            this.name = name;
        }

        public void registerOccurence(CsmFile file, int offset) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }

        public void dumpStatistics(PrintStream out) {
            out.println(this.getName() + ' ' + this.getCount());
        }
    }

    private static class IntArray {
        private int[] data;
        private int size;

        public IntArray(int capacity) {
            this.data = new int[capacity];
            this.size = 0;
        }

        public IntArray() {
            this(64);
        }

        public int get(int index) {
            return this.data[index];
        }

        public int size() {
            return this.size;
        }

        public void add(int value) {
            if (!this.contains(value)) {
                if (this.size >= this.data.length) {
                    int[] old = this.data;
                    this.data = new int[old.length + 128];
                }
                this.data[this.size++] = value;
            }
        }

        protected boolean contains(int value) {
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] != value) continue;
                return true;
            }
            return false;
        }
    }
}

