/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.ArrayList;
import java.util.Stack;
import org.antlr.runtime.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.modelimpl.parser.FortranParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FortranToken;
import org.netbeans.modules.cnd.modelimpl.parser.FortranTokenStream;

public class FortranLexicalPrepass {
    private FortranTokenStream tokens;
    private Stack<Token> doLabels;
    private int sourceForm;

    public FortranLexicalPrepass(FortranTokenStream tokens) {
        this.tokens = tokens;
        this.doLabels = new Stack();
    }

    public void setSourceForm(int sourceForm) {
        this.sourceForm = sourceForm;
    }

    private boolean isAssignment(int start, int end) {
        return this.tokens.getToken(start).getType() == 431 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 341 && this.tokens.getToken(start + 2).getType() == 301;
    }

    private boolean isOperator(int start, int end) {
        return this.tokens.getToken(start).getType() == 313 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 341 && this.tokens.getToken(start + 2).getType() == 252 && this.tokens.getToken(start + 3).getType() == 294;
    }

    private void convertToIdents(int start, int end) {
        for (int i = start; i < end; ++i) {
            Token tmpToken = this.tokens.getToken(i);
            if (tmpToken == null) {
                System.out.println("convertToIdents(): couldn't retrieve token");
                System.out.println("start: " + start + " end: " + end + " i: " + i);
                this.tokens.printCurrLine();
                System.exit(1);
            }
            if (!FortranLexer.isKeyword(tmpToken) || this.isAssignment(i, end) || this.isOperator(i, end)) continue;
            tmpToken.setType(236);
        }
    }

    public int salesScanForToken(int start, int desiredToken) {
        int tmpToken;
        int lookAhead = 0;
        if (this.tokens.currLineLA(1) == 366) {
            return -1;
        }
        lookAhead = start;
        do {
            int parenOffset;
            if ((tmpToken = this.tokens.currLineLA(++lookAhead)) == 341 || tmpToken == 393) {
                parenOffset = this.tokens.findToken(lookAhead - 1, 341);
                ++parenOffset;
                lookAhead = this.matchClosingParen(start, lookAhead);
                tmpToken = this.tokens.currLineLA(lookAhead);
                continue;
            }
            if (tmpToken != 330) continue;
            parenOffset = this.tokens.findToken(lookAhead - 1, 330);
            lookAhead = this.matchClosingParen(lookAhead + 1, parenOffset += 2);
            tmpToken = this.tokens.currLineLA(lookAhead);
        } while (tmpToken != -1 && tmpToken != 242 && tmpToken != desiredToken);
        if (tmpToken == desiredToken) {
            return lookAhead - 1;
        }
        return -1;
    }

    private boolean matchIfConstStmt(int lineStart, int lineEnd) {
        int rparenOffset = -1;
        int commaOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 265 && this.tokens.currLineLA(lineStart + 2) == 341) {
            rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
            commaOffset = this.salesScanForToken(rparenOffset + 1, 378);
            if (rparenOffset == -1) {
                System.err.println("Error in IF stmt at line: " + this.tokens.getToken(0).getLine());
                return false;
            }
            if (this.tokens.currLineLA(rparenOffset + 1) == 266) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                return true;
            }
            if (commaOffset != -1 && this.tokens.currLineLA(rparenOffset + 1) == 304) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                this.tokens.addToken(lineStart, 328, "__T_ARITHMETIC_IF_STMT__");
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matchElseStmt(int lineStart, int lineEnd) {
        boolean isElseIf = false;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 338) {
            if (lineEnd >= 2) {
                if (this.tokens.currLineLA(lineStart + 2) == 276) {
                    this.convertToIdents(lineStart + 2, lineEnd);
                } else {
                    isElseIf = this.matchIfConstStmt(lineStart + 1, lineEnd);
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchDataDecl(int lineStart, int lineEnd) {
        int tokenType = this.tokens.currLineLA(1);
        if (this.isIntrinsicType(tokenType) || this.isPrefixToken(tokenType) || (tokenType == 418 || tokenType == 230) && this.tokens.currLineLA(lineStart + 2) == 341) {
            if (this.isSubDecl(lineStart, lineEnd)) {
                return false;
            }
            if (this.isFuncDecl(lineStart, lineEnd)) {
                this.fixupFuncDecl(lineStart, lineEnd);
            } else {
                this.fixupDataDecl(lineStart, lineEnd);
            }
            return true;
        }
        if (tokenType == 422) {
            this.fixupFuncDecl(lineStart, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchDerivedTypeStmt(int lineStart, int lineEnd) {
        Token identToken = null;
        if (this.tokens.currLineLA(lineStart + 1) == 418 && this.tokens.currLineLA(lineStart + 2) != 341) {
            int colonOffset = this.tokens.findToken(lineStart, 305);
            if (colonOffset != -1) {
                int identOffset = colonOffset + 1;
                this.convertToIdents(identOffset, lineEnd);
            } else {
                identToken = this.tokens.getToken(lineStart + 1);
                int identOffset = lineStart + 1;
                if (FortranLexer.isKeyword(identToken)) {
                    identToken.setType(236);
                }
                if (this.tokens.currLineLA(lineStart + 3) == 341) {
                    int rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 3) - 1;
                    if (this.isIntrinsicType(this.tokens.currLineLA(lineStart + 4))) {
                        this.fixupDeclTypeSpec(lineStart + 3, lineEnd);
                    } else {
                        this.convertToIdents(lineStart + 3, lineEnd);
                    }
                    if (lineEnd - 1 > rparenOffset + 1 && FortranLexer.isKeyword(this.tokens.currLineLA(rparenOffset + 2))) {
                        this.tokens.getToken(rparenOffset + 1).setType(236);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchSub(int lineStart, int lineEnd) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        int bindOffset = this.tokens.findToken(lineStart, 330);
        if (bindOffset != -1) {
            this.convertToIdents(lineStart + 1, bindOffset + lineStart);
        } else {
            this.convertToIdents(lineStart + 1, lineEnd);
        }
        return true;
    }

    private boolean matchEnd(int lineStart, int lineEnd) {
        boolean matchedEnd = false;
        boolean isEndDo = false;
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 259) {
            if (lineEnd > 2) {
                identOffset = this.tokens.currLineLA(lineStart + 2) == 226 ? lineStart + 3 : (this.tokens.currLineLA(lineStart + 2) == 237 ? this.matchGenericSpec(lineStart + 2, lineEnd) : lineStart + 2);
            }
            if (this.tokens.currLineLA(lineStart + 2) == 332) {
                isEndDo = true;
            }
            matchedEnd = true;
        } else if (tokenType == 296) {
            identOffset = lineStart + 2;
            matchedEnd = true;
        } else if (tokenType == 258) {
            identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
        } else {
            if (lineEnd > 1) {
                identOffset = lineStart + 1;
            }
            matchedEnd = true;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
        }
        if (isEndDo || tokenType == 408) {
            this.fixupLabeledEndDo(lineStart, lineEnd);
        }
        return matchedEnd;
    }

    private boolean matchModule(int lineStart, int lineEnd) {
        this.convertToIdents(lineStart + 1, lineEnd);
        return true;
    }

    private boolean matchBlockData(int lineStart, int lineEnd) {
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 226) {
            if (this.tokens.currLineLA(lineStart + 2) == 274) {
                if (lineEnd >= lineStart + 3 && FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 3))) {
                    this.tokens.getToken(lineStart + 2).setType(236);
                }
                return true;
            }
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 284) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
                this.tokens.getToken(lineStart + 1).setType(236);
            }
            return true;
        }
        return false;
    }

    private boolean matchUseStmt(int lineStart, int lineEnd) {
        Object onlyToken = null;
        int colonOffset = this.tokens.findToken(lineStart, 305);
        int identPos = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        if (FortranLexer.isKeyword(this.tokens.currLineLA(identPos + 1))) {
            this.tokens.getToken(identPos).setType(236);
        }
        if (++identPos < lineEnd) {
            if (this.tokens.currLineLA(identPos + 1) == 378 && this.tokens.currLineLA(identPos + 2) == 402) {
                identPos += 3;
            }
            this.convertToIdents(identPos, lineEnd);
        }
        return true;
    }

    private boolean matchLabel(int lineStart, int lineEnd) {
        return this.tokens.currLineLA(1) == 304;
    }

    private boolean matchIdentColon(int lineStart, int lineEnd) {
        int secondToken = this.tokens.currLineLA(lineStart + 2);
        if (secondToken == 398) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
                this.tokens.getToken(lineStart).setType(236);
            }
            return true;
        }
        return false;
    }

    private boolean matchProcStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 356 && this.tokens.currLineLA(lineStart + 2) != 341) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 305);
            identOffset = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 1) == 345 && this.tokens.currLineLA(lineStart + 2) == 356) {
            if (lineEnd < lineStart + 4) {
                return false;
            }
            identOffset = lineStart + 2;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchProcDeclStmt(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 356) {
            int lParenOffset = lineStart + 1;
            int rParenOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
            int colonOffset = this.tokens.findToken(rParenOffset + 1, 305);
            if (colonOffset != -1) {
                this.convertToIdents(colonOffset + 1, lineEnd);
            } else {
                this.convertToIdents(rParenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchAttrStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 295) {
            int lParenOffset = this.tokens.findToken(lineStart + 1, 341);
            identOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
        } else if (firstToken == 330) {
            int rParenOffset;
            identOffset = rParenOffset = this.matchClosingParen(lineStart, lineStart + 2);
        } else if (firstToken == 414) {
            int lParenOffset = this.tokens.findToken(lineStart + 1, 341);
            if (lParenOffset == -1) {
                System.err.println("Syntax error in PARAMETER statement");
                System.exit(1);
            }
            identOffset = lParenOffset;
            lineEnd = this.matchClosingParen(lineStart, lParenOffset + 1);
        } else if (firstToken == 264) {
            int lparenOffset = -1;
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 373) {
                do {
                    if ((lparenOffset = this.tokens.findToken(lineStart, 341)) == -1) continue;
                    rparenOffset = this.matchClosingParen(lineStart, lparenOffset + 1);
                    for (int i = lparenOffset; i < rparenOffset; ++i) {
                        if (!FortranLexer.isKeyword(this.tokens.currLineLA(i + 1)) || this.tokens.currLineLA(i + 1) == 253 || this.tokens.currLineLA(i + 1) == 427) continue;
                        this.tokens.getToken(i).setType(236);
                    }
                    if (this.tokens.currLineLA(rparenOffset + 1) == 341) {
                        rparenOffset = this.matchClosingParen(lineStart, rparenOffset + 1);
                    }
                    lineStart = rparenOffset;
                } while (lineStart < lineEnd && this.tokens.currLineLA(lineStart + 1) != 242);
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private int matchClosingParen(int lineStart, int offset) {
        int tmpTokenType;
        int lookAhead = 0;
        int nestingLevel = 0;
        lookAhead = offset;
        nestingLevel = 1;
        do {
            if ((tmpTokenType = this.tokens.currLineLA(++lookAhead)) == 341 || tmpTokenType == 393) {
                ++nestingLevel;
            } else if (tmpTokenType == 294 || tmpTokenType == 340) {
                --nestingLevel;
            }
            if (tmpTokenType != 242 && tmpTokenType != -1 || nestingLevel == 0) continue;
            System.err.println("Error: matchClosingParen(): Missing closing paren on line " + this.tokens.getToken(lookAhead - 1).getLine() + ":");
            System.err.println("nestingLevel: " + nestingLevel);
            System.err.println("lookAhead is: " + lookAhead);
            this.tokens.printPackedList();
            System.exit(1);
        } while (nestingLevel != 0 || tmpTokenType != 294 && tmpTokenType != 340 && tmpTokenType != 242 && tmpTokenType != -1);
        if (tmpTokenType == 294 || tmpTokenType == 340) {
            return lookAhead;
        }
        return -1;
    }

    private int fixupDeclTypeSpec(int lineStart, int lineEnd) {
        int kindOffsetEnd = -1;
        if (this.tokens.currLineLA(lineStart + 1) == 418 || this.tokens.currLineLA(lineStart + 1) == 230) {
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 341) {
                System.err.println("Derived type or Class declaration error!");
                System.exit(1);
            }
            rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            this.convertToIdents(lineStart + 1, rparenOffset);
            return rparenOffset - 1;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 341) {
            int kindTokenOffset = -1;
            int lenTokenOffset = -1;
            kindOffsetEnd = this.matchClosingParen(lineStart, this.tokens.findToken(lineStart, 341) + 1);
            kindTokenOffset = this.tokens.findToken(lineStart + 1, 253);
            lenTokenOffset = this.tokens.findToken(lineStart + 1, 427);
            this.convertToIdents(lineStart + 1, kindOffsetEnd);
            if (kindTokenOffset != -1 && kindTokenOffset < kindOffsetEnd && this.tokens.currLineLA(kindTokenOffset + 2) == 301) {
                this.tokens.getToken(kindTokenOffset).setType(253);
            }
            if (lenTokenOffset != -1 && lenTokenOffset < kindOffsetEnd && this.tokens.currLineLA(lenTokenOffset + 2) == 301) {
                this.tokens.getToken(lenTokenOffset).setType(427);
            }
            return kindOffsetEnd - 1;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 344) {
            ++lineStart;
        }
        return lineStart;
    }

    private void fixupDataDecl(int lineStart, int lineEnd) {
        int identOffset = this.tokens.findToken(lineStart = this.fixupDeclTypeSpec(lineStart, lineEnd), 305);
        identOffset = identOffset != -1 ? ++identOffset : lineStart + 1;
        this.convertToIdents(identOffset, lineEnd);
    }

    private void fixupFuncDecl(int lineStart, int lineEnd) {
        int newLineStart = 0;
        Token resultToken = null;
        Token bindToken = null;
        newLineStart = this.fixupDeclTypeSpec(lineStart, lineEnd);
        if (newLineStart != lineStart) {
            lineStart = newLineStart + 1;
        }
        int identOffset = this.tokens.findToken(lineStart, 422) + 1;
        int resultOffset = this.salesScanForToken(lineStart, 379);
        int bindOffset = this.salesScanForToken(lineStart, 330);
        if (resultOffset != -1) {
            resultToken = this.tokens.getToken(resultOffset);
        }
        if (bindOffset != -1) {
            bindToken = this.tokens.getToken(bindOffset);
        }
        this.convertToIdents(identOffset, lineEnd);
        if (resultToken != null) {
            resultToken.setType(379);
        }
        if (bindToken != null) {
            bindToken.setType(330);
        }
    }

    private boolean isIntrinsicType(int type) {
        return type == 348 || type == 354 || type == 344 || type == 262 || type == 399 || type == 324 || type == 381;
    }

    private int skipTypeSpec(int lineStart) {
        int rparenOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (this.isIntrinsicType(firstToken) || firstToken == 418) {
            if (firstToken == 344) {
                ++lineStart;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 341) {
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            }
            lineStart = rparenOffset != -1 ? rparenOffset : ++lineStart;
            return lineStart;
        }
        return lineStart;
    }

    private int skipPrefix(int lineStart) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        lineStart = this.skipTypeSpec(lineStart);
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        return lineStart;
    }

    private boolean isPrefixToken(int token) {
        return token == 360 || token == 323 || token == 281;
    }

    private boolean isFuncDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 422 && (this.tokens.currLineLA(lineStart + 2) == 236 || FortranLexer.isKeyword(this.tokens.currLineLA(3)));
    }

    private boolean isSubDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 248 && (this.tokens.currLineLA(lineStart + 2) == 236 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2)));
    }

    private boolean isValidDataEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        return firstChar == 'i' || firstChar == 'b' && secondChar != 'n' && secondChar != 'z' || firstChar == 'o' || firstChar == 'z' || firstChar == 'f' || firstChar == 'g' || firstChar == 'l' || firstChar == 'a' || firstChar == 'd' && (secondChar == 't' || this.isDigit(secondChar)) || firstChar == 'e' && (secondChar == 'n' || secondChar == 's' || this.isDigit(secondChar));
    }

    private int findFormatItemEnd(String line, int lineIndex) {
        char currChar;
        int lineLength = line.length();
        do {
            currChar = line.charAt(lineIndex);
        } while (++lineIndex < lineLength && currChar != ',' && currChar != ')' && currChar != '/' && currChar != ':');
        return lineIndex - 1;
    }

    private int matchVList(String line, int lineIndex) {
        int tmpLineIndex = lineIndex + 2;
        int lineLength = line.length();
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
            while (line.charAt(tmpLineIndex) != '\'' && line.charAt(tmpLineIndex) != '\"' && tmpLineIndex < lineLength) {
                ++tmpLineIndex;
            }
        }
        if (tmpLineIndex == lineLength) {
            return lineIndex;
        }
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
        }
        if (line.charAt(tmpLineIndex) == '(') {
            ++tmpLineIndex;
            while (tmpLineIndex < lineLength && Character.isDigit(line.charAt(tmpLineIndex))) {
                ++tmpLineIndex;
            }
            if (tmpLineIndex == lineLength) {
                return lineIndex;
            }
            if (line.charAt(tmpLineIndex) == ')') {
                return ++tmpLineIndex;
            }
            System.err.println("Error: Unable to match v-list in data-edit-desc!");
            return lineIndex;
        }
        return lineIndex;
    }

    private int getDataEditDesc(String line, int lineIndex, int lineEnd) {
        while (lineIndex < lineEnd && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        if (this.isValidDataEditDesc(line, lineIndex)) {
            if (Character.toLowerCase(line.charAt(lineIndex)) == 'd' && Character.toLowerCase(line.charAt(lineIndex + 1)) == 't') {
                lineIndex = this.matchVList(line, lineIndex);
            }
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private boolean isDigit(char tmpChar) {
        return tmpChar >= '0' && tmpChar <= '9';
    }

    private boolean isLetter(char tmpChar) {
        return (tmpChar = Character.toLowerCase(tmpChar)) >= 'a' && tmpChar <= 'z';
    }

    private boolean isValidControlEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        if (firstChar == ':' || firstChar == '/' || firstChar == 'p' || firstChar == 't' || firstChar == 's' || firstChar == 'b' || firstChar == 'r' || firstChar == 'd' || firstChar == 'x') {
            if (firstChar == 's') {
                if (secondChar != 's' && secondChar != 'p' && Character.isLetterOrDigit(secondChar)) {
                    return false;
                }
                if (firstChar == 't' && !this.isDigit(secondChar) && secondChar != 'l' && secondChar != 'r') {
                    return false;
                }
                if (firstChar == 'b' && secondChar != 'n' && secondChar != 'z') {
                    return false;
                }
                if (firstChar == 'r' && secondChar != 'u' && secondChar != 'd' && secondChar != 'z' && secondChar != 'n' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
                if (firstChar == 'd' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private int getControlEditDesc(String line, int lineIndex, int lineLength) {
        while (lineIndex < lineLength && line.charAt(lineIndex) >= '0' && line.charAt(lineIndex) <= '9') {
            ++lineIndex;
        }
        if (this.isValidControlEditDesc(line, lineIndex)) {
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private int getCharString(String line, int lineIndex, char quoteChar) {
        char nextChar;
        if ((nextChar = line.charAt(++lineIndex)) == '\'' || nextChar == '\"') {
            return this.getCharString(line, lineIndex, nextChar);
        }
        while ((nextChar = line.charAt(++lineIndex)) != '\'' && nextChar != '\"') {
        }
        return lineIndex;
    }

    private int getCharStringEditDesc(String line, int lineIndex, int lineLength) {
        int startIndex = lineIndex;
        while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        char quoteChar = Character.toLowerCase(line.charAt(lineIndex));
        if (quoteChar == 'h' && startIndex != lineIndex) {
            return lineIndex + Integer.parseInt(line.substring(startIndex, lineIndex));
        }
        if (quoteChar != '\'' && quoteChar != '\"') {
            return -1;
        }
        lineIndex = this.getCharString(line, lineIndex, quoteChar);
        return this.findFormatItemEnd(line, lineIndex + 1);
    }

    private int parseFormatString(String line, int lineIndex, int lineNum, int charPos) {
        int descIndex = 0;
        boolean foundClosingParen = false;
        int lineLength = line.length();
        while (lineIndex < lineLength - 1 && !foundClosingParen) {
            descIndex = this.getCharStringEditDesc(line, lineIndex, lineLength);
            if (descIndex == -1) {
                descIndex = this.getDataEditDesc(line, lineIndex, lineLength);
                if (descIndex == -1) {
                    descIndex = this.getControlEditDesc(line, lineIndex, lineLength);
                    if (descIndex != -1 && (descIndex - lineIndex > 0 || line.charAt(descIndex) != '/')) {
                        this.tokens.addToken(this.tokens.createToken(249, line.substring(lineIndex, descIndex), lineNum, charPos));
                        charPos += line.substring(lineIndex, descIndex).length();
                    }
                } else {
                    this.tokens.addToken(this.tokens.createToken(318, line.substring(lineIndex, descIndex), lineNum, charPos));
                    charPos += line.substring(lineIndex, descIndex).length();
                }
            } else {
                this.tokens.addToken(this.tokens.createToken(256, line.substring(lineIndex, descIndex), lineNum, charPos));
                charPos += line.substring(lineIndex, descIndex).length();
            }
            if (descIndex != -1 || descIndex == -1 && !this.isDigit(line.charAt(lineIndex)) && line.charAt(lineIndex) != '(') {
                String termString = null;
                if (descIndex == -1) {
                    descIndex = lineIndex;
                }
                if (line.charAt(descIndex) == ',') {
                    termString = new String(",");
                    this.tokens.addToken(this.tokens.createToken(378, ",", lineNum, charPos));
                } else if (line.charAt(descIndex) == ')') {
                    this.tokens.addToken(this.tokens.createToken(294, ")", lineNum, charPos));
                } else {
                    termString = line.charAt(descIndex) == ':' ? new String(":") : (line.charAt(descIndex) == '/' ? new String("/") : null);
                    if (termString != null) {
                        this.tokens.addToken(this.tokens.createToken(249, termString, lineNum, charPos));
                    }
                }
                lineIndex = descIndex + 1;
            } else {
                int startIndex = lineIndex;
                while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
                    ++lineIndex;
                    ++charPos;
                }
                if (startIndex != lineIndex) {
                    this.tokens.addToken(this.tokens.createToken(304, line.substring(startIndex, lineIndex), lineNum, charPos - (lineIndex - startIndex)));
                }
                if (line.charAt(lineIndex) == '(') {
                    this.tokens.addToken(this.tokens.createToken(341, "(", lineNum, charPos));
                    descIndex = this.parseFormatString(line, ++lineIndex, lineNum, ++charPos);
                    if (descIndex == -1) {
                        System.err.println("Could not parse the format string: " + line);
                        return -1;
                    }
                    lineIndex = descIndex + 1;
                } else {
                    return -1;
                }
            }
            ++charPos;
        }
        if (lineIndex < lineLength && line.charAt(lineIndex) == ')') {
            this.tokens.addToken(this.tokens.createToken(294, ")", lineNum, charPos));
            ++lineIndex;
        }
        return lineIndex;
    }

    private int fixupFormatStmt(int lineStart, int lineEnd) {
        int lineIndex = 0;
        int i = 0;
        int lineLength = 0;
        int lineNum = 0;
        int charPos = 0;
        ArrayList<Token> origLine = new ArrayList<Token>();
        lineNum = this.tokens.getToken(lineStart).getLine();
        charPos = this.tokens.getToken(++lineStart).getCharPositionInLine();
        if (this.tokens.currLineLA(lineStart + 1) != 341) {
            return -1;
        }
        String line = this.tokens.lineToString(lineStart, lineEnd);
        origLine.addAll(this.tokens.getTokensList());
        this.tokens.clearTokensList();
        for (i = 0; i < lineStart; ++i) {
            this.tokens.addToken((Token)origLine.get(i));
        }
        lineIndex = 0;
        lineLength = line.length();
        lineIndex = this.parseFormatString(line, lineIndex, lineNum, charPos);
        this.tokens.addToken(this.tokens.createToken(242, "\n", lineNum, charPos + lineIndex));
        if (lineIndex == -1) {
            System.err.println("Error in format statement " + line + " at line " + lineNum);
            this.tokens.clearTokensList();
            for (i = 0; i < lineEnd; ++i) {
                this.tokens.addToken((Token)origLine.get(i));
            }
        }
        return lineIndex;
    }

    private boolean matchIOStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 246) {
            if (this.tokens.currLineLA(lineStart + 2) == 301) {
                return false;
            }
            identOffset = lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 2) == 341) {
            identOffset = lineStart + 2;
            if (tokenType == 389) {
                int rparenOffset = -1;
                rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
                if (rparenOffset != -1 && rparenOffset < lineEnd - 1 && this.tokens.currLineLA(rparenOffset + 1) != 242) {
                    this.tokens.addToken(lineStart, 319, "__T_INQUIRE_STMT_2__");
                    ++identOffset;
                }
            }
        } else if ((tokenType == 387 || tokenType == 327) && this.tokens.currLineLA(lineStart + 2) != 301) {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (tokenType == 370) {
                this.fixupFormatStmt(lineStart, lineEnd);
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 304) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchProgramStmt(int lineStart, int lineEnd) {
        if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
            this.tokens.getToken(lineStart + 1).setType(236);
        }
        return true;
    }

    private boolean labelsMatch(String label1, String label2) {
        return Integer.parseInt(label1) == Integer.parseInt(label2);
    }

    private void fixupLabeledEndDo(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(1) != 304) {
            return;
        }
        if (!this.doLabels.empty()) {
            String doLabelString = this.doLabels.peek().getText();
            Token firstToken = this.tokens.getToken(0);
            int endType = this.tokens.currLineLA(lineStart + 1);
            String labeledDoText = new String("LABELED_DO_TERM");
            if (this.labelsMatch(doLabelString, firstToken.getText())) {
                this.tokens.addToken(1, 353, labeledDoText);
                this.doLabels.pop();
                while (!this.doLabels.empty() && this.labelsMatch(this.doLabels.peek().getText(), firstToken.getText())) {
                    if (!(this.tokens.appendToken(304, new String(firstToken.getText())) && this.tokens.appendToken(353, labeledDoText) && this.tokens.appendToken(428, new String("CONTINUE")) && this.tokens.appendToken(242, null))) {
                        System.err.println("Couldn't add tokens!");
                        System.exit(1);
                    }
                    this.doLabels.pop();
                }
            }
        }
    }

    private boolean matchActionStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 243) {
            if (this.tokens.currLineLA(lineStart + 2) != 314) {
                return false;
            }
            identOffset = lineStart + 2;
        } else if (tokenType == 347) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 305);
            if (colonOffset != -1) {
                this.tokens.addToken(lineStart, 247, "__T_ALLOCATE_STMT_1__");
                ++lineStart;
                identOffset = colonOffset + 2;
            } else {
                identOffset = lineStart + 1;
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 304 && tokenType != 268) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchSingleTokenStmt(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 404 || firstToken == 350 || firstToken == 374 || firstToken == 276 || firstToken == 412 || firstToken == 384 || firstToken == 288 || firstToken == 303 || firstToken == 286 || firstToken == 263 || firstToken == 230 && this.tokens.currLineLA(lineStart + 2) != 371 || firstToken == 237 || firstToken == 352 || firstToken == 291 || firstToken == 274) {
            if (firstToken == 288 || firstToken == 263 && this.tokens.currLineLA(lineStart + 2) == 371) {
                this.convertToIdents(lineStart + 2, lineEnd);
            } else if (firstToken == 237) {
                int identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
                if (identOffset != -1) {
                    this.convertToIdents(identOffset, lineEnd);
                }
            } else if (firstToken == 352) {
                if (lineStart + 3 < lineEnd) {
                    if (this.tokens.currLineLA(lineStart + 3) == 341) {
                        int resultLA = this.matchClosingParen(lineStart + 3, lineStart + 3);
                        this.convertToIdents(lineStart + 1, resultLA - 1);
                        if (this.tokens.currLineLA(resultLA) == 379) {
                            this.convertToIdents(resultLA, lineEnd);
                        }
                    }
                } else {
                    this.convertToIdents(lineStart + 1, lineEnd);
                }
            } else {
                this.convertToIdents(lineStart + 1, lineEnd);
            }
            if (firstToken == 276) {
                this.tokens.addToken(lineStart, 411, "__T_WHERE_CONSTRUCT_STMT__");
            } else if (firstToken == 384) {
                this.tokens.addToken(lineStart, 329, "__T_FORALL_CONSTRUCT_STMT__");
            }
            return true;
        }
        return false;
    }

    private boolean matchDoStmt(int lineStart, int lineEnd) {
        int whileOffset = -1;
        if (this.tokens.currLineLA(lineStart + 2) == 242) {
            return true;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 304) {
            this.doLabels.push((Token)new FortranToken(this.tokens.getToken(lineStart + 1)));
        }
        if (this.tokens.currLineLA(lineStart + 3) == 242) {
            return true;
        }
        whileOffset = this.tokens.findToken(lineStart + 1, 388);
        int equalsOffset = this.salesScanForToken(lineStart + 1, 301);
        int identOffset = equalsOffset != -1 ? lineStart + 1 : whileOffset + 1;
        this.convertToIdents(identOffset, lineEnd);
        return true;
    }

    private boolean matchOneLineStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int rparenOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 276 || tokenType == 265 || tokenType == 384) {
            if (this.tokens.currLineLA(lineStart + 2) == 341) {
                identOffset = lineStart + 2;
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
                this.convertToIdents(identOffset, rparenOffset);
                if (!this.matchLine(rparenOffset, lineEnd)) {
                    this.matchAssignStmt(rparenOffset, lineEnd);
                }
                if (tokenType == 276) {
                    this.tokens.addToken(lineStart, 333, "__T_WHERE_STMT__");
                } else if (tokenType == 265) {
                    this.tokens.addToken(lineStart, 339, "__T_IF_STMT__");
                } else {
                    this.tokens.addToken(lineStart, 391, "__T_FORALL_STMT__");
                }
                if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 304) {
                    this.fixupLabeledEndDo(lineStart, lineEnd);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int matchDataRef(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 236 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
            if (this.tokens.currLineLA(lineStart + 2) == 341) {
                int tmpLineStart = this.matchClosingParen(lineStart, lineStart + 2);
                lineStart = tmpLineStart - 1;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 245) {
                return this.matchDataRef(lineStart + 2, lineEnd);
            }
            return lineStart;
        }
        return lineStart;
    }

    private boolean matchAssignStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int assignType = 0;
        if (lineEnd < lineStart + 3) {
            return false;
        }
        int newLineStart = this.matchDataRef(lineStart, lineEnd);
        if (this.tokens.currLineLA(newLineStart + 2) == 301 || this.tokens.currLineLA(newLineStart + 2) == 423) {
            identOffset = lineStart;
            assignType = this.tokens.currLineLA(newLineStart + 2);
        } else if (this.tokens.currLineLA(newLineStart + 2) == 341) {
            int rparenOffset = -1;
            rparenOffset = this.matchClosingParen(newLineStart, newLineStart + 2);
            if (this.tokens.currLineLA(rparenOffset + 1) == 301 || this.tokens.currLineLA(rparenOffset + 1) == 423) {
                identOffset = lineStart;
                assignType = this.tokens.currLineLA(rparenOffset + 1);
            }
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (assignType == 301) {
                this.tokens.addToken(lineStart, 297, "__T_ASSIGNMENT_STMT__");
            } else if (assignType == 423) {
                this.tokens.addToken(lineStart, 417, "__T_PTR_ASSIGNMENT_STMT__");
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 304) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private int matchGenericSpec(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 313 || firstToken == 431) {
            return lineStart + 1;
        }
        if (firstToken == 346 || firstToken == 271) {
            if (this.tokens.currLineLA(lineStart + 2) != 341) {
                return -1;
            }
            int rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            return rparenOffset + 1;
        }
        return lineStart;
    }

    private boolean matchGenericBinding(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 280) {
            int colonOffset = this.salesScanForToken(lineStart + 1, 305);
            if (colonOffset == -1) {
                return false;
            }
            int nextToken = this.tokens.currLineLA(colonOffset + 2);
            if (nextToken == 313 || nextToken == 431) {
                this.convertToIdents(colonOffset + 2, lineEnd);
            } else if (nextToken == 346 || nextToken == 271) {
                int nextTokenLA = colonOffset + 2;
                if (this.tokens.currLineLA(nextTokenLA + 1) != 341) {
                    return false;
                }
                int rparenOffset = this.matchClosingParen(lineStart, nextTokenLA + 1);
                this.convertToIdents(rparenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchLine(int lineStart, int lineEnd) {
        if (this.matchDataDecl(lineStart, lineEnd)) {
            return true;
        }
        if (this.matchDerivedTypeStmt(lineStart, lineEnd)) {
            return true;
        }
        switch (this.tokens.currLineLA(lineStart + 1)) {
            case 248: 
            case 281: 
            case 323: 
            case 360: {
                return this.matchSub(lineStart, lineEnd);
            }
            case 234: 
            case 258: 
            case 259: 
            case 269: 
            case 277: 
            case 296: 
            case 300: 
            case 315: 
            case 331: 
            case 336: 
            case 359: 
            case 368: 
            case 380: 
            case 408: 
            case 409: 
            case 410: 
            case 424: {
                return this.matchEnd(lineStart, lineEnd);
            }
            case 356: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchProcDeclStmt(lineStart, lineEnd);
            }
            case 345: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchModule(lineStart, lineEnd);
            }
            case 226: 
            case 284: {
                return this.matchBlockData(lineStart, lineEnd);
            }
            case 292: {
                return this.matchUseStmt(lineStart, lineEnd);
            }
            case 335: {
                return this.matchProgramStmt(lineStart, lineEnd);
            }
            case 238: 
            case 241: 
            case 243: 
            case 254: 
            case 268: 
            case 311: 
            case 326: 
            case 337: 
            case 347: 
            case 355: 
            case 420: 
            case 428: 
            case 432: {
                return this.matchActionStmt(lineStart, lineEnd);
            }
            case 265: {
                if (this.matchIfConstStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchOneLineStmt(lineStart, lineEnd);
            }
            case 338: {
                if (this.matchElseStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchSingleTokenStmt(lineStart, lineEnd);
            }
            case 332: {
                return this.matchDoStmt(lineStart, lineEnd);
            }
            case 225: 
            case 246: 
            case 271: 
            case 309: 
            case 327: 
            case 346: 
            case 370: 
            case 387: 
            case 389: {
                return this.matchIOStmt(lineStart, lineEnd);
            }
            case 250: 
            case 257: 
            case 261: 
            case 264: 
            case 267: 
            case 295: 
            case 330: 
            case 334: 
            case 343: 
            case 363: 
            case 377: 
            case 382: 
            case 385: 
            case 394: 
            case 395: 
            case 403: 
            case 407: 
            case 414: 
            case 415: {
                return this.matchAttrStmt(lineStart, lineEnd);
            }
        }
        return this.matchSingleTokenStmt(lineStart, lineEnd);
    }

    private void fixupFixedFormatLine(int lineStart, int lineEnd, boolean startsWithKeyword) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        if (startsWithKeyword) {
            Token token;
            do {
                System.out.println("fixed-format line must start with keyword");
                this.tokens.printPackedList();
                buffer = buffer.append(this.tokens.getToken(lineStart + i).getText());
                TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)buffer.toString().toUpperCase(), (String)"Fortran Language");
                ts = new APTCommentsFilter(ts);
                ts = APTLanguageSupport.getInstance().getFilter("Fortran Language").getFilteredStream(ts);
                FortranParserEx.MyTokenSource myLexer = new FortranParserEx.MyTokenSource(ts);
                token = myLexer.nextToken();
            } while (lineStart + ++i < lineEnd && !FortranLexer.isKeyword(token.getType()));
            if (lineStart + i == lineEnd) {
                System.err.println("Error: Expected keyword on line: " + token.getLine());
            } else {
                int j = 0;
                for (j = lineStart; j < lineStart + i; ++j) {
                    Token tmpToken = this.tokens.getToken(j);
                    tmpToken.setChannel(99);
                    this.tokens.set(j, tmpToken);
                }
                this.tokens.add(j, token);
            }
        } else {
            System.out.println("fixed-format line must NOT start with keyword");
        }
    }

    private int scanForRealConsts(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            if (this.tokens.currLineLA(i + 1) == 367) {
                this.tokens.getToken(i).setType(365);
                continue;
            }
            if (this.tokens.currLineLA(i + 1) != 304 || i + 2 >= lineEnd || this.tokens.currLineLA(i + 2) != 351 && this.tokens.currLineLA(i + 2) != 367) continue;
            StringBuffer newTokenText = new StringBuffer();
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            newTokenText.append(this.tokens.getToken(i).getText());
            newTokenText.append(this.tokens.getToken(i + 1).getText());
            if (this.sourceForm != 2 && col + this.tokens.getToken(i).getText().length() != this.tokens.getToken(i + 1).getCharPositionInLine()) {
                System.err.println("Error: Whitespace within real constant at {line:col}: " + line + ":" + (col + 1));
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken(365, newTokenText.toString(), line, col));
            --lineEnd;
        }
        return lineEnd;
    }

    private int scanForRelationalOp(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            int type;
            if (i + 2 >= lineEnd) {
                return lineEnd;
            }
            if (this.tokens.currLineLA(i + 1) != 351 || this.tokens.currLineLA(i + 2) != 236 || this.tokens.currLineLA(i + 3) != 351) continue;
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            String text = this.tokens.getToken(i + 1).getText();
            if (text.compareToIgnoreCase("EQ") == 0) {
                type = 316;
            } else if (text.compareToIgnoreCase("NE") == 0) {
                type = 362;
            } else if (text.compareToIgnoreCase("GT") == 0) {
                type = 235;
            } else if (text.compareToIgnoreCase("GE") == 0) {
                type = 227;
            } else if (text.compareToIgnoreCase("LT") == 0) {
                type = 421;
            } else {
                if (text.compareToIgnoreCase("LE") != 0) continue;
                type = 426;
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken(type, "." + text + ".", line, col));
            lineEnd -= 2;
        }
        return lineEnd;
    }

    public void performPrepass() {
        int tokensStart;
        int commaIndex = -1;
        int equalsIndex = -1;
        int lineLength = 0;
        int newLineLength = 0;
        Token eof = null;
        if (this.sourceForm == 2) {
            tokensStart = this.tokens.mark();
            this.tokens.fixupFixedFormat();
            this.tokens.rewind(tokensStart);
        }
        if ((tokensStart = this.tokens.mark()) != -1) {
            this.tokens.seek(-1);
            tokensStart = -1;
        }
        while (this.tokens.LA(1) != -1) {
            commaIndex = -1;
            equalsIndex = -1;
            int lineStart = 0;
            int rawLineStart = this.tokens.mark();
            this.tokens.setCurrLine(rawLineStart);
            lineLength = this.tokens.getCurrLineLength();
            int rawLineEnd = this.tokens.findTokenInSuper(rawLineStart, 242);
            if (rawLineEnd == -1) {
                rawLineEnd = this.tokens.getRawLineLength();
            }
            rawLineEnd += rawLineStart;
            if (this.tokens.currLineLA(1) == 240) {
                ++lineStart;
            }
            if (this.matchLabel(lineStart, lineLength)) {
                ++lineStart;
            }
            if (this.matchIdentColon(lineStart, lineLength)) {
                lineStart += 2;
            }
            if ((newLineLength = this.scanForRealConsts(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if (this.sourceForm == 2 && (newLineLength = this.scanForRelationalOp(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if ((commaIndex = this.salesScanForToken(lineStart, 378)) != -1) {
                this.matchLine(lineStart, lineLength);
            } else {
                equalsIndex = this.salesScanForToken(lineStart, 301);
                if (equalsIndex == -1) {
                    equalsIndex = this.salesScanForToken(lineStart, 423);
                }
                if (equalsIndex != -1) {
                    if (!(this.matchOneLineStmt(lineStart, lineLength) || this.matchProcStmt(lineStart, lineLength) || this.matchAssignStmt(lineStart, lineLength) || this.matchDataDecl(lineStart, lineLength) || this.matchGenericBinding(lineStart, lineLength))) {
                        System.err.println("Couldn't match line!");
                        this.tokens.printPackedList();
                    }
                } else if (!this.matchLine(lineStart, lineLength)) {
                    this.matchOneLineStmt(lineStart, lineLength);
                }
            }
            for (int i = rawLineStart; i < rawLineEnd; ++i) {
                this.tokens.consume();
            }
            this.tokens.finalizeLine();
        }
        eof = this.tokens.LT(1);
        eof.setText("EOF");
        this.tokens.addTokenToNewList(eof);
        this.tokens.rewind(tokensStart);
    }

    private static class FortranLexer {
        public static final int EOF = -1;
        public static final int NULL_TREE_LOOKAHEAD = 3;
        public static final int ELLIPSIS = 4;
        public static final int DOT = 5;
        public static final int ASSIGNEQUAL = 6;
        public static final int COLON = 7;
        public static final int COMMA = 8;
        public static final int QUESTIONMARK = 9;
        public static final int SEMICOLON = 10;
        public static final int POINTERTO = 11;
        public static final int LPAREN = 12;
        public static final int RPAREN = 13;
        public static final int LSQUARE = 14;
        public static final int RSQUARE = 15;
        public static final int LCURLY = 16;
        public static final int RCURLY = 17;
        public static final int EQUAL = 18;
        public static final int NOTEQUAL = 19;
        public static final int LESSTHANOREQUALTO = 20;
        public static final int LESSTHAN = 21;
        public static final int GREATERTHANOREQUALTO = 22;
        public static final int GREATERTHAN = 23;
        public static final int DIVIDE = 24;
        public static final int DIVIDEEQUAL = 25;
        public static final int PLUS = 26;
        public static final int PLUSEQUAL = 27;
        public static final int PLUSPLUS = 28;
        public static final int MINUS = 29;
        public static final int MINUSEQUAL = 30;
        public static final int MINUSMINUS = 31;
        public static final int STAR = 32;
        public static final int TIMESEQUAL = 33;
        public static final int MOD = 34;
        public static final int MODEQUAL = 35;
        public static final int SHIFTRIGHT = 36;
        public static final int SHIFTRIGHTEQUAL = 37;
        public static final int SHIFTLEFT = 38;
        public static final int SHIFTLEFTEQUAL = 39;
        public static final int AND = 40;
        public static final int NOT = 41;
        public static final int OR = 42;
        public static final int AMPERSAND = 43;
        public static final int BITWISEANDEQUAL = 44;
        public static final int TILDE = 45;
        public static final int BITWISEOR = 46;
        public static final int BITWISEOREQUAL = 47;
        public static final int BITWISEXOR = 48;
        public static final int BITWISEXOREQUAL = 49;
        public static final int POINTERTOMBR = 50;
        public static final int DOTMBR = 51;
        public static final int SCOPE = 52;
        public static final int AT = 53;
        public static final int DOLLAR = 54;
        public static final int BACK_SLASH = 55;
        public static final int DEFINED = 56;
        public static final int DBL_SHARP = 57;
        public static final int SHARP = 58;
        public static final int FUN_LIKE_MACRO_LPAREN = 59;
        public static final int LAST_CONST_TEXT_TOKEN = 61;
        public static final int FLOATONE = 62;
        public static final int FLOATTWO = 63;
        public static final int HEXADECIMALINT = 64;
        public static final int OCTALINT = 65;
        public static final int DECIMALINT = 66;
        public static final int Whitespace = 67;
        public static final int EndOfLine = 68;
        public static final int Skip = 69;
        public static final int PreProcComment = 70;
        public static final int PPLiterals = 71;
        public static final int Space = 72;
        public static final int PreProcBlockComment = 73;
        public static final int PreProcLineComment = 74;
        public static final int Comment = 75;
        public static final int CPPComment = 76;
        public static final int CHAR_LITERAL = 77;
        public static final int STRING_LITERAL = 78;
        public static final int InterStringWhitespace = 79;
        public static final int StringPart = 80;
        public static final int Escape = 81;
        public static final int Digit = 82;
        public static final int Decimal = 83;
        public static final int LongSuffix = 84;
        public static final int UnsignedSuffix = 85;
        public static final int FloatSuffix = 86;
        public static final int Exponent = 87;
        public static final int Vocabulary = 88;
        public static final int NUMBER = 89;
        public static final int ID = 90;
        public static final int BINARYINT = 91;
        public static final int INCLUDE_STRING = 92;
        public static final int SYS_INCLUDE_STRING = 93;
        public static final int END_PREPROC_DIRECTIVE = 94;
        public static final int INCLUDE = 95;
        public static final int INCLUDE_NEXT = 96;
        public static final int DEFINE = 97;
        public static final int UNDEF = 98;
        public static final int IFDEF = 99;
        public static final int IFNDEF = 100;
        public static final int IF = 101;
        public static final int ELIF = 102;
        public static final int ELSE = 103;
        public static final int ENDIF = 104;
        public static final int PRAGMA = 105;
        public static final int LINE = 106;
        public static final int ERROR = 107;
        public static final int PREPROC_DIRECTIVE = 108;
        public static final int LITERAL_OPERATOR = 109;
        public static final int LITERAL_alignof = 110;
        public static final int LITERAL___alignof__ = 111;
        public static final int LITERAL_typeof = 112;
        public static final int LITERAL___typeof__ = 113;
        public static final int LITERAL___typeof = 114;
        public static final int LITERAL_template = 115;
        public static final int LITERAL_typedef = 116;
        public static final int LITERAL_enum = 117;
        public static final int LITERAL_namespace = 118;
        public static final int LITERAL_extern = 119;
        public static final int LITERAL_inline = 120;
        public static final int LITERAL__inline = 121;
        public static final int LITERAL___inline__ = 122;
        public static final int LITERAL___inline = 123;
        public static final int LITERAL_virtual = 124;
        public static final int LITERAL_explicit = 125;
        public static final int LITERAL_friend = 126;
        public static final int LITERAL__stdcall = 127;
        public static final int LITERAL___stdcall = 128;
        public static final int LITERAL_typename = 129;
        public static final int LITERAL_auto = 130;
        public static final int LITERAL_register = 131;
        public static final int LITERAL_static = 132;
        public static final int LITERAL_mutable = 133;
        public static final int LITERAL_const = 134;
        public static final int LITERAL___const__ = 135;
        public static final int LITERAL___const = 136;
        public static final int LITERAL_const_cast = 137;
        public static final int LITERAL_volatile = 138;
        public static final int LITERAL___volatile__ = 139;
        public static final int LITERAL___volatile = 140;
        public static final int LITERAL_char = 141;
        public static final int LITERAL_wchar_t = 142;
        public static final int LITERAL_bool = 143;
        public static final int LITERAL_short = 144;
        public static final int LITERAL_int = 145;
        public static final int LITERAL_long = 146;
        public static final int LITERAL_signed = 147;
        public static final int LITERAL___signed__ = 148;
        public static final int LITERAL___signed = 149;
        public static final int LITERAL_unsigned = 150;
        public static final int LITERAL___unsigned__ = 151;
        public static final int LITERAL_float = 152;
        public static final int LITERAL_double = 153;
        public static final int LITERAL_void = 154;
        public static final int LITERAL__declspec = 155;
        public static final int LITERAL___declspec = 156;
        public static final int LITERAL_class = 157;
        public static final int LITERAL_struct = 158;
        public static final int LITERAL_union = 159;
        public static final int LITERAL_this = 160;
        public static final int LITERAL_true = 161;
        public static final int LITERAL_false = 162;
        public static final int LITERAL_public = 163;
        public static final int LITERAL_protected = 164;
        public static final int LITERAL_private = 165;
        public static final int LITERAL_throw = 166;
        public static final int LITERAL_case = 167;
        public static final int LITERAL_default = 168;
        public static final int LITERAL_if = 169;
        public static final int LITERAL_else = 170;
        public static final int LITERAL_switch = 171;
        public static final int LITERAL_while = 172;
        public static final int LITERAL_do = 173;
        public static final int LITERAL_for = 174;
        public static final int LITERAL_goto = 175;
        public static final int LITERAL_continue = 176;
        public static final int LITERAL_break = 177;
        public static final int LITERAL_return = 178;
        public static final int LITERAL_try = 179;
        public static final int LITERAL_catch = 180;
        public static final int LITERAL_using = 181;
        public static final int LITERAL_export = 182;
        public static final int LITERAL_asm = 183;
        public static final int LITERAL__asm = 184;
        public static final int LITERAL___asm__ = 185;
        public static final int LITERAL___asm = 186;
        public static final int LITERAL_sizeof = 188;
        public static final int LITERAL_dynamic_cast = 189;
        public static final int LITERAL_static_cast = 190;
        public static final int LITERAL_reinterpret_cast = 191;
        public static final int LITERAL_new = 192;
        public static final int LITERAL__cdecl = 193;
        public static final int LITERAL___cdecl = 194;
        public static final int LITERAL__near = 195;
        public static final int LITERAL___near = 196;
        public static final int LITERAL__far = 197;
        public static final int LITERAL___far = 198;
        public static final int LITERAL___interrupt = 199;
        public static final int LITERAL_pascal = 200;
        public static final int LITERAL__pascal = 201;
        public static final int LITERAL___pascal = 202;
        public static final int LITERAL_delete = 203;
        public static final int LITERAL__int64 = 204;
        public static final int LITERAL___int64 = 205;
        public static final int LITERAL___w64 = 206;
        public static final int LITERAL___extension__ = 207;
        public static final int LITERAL___attribute__ = 208;
        public static final int LITERAL_restrict = 209;
        public static final int LITERAL___restrict = 210;
        public static final int LITERAL___complex__ = 211;
        public static final int LITERAL___imag = 212;
        public static final int LITERAL___real = 213;
        public static final int LITERAL___global = 214;
        public static final int LITERAL__Complex = 215;
        public static final int LITERAL___thread = 216;
        public static final int LITERAL___attribute = 217;
        public static final int LITERAL__Imaginary = 218;
        public static final int T_CLOSE = 225;
        public static final int T_BLOCK = 226;
        public static final int T_GE = 227;
        public static final int T_CONTAINS = 228;
        public static final int T_ABSTRACT = 229;
        public static final int T_CLASS = 230;
        public static final int T_NOPASS = 231;
        public static final int T_UNFORMATTED = 232;
        public static final int T_LESSTHAN = 233;
        public static final int T_ENDSUBROUTINE = 234;
        public static final int T_GT = 235;
        public static final int T_IDENT = 236;
        public static final int T_INTERFACE = 237;
        public static final int T_RETURN = 238;
        public static final int T_XYZ = 239;
        public static final int T_EOF = 240;
        public static final int T_CALL = 241;
        public static final int T_EOS = 242;
        public static final int T_GO = 243;
        public static final int T_AND = 244;
        public static final int T_PERCENT = 245;
        public static final int T_PRINT = 246;
        public static final int T_ALLOCATE_STMT_1 = 247;
        public static final int T_SUBROUTINE = 248;
        public static final int T_CONTROL_EDIT_DESC = 249;
        public static final int T_ENUMERATOR = 250;
        public static final int Alphanumeric_Character = 251;
        public static final int T_DEFINED_OP = 252;
        public static final int T_KIND = 253;
        public static final int T_STOP = 254;
        public static final int T_GREATERTHAN_EQ = 255;
        public static final int T_CHAR_STRING_EDIT_DESC = 256;
        public static final int T_ALLOCATABLE = 257;
        public static final int T_ENDINTERFACE = 258;
        public static final int T_END = 259;
        public static final int T_ASTERISK = 260;
        public static final int T_PRIVATE = 261;
        public static final int T_DOUBLEPRECISION = 262;
        public static final int T_CASE = 263;
        public static final int T_IMPLICIT = 264;
        public static final int T_IF = 265;
        public static final int T_THEN = 266;
        public static final int T_DIMENSION = 267;
        public static final int T_GOTO = 268;
        public static final int T_ENDMODULE = 269;
        public static final int T_IN = 270;
        public static final int T_WRITE = 271;
        public static final int T_FORMATTED = 272;
        public static final int WS = 273;
        public static final int T_DATA = 274;
        public static final int T_FALSE = 275;
        public static final int T_WHERE = 276;
        public static final int T_ENDIF = 277;
        public static final int T_SLASH = 278;
        public static final int SQ_Rep_Char = 279;
        public static final int T_GENERIC = 280;
        public static final int T_RECURSIVE = 281;
        public static final int DQ_Rep_Char = 282;
        public static final int T_ELSEIF = 283;
        public static final int T_BLOCKDATA = 284;
        public static final int OCTAL_CONSTANT = 285;
        public static final int T_SELECTTYPE = 286;
        public static final int T_MINUS = 287;
        public static final int T_SELECT = 288;
        public static final int T_FINAL = 289;
        public static final int T_UNDERSCORE = 290;
        public static final int T_IMPORT = 291;
        public static final int T_USE = 292;
        public static final int T_FILE = 293;
        public static final int T_RPAREN = 294;
        public static final int T_INTENT = 295;
        public static final int T_ENDBLOCK = 296;
        public static final int T_ASSIGNMENT_STMT = 297;
        public static final int T_PAUSE = 298;
        public static final int T_BACKSPACE = 299;
        public static final int T_ENDFILE = 300;
        public static final int T_EQUALS = 301;
        public static final int T_NON_INTRINSIC = 302;
        public static final int T_SELECTCASE = 303;
        public static final int T_DIGIT_STRING = 304;
        public static final int T_COLON_COLON = 305;
        public static final int T_NON_OVERRIDABLE = 306;
        public static final int Special_Character = 307;
        public static final int T_INCLUDE = 308;
        public static final int T_OPEN = 309;
        public static final int T_POWER = 310;
        public static final int T_ASSOCIATE = 311;
        public static final int T_CHAR_CONSTANT = 312;
        public static final int T_OPERATOR = 313;
        public static final int T_TO = 314;
        public static final int T_ENDASSOCIATE = 315;
        public static final int T_EQ = 316;
        public static final int T_GREATERTHAN = 317;
        public static final int T_DATA_EDIT_DESC = 318;
        public static final int T_INQUIRE_STMT_2 = 319;
        public static final int T_EQV = 320;
        public static final int HEX_CONSTANT = 321;
        public static final int Digit_String = 322;
        public static final int T_ELEMENTAL = 323;
        public static final int T_CHARACTER = 324;
        public static final int PREPROCESS_LINE = 325;
        public static final int T_NULLIFY = 326;
        public static final int T_REWIND = 327;
        public static final int T_ARITHMETIC_IF_STMT = 328;
        public static final int T_FORALL_CONSTRUCT_STMT = 329;
        public static final int T_BIND = 330;
        public static final int T_ENDFORALL = 331;
        public static final int T_DO = 332;
        public static final int T_WHERE_STMT = 333;
        public static final int T_POINTER = 334;
        public static final int T_PROGRAM = 335;
        public static final int T_ENDTYPE = 336;
        public static final int T_WAIT = 337;
        public static final int T_ELSE = 338;
        public static final int T_IF_STMT = 339;
        public static final int T_RBRACKET = 340;
        public static final int T_LPAREN = 341;
        public static final int T_EXTENDS = 342;
        public static final int T_OPTIONAL = 343;
        public static final int T_DOUBLE = 344;
        public static final int T_MODULE = 345;
        public static final int T_READ = 346;
        public static final int T_ALLOCATE = 347;
        public static final int T_INTEGER = 348;
        public static final int T_OR = 349;
        public static final int T_EQUIVALENCE = 350;
        public static final int T_PERIOD = 351;
        public static final int T_ENTRY = 352;
        public static final int T_LABEL_DO_TERMINAL = 353;
        public static final int T_REAL = 354;
        public static final int T_CYCLE = 355;
        public static final int T_PROCEDURE = 356;
        public static final int T_EQ_EQ = 357;
        public static final int T_SLASH_EQ = 358;
        public static final int T_ENDSELECT = 359;
        public static final int T_PURE = 360;
        public static final int T_TRUE = 361;
        public static final int T_NE = 362;
        public static final int T_INTRINSIC = 363;
        public static final int T_PASS = 364;
        public static final int T_REAL_CONSTANT = 365;
        public static final int LINE_COMMENT = 366;
        public static final int T_PERIOD_EXPONENT = 367;
        public static final int T_ENDWHERE = 368;
        public static final int MISC_CHAR = 369;
        public static final int T_FORMAT = 370;
        public static final int T_DEFAULT = 371;
        public static final int T_SLASH_SLASH = 372;
        public static final int T_NONE = 373;
        public static final int T_NAMELIST = 374;
        public static final int T_SEQUENCE = 375;
        public static final int T_PRECISION = 376;
        public static final int T_ASYNCHRONOUS = 377;
        public static final int T_COMMA = 378;
        public static final int T_RESULT = 379;
        public static final int T_ENDBLOCKDATA = 380;
        public static final int T_LOGICAL = 381;
        public static final int T_VALUE = 382;
        public static final int Letter = 383;
        public static final int T_FORALL = 384;
        public static final int T_SAVE = 385;
        public static final int T_HOLLERITH = 386;
        public static final int T_FLUSH = 387;
        public static final int T_WHILE = 388;
        public static final int T_INQUIRE = 389;
        public static final int T_DEFERRED = 390;
        public static final int T_FORALL_STMT = 391;
        public static final int T_ASSIGN = 392;
        public static final int T_LBRACKET = 393;
        public static final int T_EXTERNAL = 394;
        public static final int T_VOLATILE = 395;
        public static final int T_OUT = 396;
        public static final int CONTINUE_CHAR = 397;
        public static final int T_COLON = 398;
        public static final int T_COMPLEX = 399;
        public static final int T_PLUS = 400;
        public static final int T_STMT_FUNCTION = 401;
        public static final int T_ONLY = 402;
        public static final int T_PROTECTED = 403;
        public static final int T_COMMON = 404;
        public static final int T_INOUT = 405;
        public static final int T_NEQV = 406;
        public static final int T_PUBLIC = 407;
        public static final int T_ENDDO = 408;
        public static final int T_ENDPROGRAM = 409;
        public static final int T_ENDFUNCTION = 410;
        public static final int T_WHERE_CONSTRUCT_STMT = 411;
        public static final int T_ELSEWHERE = 412;
        public static final int T_ENUM = 413;
        public static final int T_PARAMETER = 414;
        public static final int T_TARGET = 415;
        public static final int T_DOUBLECOMPLEX = 416;
        public static final int T_PTR_ASSIGNMENT_STMT = 417;
        public static final int T_TYPE = 418;
        public static final int T_LESSTHAN_EQ = 419;
        public static final int T_DEALLOCATE = 420;
        public static final int T_LT = 421;
        public static final int T_FUNCTION = 422;
        public static final int T_EQ_GT = 423;
        public static final int T_ENDENUM = 424;
        public static final int BINARY_CONSTANT = 425;
        public static final int T_LE = 426;
        public static final int T_LEN = 427;
        public static final int T_CONTINUE = 428;
        public static final int T_NOT = 429;
        public static final int Rep_Char = 430;
        public static final int T_ASSIGNMENT = 431;
        public static final int T_EXIT = 432;
        public static final int FORTRAN_COMMENT = 433;
        public static final int FIRST_ASSIGN = 434;
        public static final int FIRST_DIVIDE = 435;
        public static final int FIRST_STAR = 436;
        public static final int FIRST_MOD = 437;
        public static final int FIRST_NOT = 438;
        public static final int FIRST_AMPERSAND = 439;
        public static final int COMMENT = 440;
        public static final int CPP_COMMENT = 441;
        public static final int FIRST_OR = 442;
        public static final int FIRST_BITWISEXOR = 443;
        public static final int FIRST_COLON = 444;
        public static final int FIRST_LESS = 445;
        public static final int FIRST_GREATER = 446;
        public static final int FIRST_MINUS = 447;
        public static final int FIRST_PLUS = 448;
        public static final int FIRST_QUOTATION = 449;
        public static final int H_char_sequence = 450;
        public static final int Q_char_sequence = 451;
        public static final int DirectiveBody = 452;
        public static final int CHAR_LITERAL_BODY = 453;
        public static final int STRING_LITERAL_BODY = 454;
        public static final int ID_LIKE = 455;
        public static final int ID_DEFINED = 456;
        public static final int Identifier = 457;
        public static final int PostPPKwdChar = 458;
        public static final int PostInclChar = 459;
        public static final int PostIfChar = 460;
        public static final int LAST_LEXER_FAKE_RULE = 461;

        private FortranLexer() {
        }

        public static boolean isKeyword(Token tmpToken) {
            return FortranLexer.isKeyword(tmpToken.getType());
        }

        public static boolean isKeyword(int tokenType) {
            switch (tokenType) {
                case 225: 
                case 226: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 234: 
                case 237: 
                case 238: 
                case 241: 
                case 243: 
                case 246: 
                case 248: 
                case 250: 
                case 253: 
                case 254: 
                case 257: 
                case 258: 
                case 259: 
                case 261: 
                case 262: 
                case 263: 
                case 264: 
                case 265: 
                case 266: 
                case 267: 
                case 268: 
                case 269: 
                case 270: 
                case 271: 
                case 272: 
                case 274: 
                case 276: 
                case 277: 
                case 280: 
                case 281: 
                case 283: 
                case 284: 
                case 286: 
                case 288: 
                case 289: 
                case 291: 
                case 292: 
                case 293: 
                case 295: 
                case 296: 
                case 298: 
                case 299: 
                case 300: 
                case 302: 
                case 303: 
                case 306: 
                case 309: 
                case 311: 
                case 313: 
                case 314: 
                case 315: 
                case 323: 
                case 324: 
                case 326: 
                case 327: 
                case 331: 
                case 332: 
                case 334: 
                case 335: 
                case 336: 
                case 337: 
                case 338: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 347: 
                case 348: 
                case 350: 
                case 352: 
                case 354: 
                case 355: 
                case 356: 
                case 359: 
                case 360: 
                case 363: 
                case 364: 
                case 368: 
                case 370: 
                case 371: 
                case 373: 
                case 374: 
                case 375: 
                case 376: 
                case 377: 
                case 379: 
                case 380: 
                case 381: 
                case 382: 
                case 384: 
                case 385: 
                case 387: 
                case 388: 
                case 389: 
                case 390: 
                case 392: 
                case 394: 
                case 395: 
                case 396: 
                case 399: 
                case 402: 
                case 403: 
                case 404: 
                case 405: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 412: 
                case 413: 
                case 414: 
                case 415: 
                case 416: 
                case 418: 
                case 420: 
                case 422: 
                case 424: 
                case 427: 
                case 428: 
                case 431: 
                case 432: {
                    return true;
                }
            }
            return false;
        }
    }
}

