/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTElif;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTIf;
import org.netbeans.modules.cnd.apt.structure.APTIfdef;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTSelfWalker;
import org.netbeans.modules.cnd.spi.model.services.CsmReferenceStorage;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileSystem;

public final class APTFindMacrosWalker
extends APTSelfWalker {
    private final List<CsmReference> references = new ArrayList<CsmReference>();
    private final CsmFile csmFile;

    public APTFindMacrosWalker(APTFile apt, CsmFile csmFile, APTPreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
        super(apt, preprocHandler, cacheEntry);
        this.csmFile = csmFile;
    }

    protected void onDefine(APT apt) {
        APTMacro m;
        APTDefine defineNode = (APTDefine)apt;
        int index = this.references.size();
        this.analyzeList(defineNode.getBody());
        super.onDefine(apt);
        APTToken name = defineNode.getName();
        if (name != null && (m = this.getMacroMap().getMacro(name)) != null) {
            MacroReference mr = new MacroReference(this.csmFile, name, m, CsmReferenceKind.DECLARATION);
            if (this.references.size() == index) {
                this.references.add(mr);
            } else {
                this.references.add(index, mr);
            }
        }
    }

    protected boolean onIf(APT apt) {
        this.analyzeStream(((APTIf)apt).getCondition(), false);
        return super.onIf(apt);
    }

    protected boolean onElif(APT apt, boolean wasInPrevBranch) {
        this.analyzeStream(((APTElif)apt).getCondition(), false);
        return super.onElif(apt, wasInPrevBranch);
    }

    protected boolean onIfndef(APT apt) {
        this.analyzeToken(((APTIfndef)apt).getMacroName(), false);
        return super.onIfndef(apt);
    }

    protected boolean onIfdef(APT apt) {
        this.analyzeToken(((APTIfdef)apt).getMacroName(), false);
        return super.onIfdef(apt);
    }

    protected void onUndef(APT apt) {
        this.analyzeToken(((APTUndefine)apt).getName(), false);
        super.onUndef(apt);
    }

    protected void onInclude(APT apt) {
        this.analyzeStream(((APTInclude)apt).getInclude(), true);
        super.onInclude(apt);
    }

    protected void onIncludeNext(APT apt) {
        this.analyzeStream(((APTIncludeNext)apt).getInclude(), true);
        super.onIncludeNext(apt);
    }

    public List<CsmReference> collectMacros() {
        TokenStream ts = super.getTokenStream();
        this.analyzeStream(ts, true);
        return this.references;
    }

    private CsmReference analyzeToken(APTToken token, boolean addOnlyIfNotFunLikeMacro) {
        APTMacro m;
        OffsetableBase mf = null;
        boolean funLike = false;
        if (token != null && !APTUtils.isEOF((Token)token) && (m = this.getMacroMap().getMacro(token)) != null) {
            funLike = m.isFunctionLike();
            switch (m.getKind()) {
                case DEFINED: {
                    mf = new MacroReference(this.csmFile, token, m, CsmReferenceKind.DIRECT_USAGE);
                    break;
                }
                default: {
                    mf = new SysMacroReference(this.csmFile, token, m);
                }
            }
        }
        if (!(mf == null || funLike && addOnlyIfNotFunLikeMacro)) {
            this.references.add((CsmReference)mf);
            mf = null;
        }
        return mf;
    }

    private void analyzeList(List<APTToken> tokens) {
        if (tokens != null) {
            for (APTToken token : tokens) {
                this.analyzeToken(token, false);
            }
        }
    }

    private void analyzeStream(TokenStream ts, boolean checkFunLikeMacro) {
        if (ts != null) {
            try {
                APTToken token = (APTToken)ts.nextToken();
                while (!APTUtils.isEOF((Token)token)) {
                    CsmReference mr = this.analyzeToken(token, checkFunLikeMacro);
                    token = (APTToken)ts.nextToken();
                    if (mr == null) continue;
                    assert (checkFunLikeMacro);
                    if (token.getType() != 12) continue;
                    this.references.add(mr);
                }
            }
            catch (TokenStreamException ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
    }

    private static final class MacroReference
    extends OffsetableBase
    implements CsmReference {
        private volatile CsmMacro ref = null;
        private final CharSequence macroName;
        private final APTMacro macro;
        private final CsmReferenceKind kind;

        public MacroReference(CsmFile macroUsageFile, APTToken macroUsageToken, APTMacro macro, CsmReferenceKind kind) {
            super(macroUsageFile, macroUsageToken.getOffset(), macroUsageToken.getEndOffset());
            this.macroName = macroUsageToken.getTextID();
            assert (this.macroName != null);
            this.macro = macro;
            this.kind = kind;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CsmObject getReferencedObject() {
            CsmReference candidate;
            CsmMacro refObj = this.ref;
            if (refObj == null && (candidate = CsmReferenceStorage.getDefault().get((CsmOffsetable)this)) != null) {
                CsmObject referencedObject = candidate.getReferencedObject();
                if (referencedObject instanceof CsmMacro) {
                    refObj = (CsmMacro)referencedObject;
                } else if (referencedObject != null) {
                    Logger.getLogger("xRef").log(Level.INFO, "Reference storage returns {0} where is expected macro\n", referencedObject);
                }
            }
            if (refObj == null && this.macro != null) {
                MacroReference macroReference = this;
                synchronized (macroReference) {
                    refObj = this.ref;
                    if (refObj == null) {
                        int macroStartOffset = this.macro.getDefineNode().getOffset();
                        CsmFile target = this.getTargetFile();
                        if (target != null) {
                            CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(this.macroName, true, true, false);
                            Iterator it = CsmSelect.getMacros((CsmFile)target, (CsmSelect.CsmFilter)filter);
                            while (it.hasNext()) {
                                CsmMacro targetFileMacro = (CsmMacro)it.next();
                                if (targetFileMacro == null || macroStartOffset != targetFileMacro.getStartOffset()) continue;
                                refObj = targetFileMacro;
                                break;
                            }
                            if (refObj == null) {
                                if (target instanceof Unresolved.UnresolvedFile) {
                                    refObj = MacroImpl.createSystemMacro(this.macroName, "", target, CsmMacro.Kind.USER_SPECIFIED);
                                } else {
                                    refObj = MacroImpl.create(this.macroName, null, "", target, macroStartOffset, macroStartOffset + this.macroName.length(), CsmMacro.Kind.DEFINED);
                                    Utils.setSelfUID((CsmObject)refObj);
                                }
                            }
                        }
                        this.ref = refObj;
                    }
                }
            }
            return refObj;
        }

        private CsmFile getTargetFile() {
            CsmFile target;
            CsmFile current = this.getContainingFile();
            if (this.kind == CsmReferenceKind.DECLARATION) {
                target = current;
            } else {
                target = null;
                CharSequence macroContainerFile = this.macro.getFile();
                if (current != null && macroContainerFile.length() > 0) {
                    FileSystem fs = null;
                    ProjectBase currentPrj = (ProjectBase)current.getProject();
                    ProjectBase targetPrj = currentPrj.findFileProject(macroContainerFile, true);
                    if (targetPrj != null) {
                        target = targetPrj.findFile(macroContainerFile, true, false);
                        fs = targetPrj.getFileSystem();
                    } else {
                        fs = currentPrj.getFileSystem();
                    }
                    if (target == null) {
                        target = CsmModelAccessor.getModel().findFile(new FSPath(fs, ((Object)macroContainerFile).toString()), true, false);
                    }
                    if (target == null && targetPrj != null) {
                        target = targetPrj.getUnresolvedFile();
                    }
                    if (target == null) {
                        target = currentPrj.getUnresolvedFile();
                    }
                }
            }
            return target;
        }

        public CsmObject getOwner() {
            return this.kind == CsmReferenceKind.DECLARATION ? this.getContainingFile() : this.getReferencedObject();
        }

        public CsmReferenceKind getKind() {
            return this.kind;
        }

        @Override
        public CharSequence getText() {
            return this.macroName;
        }

        public CsmObject getClosestTopLevelObject() {
            return this.kind == CsmReferenceKind.DECLARATION ? this.getContainingFile() : this.getReferencedObject();
        }
    }

    private static final class SysMacroReference
    extends OffsetableBase
    implements CsmReference {
        private final CsmObject ref;
        private final CharSequence text;

        public SysMacroReference(CsmFile file, APTToken token, APTMacro macro) {
            super(file, token.getOffset(), token.getEndOffset());
            CsmMacro.Kind kind;
            this.text = token.getTextID();
            switch (macro.getKind()) {
                case COMPILER_PREDEFINED: {
                    kind = CsmMacro.Kind.COMPILER_PREDEFINED;
                    break;
                }
                case POSITION_PREDEFINED: {
                    kind = CsmMacro.Kind.POSITION_PREDEFINED;
                    break;
                }
                case DEFINED: {
                    kind = CsmMacro.Kind.DEFINED;
                    break;
                }
                case USER_SPECIFIED: {
                    kind = CsmMacro.Kind.USER_SPECIFIED;
                    break;
                }
                default: {
                    System.err.println("unexpected kind in macro " + macro);
                    kind = CsmMacro.Kind.USER_SPECIFIED;
                }
            }
            this.ref = MacroImpl.createSystemMacro(token.getTextID(), APTUtils.stringize((TokenStream)macro.getBody(), (boolean)false), ((ProjectBase)file.getProject()).getUnresolvedFile(), kind);
        }

        public CsmObject getReferencedObject() {
            return this.ref;
        }

        public CsmObject getOwner() {
            return this.getContainingFile();
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.DIRECT_USAGE;
        }

        @Override
        public CharSequence getText() {
            return this.text;
        }

        public CsmObject getClosestTopLevelObject() {
            return this.getContainingFile();
        }
    }
}

