/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTSelfWalker;

public class APTFindUnusedBlocksWalker
extends APTSelfWalker {
    private final List<CsmOffsetable> blocks = new ArrayList<CsmOffsetable>();
    private final CsmFile csmFile;

    public List<CsmOffsetable> getBlocks() {
        return this.blocks;
    }

    protected void addBlock(int startOffset, int endOffset) {
        this.blocks.add(Utils.createOffsetable(this.csmFile, startOffset, endOffset));
    }

    public APTFindUnusedBlocksWalker(APTFile apt, CsmFile csmFile, APTPreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
        super(apt, preprocHandler, cacheEntry);
        this.csmFile = csmFile;
    }

    protected boolean onIfdef(APT apt) {
        boolean val = super.onIfdef(apt);
        this.handleIf(apt, val);
        return val;
    }

    protected boolean onIfndef(APT apt) {
        boolean val = super.onIfndef(apt);
        this.handleIf(apt, val);
        return val;
    }

    protected boolean onIf(APT apt) {
        boolean val = super.onIf(apt);
        this.handleIf(apt, val);
        return val;
    }

    protected boolean onElif(APT apt, boolean wasInPrevBranch) {
        boolean val = super.onElif(apt, wasInPrevBranch);
        this.handleIf(apt, val);
        return val;
    }

    protected boolean onElse(APT apt, boolean wasInPrevBranch) {
        boolean val = super.onElse(apt, wasInPrevBranch);
        this.handleIf(apt, val);
        return val;
    }

    protected void onErrorNode(APT apt) {
        int endOffset;
        super.onErrorNode(apt);
        int startOffset = apt.getEndOffset();
        try {
            endOffset = ((FileImpl)this.csmFile).getBuffer().getCharBuffer().length;
        }
        catch (IOException ex) {
            endOffset = 0;
        }
        this.addBlock(startOffset, endOffset);
    }

    protected void onPragmaNode(APT apt) {
        super.onPragmaNode(apt);
        if (this.isStopped()) {
            int endOffset;
            int startOffset = apt.getEndOffset();
            try {
                endOffset = ((FileImpl)this.csmFile).getBuffer().getCharBuffer().length;
            }
            catch (IOException ex) {
                endOffset = 0;
            }
            this.addBlock(startOffset, endOffset);
        }
    }

    private void handleIf(APT opener, boolean value) {
        APT closer = opener.getNextSibling();
        if (closer != null && !value) {
            this.addBlock(opener.getEndOffset(), closer.getOffset() - 1);
        }
    }
}

