/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.io.IOException;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class FileBufferDoc
extends AbstractFileBuffer {
    private static final boolean TRACE = false;
    private final Document doc;
    private final EventListenerList listeners = new EventListenerList();
    private DocumentListener docListener;
    private TokenHierarchyListener tokensListener;
    private long lastModified;
    private final ChangedSegment changedSegment;
    private ChangedSegment lastChangedSegment;
    private long changedSegmentTaken;
    private volatile boolean preprocessorBlockChanged = false;

    public FileBufferDoc(FileObject fileObject, Document doc) {
        super(fileObject);
        this.doc = doc;
        this.changedSegment = new ChangedSegment(doc);
        this.resetLastModified();
    }

    private boolean resetLastModified() {
        long documentTimestamp = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)this.doc);
        if (documentTimestamp != this.lastModified) {
            this.lastModified = documentTimestamp;
            this.clearLineCache();
            return true;
        }
        return false;
    }

    private void fireDocumentChanged() {
        if (this.resetLastModified()) {
            EventListener[] list = this.listeners.getListeners(ChangeListener.class);
            if (list.length > 0) {
                ChangeEvent ev = new ChangeEvent(this);
                for (int i = 0; i < list.length; ++i) {
                    ((ChangeListener)list[i]).stateChanged(ev);
                }
            }
            APTDriver.invalidateAPT((APTFileBuffer)this);
            APTFileCacheManager.getInstance((FileSystem)this.getFileSystem()).invalidate(this.getAbsolutePath());
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.listeners.getListenerCount() == 0) {
            this.docListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FileBufferDoc.this.changedSegment.addSegment(e.getOffset(), e.getLength());
                    FileBufferDoc.this.fireDocumentChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FileBufferDoc.this.changedSegment.removeSegment(e.getOffset(), e.getLength());
                    FileBufferDoc.this.fireDocumentChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            this.doc.addDocumentListener(this.docListener);
            final TokenHierarchy th = TokenHierarchy.get((Document)this.doc);
            if (th != null) {
                this.tokensListener = new TokenHierarchyListener(){

                    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
                        FileBufferDoc.this.preprocessorBlockChanged = (byte)(FileBufferDoc.this.preprocessorBlockChanged | (FileBufferDoc.checkTokensEvent(evt) ? 1 : 0));
                        if (FileBufferDoc.this.preprocessorBlockChanged) {
                            th.removeTokenHierarchyListener((TokenHierarchyListener)this);
                        }
                    }
                };
                th.addTokenHierarchyListener(this.tokensListener);
            }
        }
        this.listeners.add(ChangeListener.class, listener);
    }

    private static boolean checkTokensEvent(TokenHierarchyEvent evt) {
        int startIndex;
        TokenChange tokenChange = evt.tokenChange();
        if (tokenChange == null) {
            return false;
        }
        TokenSequence removedTokenSequence = tokenChange.removedTokenSequence();
        if (removedTokenSequence != null && !removedTokenSequence.isEmpty()) {
            while (removedTokenSequence.moveNext()) {
                Token curToken = removedTokenSequence.token();
                if (CppTokenId.PREPROCESSOR_DIRECTIVE != curToken.id()) continue;
                return true;
            }
        }
        if ((startIndex = tokenChange.index()) >= 0) {
            TokenSequence currentTokenSequence = tokenChange.currentTokenSequence();
            currentTokenSequence.moveIndex(startIndex++);
            if (currentTokenSequence.moveNext()) {
                Token curToken = currentTokenSequence.token();
                if (tokenChange.isBoundsChange()) {
                    if (CppTokenId.PREPROCESSOR_DIRECTIVE == curToken.id()) {
                        return true;
                    }
                } else {
                    int addedTokenCount = tokenChange.addedTokenCount();
                    while (addedTokenCount-- > 0) {
                        currentTokenSequence.moveIndex(startIndex++);
                        if (!currentTokenSequence.moveNext() || CppTokenId.PREPROCESSOR_DIRECTIVE != (curToken = currentTokenSequence.token()).id()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
        if (this.listeners.getListenerCount() == 0) {
            this.doc.removeDocumentListener(this.docListener);
            this.docListener = null;
            TokenHierarchy th = TokenHierarchy.get((Document)this.doc);
            if (th != null && this.tokensListener != null) {
                th.removeTokenHierarchyListener(this.tokensListener);
            }
            this.tokensListener = null;
        }
    }

    private IOException convert(BadLocationException e) {
        IOException ioe = new IOException(e.getMessage());
        ioe.setStackTrace(e.getStackTrace());
        return ioe;
    }

    @Override
    public CharSequence getText() throws IOException {
        final String[] out = new String[]{null};
        final BadLocationException[] exc = new BadLocationException[]{null};
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    out[0] = FileBufferDoc.this.doc.getText(0, FileBufferDoc.this.doc.getLength());
                }
                catch (BadLocationException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw this.convert(exc[0]);
        }
        return out[0];
    }

    @Override
    public String getText(int start, int end) throws IOException {
        try {
            return this.doc.getText(start, end - start);
        }
        catch (BadLocationException e) {
            throw this.convert(e);
        }
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    public ChangedSegment getLastChangedSegment() {
        return this.lastChangedSegment;
    }

    public char[] getCharBuffer() throws IOException {
        final Object[] res = new Object[]{null, null};
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    int length = FileBufferDoc.this.doc.getLength();
                    char[] buf = new char[length];
                    DocumentUtilities.copyText((Document)FileBufferDoc.this.doc, (int)0, (int)length, (char[])buf, (int)0);
                    res[0] = buf;
                }
                catch (BadLocationException e) {
                    res[1] = e;
                }
            }
        });
        if (res[1] != null) {
            throw this.convert((BadLocationException)res[1]);
        }
        return (char[])res[0];
    }

    public static final class ChangedSegment {
        private int begUnchangedEnd;
        private int endUnchangedStart = -1;
        private int endUnchangedEnd = -1;

        public int[] begUnchanged() {
            return new int[]{0, this.begUnchangedEnd};
        }

        public int[] endUnchanged() {
            return new int[]{this.endUnchangedStart, this.endUnchangedEnd};
        }

        private ChangedSegment(ChangedSegment parent) {
            this.begUnchangedEnd = parent.begUnchangedEnd;
            this.endUnchangedStart = parent.endUnchangedStart;
            this.endUnchangedEnd = parent.endUnchangedEnd;
        }

        private ChangedSegment(Document doc) {
            this.begUnchangedEnd = doc.getLength();
        }

        private void reset(Document doc) {
            this.begUnchangedEnd = doc.getLength();
            this.endUnchangedStart = -1;
            this.endUnchangedEnd = -1;
        }

        private void addSegment(int start, int length) {
            if (this.endUnchangedStart == -1) {
                this.endUnchangedStart = start + length;
                this.endUnchangedEnd = this.begUnchangedEnd + length;
                this.begUnchangedEnd = start;
            } else if (this.begUnchangedEnd <= start) {
                if (this.endUnchangedStart >= start) {
                    this.endUnchangedStart += length;
                    this.endUnchangedEnd += length;
                } else {
                    this.endUnchangedStart = start + length;
                    this.endUnchangedEnd += length;
                }
            } else {
                this.begUnchangedEnd = start;
                this.endUnchangedStart += length;
                this.endUnchangedEnd += length;
            }
        }

        private void removeSegment(int start, int length) {
            if (this.endUnchangedStart == -1) {
                this.endUnchangedStart = start;
                this.endUnchangedEnd = this.begUnchangedEnd - length;
                this.begUnchangedEnd = start;
            } else if (this.begUnchangedEnd <= start) {
                if (this.endUnchangedStart >= start) {
                    this.endUnchangedStart -= length;
                    if (this.endUnchangedStart < start) {
                        this.endUnchangedStart = start;
                    }
                    this.endUnchangedEnd -= length;
                } else {
                    this.endUnchangedStart = start + length;
                    this.endUnchangedEnd -= length;
                }
            } else {
                this.begUnchangedEnd = start;
                this.endUnchangedStart -= length;
                if (this.endUnchangedStart < start) {
                    this.endUnchangedStart = start;
                }
                this.endUnchangedEnd -= length;
            }
        }

        public String toString() {
            if (this.endUnchangedStart == -1) {
                return "No changes";
            }
            return "Start unchanged=[0," + this.begUnchangedEnd + ") End unhanged=[" + this.endUnchangedStart + "," + this.endUnchangedEnd + ")";
        }
    }
}

