/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netbinox;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.netbeans.modules.netbinox.NetbinoxFactory;

final class NetbinoxLoader
extends DefaultClassLoader {
    public NetbinoxLoader(ClassLoader parent, ClassLoaderDelegate delegate, ProtectionDomain domain, BaseData bd, String[] classpath) {
        super(parent, delegate, domain, bd, classpath);
        this.manager = new NoTouchCPM(bd, classpath, this);
    }

    public String toString() {
        return "NetbinoxLoader delegating to " + this.delegate;
    }

    private static class NoTouchCPM
    extends ClasspathManager {
        public NoTouchCPM(BaseData data, String[] classpath, BaseClassLoader classloader) {
            super(data, classpath, classloader);
        }

        @Override
        public ClasspathEntry getClasspath(String cp, BaseData sourcedata, ProtectionDomain sourcedomain) {
            BundleFile bundlefile = null;
            BundleEntry cpEntry = sourcedata.getBundleFile().getEntry(cp);
            if (cpEntry != null && cpEntry.getName().endsWith("/")) {
                bundlefile = NoTouchCPM.createBundleFile(cp, sourcedata);
            } else {
                File file = sourcedata.getBundleFile().getFile(cp, false);
                if (file != null) {
                    bundlefile = NoTouchCPM.createBundleFile(file, sourcedata);
                }
            }
            if (bundlefile != null) {
                return this.createClassPathEntry(bundlefile, sourcedomain, sourcedata);
            }
            return null;
        }

        @Override
        public ClasspathEntry getExternalClassPath(String cp, BaseData sourcedata, ProtectionDomain sourcedomain) {
            File file;
            if (cp.startsWith("file:")) {
                try {
                    file = new File(new URI(cp));
                }
                catch (URISyntaxException ex) {
                    NetbinoxFactory.LOG.log(Level.SEVERE, "Cannot convert to file: " + cp, ex);
                    return null;
                }
            } else {
                file = new File(cp);
            }
            if (!file.isAbsolute() && !cp.startsWith("file:")) {
                return null;
            }
            BundleFile bundlefile = NoTouchCPM.createBundleFile(file, sourcedata);
            if (bundlefile != null) {
                return this.createClassPathEntry(bundlefile, sourcedomain, sourcedata);
            }
            return null;
        }

        private static BundleFile createBundleFile(Object content, BaseData sourcedata) {
            try {
                return sourcedata.getAdaptor().createBundleFile(content, sourcedata);
            }
            catch (IOException e) {
                sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), e);
                return null;
            }
        }

        private ClasspathEntry createClassPathEntry(BundleFile bundlefile, ProtectionDomain cpDomain, final BaseData data) {
            return new ClasspathEntry(bundlefile, DefaultClassLoader.createProtectionDomain(bundlefile, cpDomain)){

                @Override
                public BaseData getBaseData() {
                    return data;
                }
            };
        }
    }
}

