/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.queriesimpl;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.queries.api.QueryException;
import org.netbeans.modules.java.source.queries.spi.ModelOperations;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class JavaOperationsImpl<T>
implements ModelOperations {
    private final CompilationController control;

    JavaOperationsImpl(@NonNull CompilationController control) {
        assert (control != null);
        this.control = control;
    }

    @NonNull
    public Collection<? extends String> getTopLevelClasses() throws QueryException {
        try {
            this.control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        }
        catch (IOException ioe) {
            throw new QueryException((Throwable)ioe);
        }
        List topLevels = this.control.getTopLevelElements();
        ArrayList<String> result = new ArrayList<String>(topLevels.size());
        for (Element topLevel : topLevels) {
            result.add(((TypeElement)topLevel).getQualifiedName().toString());
        }
        return result;
    }

    @CheckForNull
    public String getSuperClass(@NonNull String cls) throws QueryException {
        TypeElement te = this.findClass(cls);
        if (te == null) {
            return null;
        }
        TypeMirror superType = te.getSuperclass();
        if (superType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        return ((TypeElement)((DeclaredType)superType).asElement()).getQualifiedName().toString();
    }

    @NonNull
    public final Collection<? extends String> getInterfaces(@NonNull String cls) throws QueryException {
        TypeElement te = this.findClass(cls);
        if (te == null) {
            return null;
        }
        List<? extends TypeMirror> interfaceTypes = te.getInterfaces();
        ArrayList<String> result = new ArrayList<String>(interfaceTypes.size());
        for (TypeMirror typeMirror : interfaceTypes) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            result.add(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString());
        }
        return Collections.unmodifiableCollection(result);
    }

    @CheckForNull
    public String getClassBinaryName(@NonNull String cls) throws QueryException {
        TypeElement te = this.findClass(cls);
        return te == null ? null : ElementUtilities.getBinaryName((TypeElement)te);
    }

    @NonNull
    public Collection<? extends String> getFieldNames(@NonNull String clz, boolean rt, @NullAllowed String type) throws QueryException {
        TypeElement te = this.findClass(clz);
        if (te == null) {
            return Collections.emptyList();
        }
        Types types = this.control.getTypes();
        TypeMirror tm = null;
        if (type != null) {
            List topLevels = this.control.getTopLevelElements();
            TypeMirror typeMirror = tm = topLevels.isEmpty() ? null : this.control.getTreeUtilities().parseType(type, (TypeElement)topLevels.get(0));
            if (tm == null) {
                return Collections.emptyList();
            }
            if (rt) {
                tm = types.erasure(tm);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (VariableElement ve : ElementFilter.fieldsIn(te.getEnclosedElements())) {
            if (!JavaOperationsImpl.isSameType(types, tm, ve.asType(), rt)) continue;
            result.add(ve.getSimpleName().toString());
        }
        return Collections.unmodifiableCollection(result);
    }

    @NonNull
    public Collection<? extends String> getMethodNames(@NonNull String clz, boolean rt, @NullAllowed String returnType, String ... parameterTypes) throws QueryException {
        List<ExecutableElement> methods = this.getMethods(clz, null, rt, returnType, parameterTypes);
        ArrayList<String> result = new ArrayList<String>(methods.size());
        for (ExecutableElement method : methods) {
            result.add(method.getSimpleName().toString());
        }
        return Collections.unmodifiableCollection(result);
    }

    @CheckForNull
    public int[] getMethodSpan(@NonNull String clz, @NonNull String methodName, boolean rt, @NonNull String returnType, String ... parameterTypes) throws QueryException {
        List<ExecutableElement> methods = this.getMethods(clz, methodName, rt, returnType, parameterTypes);
        if (methods.isEmpty()) {
            return null;
        }
        ExecutableElement method = methods.get(0);
        Trees trees = this.control.getTrees();
        TreePath tp = trees.getPath(method);
        if (tp == null) {
            return null;
        }
        int start = -1;
        int end = -1;
        List cmts = this.control.getTreeUtilities().getComments(tp.getLeaf(), true);
        if (!cmts.isEmpty()) {
            start = ((Comment)cmts.iterator().next()).pos();
        }
        if (!(cmts = this.control.getTreeUtilities().getComments(tp.getLeaf(), false)).isEmpty()) {
            end = ((Comment)cmts.listIterator(cmts.size()).previous()).pos();
        }
        if (start == -1) {
            start = (int)trees.getSourcePositions().getStartPosition(tp.getCompilationUnit(), tp.getLeaf());
        }
        if (end == -1) {
            end = (int)trees.getSourcePositions().getEndPosition(tp.getCompilationUnit(), tp.getLeaf());
        }
        return new int[]{start, end};
    }

    public void modifyInterfaces(@NonNull String clz, @NonNull Collection<? extends String> toAdd, @NonNull Collection<? extends String> toRemove) throws QueryException {
        ClassTree mainClassTree;
        if (!(this.control instanceof WorkingCopy)) {
            throw new IllegalStateException();
        }
        WorkingCopy wcopy = (WorkingCopy)this.control;
        TreePath mainClassTreePath = this.findClassInCompilationUnit(clz);
        if (mainClassTreePath == null) {
            throw new IllegalArgumentException("No class: " + clz + " in source: " + FileUtil.getFileDisplayName((FileObject)this.control.getFileObject()));
        }
        Element mainClassElm = wcopy.getTrees().getElement(mainClassTreePath);
        assert (mainClassElm != null);
        ClassTree origMainTree = mainClassTree = (ClassTree)mainClassTreePath.getLeaf();
        if (mainClassElm != null) {
            HashSet<String> actualInterfaces = new HashSet<String>();
            TreeMaker maker = wcopy.getTreeMaker();
            List<? extends TypeMirror> interfaces = ((TypeElement)mainClassElm).getInterfaces();
            for (int infIndex = interfaces.size() - 1; infIndex >= 0; --infIndex) {
                TypeMirror typeMirror = interfaces.get(infIndex);
                TypeElement infElm = (TypeElement)wcopy.getTypes().asElement(typeMirror);
                actualInterfaces.add(infElm.getQualifiedName().toString());
                if (!toRemove.contains(infElm.getQualifiedName().toString())) continue;
                mainClassTree = maker.removeClassImplementsClause(mainClassTree, infIndex);
            }
            for (String string : toAdd) {
                if (actualInterfaces.contains(string)) continue;
                TypeElement inf2add = wcopy.getElements().getTypeElement(string);
                ExpressionTree infTree2add = inf2add != null ? maker.QualIdent((Element)inf2add) : maker.Identifier((CharSequence)string);
                mainClassTree = maker.addClassImplementsClause(mainClassTree, (Tree)infTree2add);
            }
            if (origMainTree != mainClassTree) {
                wcopy.rewrite((Tree)origMainTree, (Tree)mainClassTree);
            }
        }
    }

    public void setSuperClass(@NonNull String clz, @NonNull String superClz) throws QueryException {
        ClassTree mainClassTree;
        if (!(this.control instanceof WorkingCopy)) {
            throw new IllegalStateException();
        }
        WorkingCopy wcopy = (WorkingCopy)this.control;
        TreePath mainClassTreePath = this.findClassInCompilationUnit(clz);
        if (mainClassTreePath == null) {
            throw new IllegalArgumentException("No class: " + clz + " in source: " + FileUtil.getFileDisplayName((FileObject)this.control.getFileObject()));
        }
        Element mainClassElm = wcopy.getTrees().getElement(mainClassTreePath);
        assert (mainClassElm != null);
        ClassTree origMainTree = mainClassTree = (ClassTree)mainClassTreePath.getLeaf();
        if (mainClassElm != null) {
            TreeMaker maker = wcopy.getTreeMaker();
            ExpressionTree superClsTree = null;
            if (!Object.class.getName().equals(superClz)) {
                TypeElement inf2add = wcopy.getElements().getTypeElement(superClz);
                ExpressionTree expressionTree = superClsTree = inf2add != null ? maker.QualIdent((Element)inf2add) : maker.Identifier((CharSequence)superClz);
            }
            if (origMainTree != (mainClassTree = maker.setExtends(mainClassTree, superClsTree))) {
                wcopy.rewrite((Tree)origMainTree, (Tree)mainClassTree);
            }
        }
    }

    public void renameField(@NonNull String clz, @NonNull String oldName, final @NonNull String newName) throws QueryException {
        final WorkingCopy wcopy = (WorkingCopy)this.control;
        try {
            this.control.toPhase(JavaSource.Phase.RESOLVED);
        }
        catch (IOException ioe) {
            throw new QueryException((Throwable)ioe);
        }
        TypeElement te = this.findClass(clz);
        if (te == null) {
            throw new IllegalArgumentException("No class: " + clz + " in source: " + FileUtil.getFileDisplayName((FileObject)this.control.getFileObject()));
        }
        VariableElement field = null;
        for (VariableElement ve : ElementFilter.fieldsIn(te.getEnclosedElements())) {
            if (!oldName.contentEquals(ve.getSimpleName())) continue;
            field = ve;
            break;
        }
        if (field == null) {
            throw new IllegalArgumentException("No field: " + clz + "." + oldName + " in source: " + FileUtil.getFileDisplayName((FileObject)this.control.getFileObject()));
        }
        final Trees trees = wcopy.getTrees();
        final TreeMaker maker = wcopy.getTreeMaker();
        CompilationUnitTree cu = wcopy.getCompilationUnit();
        TreePath fieldPath = trees.getPath(field);
        if (fieldPath == null || !cu.equals(fieldPath.getCompilationUnit())) {
            throw new IllegalArgumentException("No field: " + clz + "." + oldName + " in source: " + FileUtil.getFileDisplayName((FileObject)this.control.getFileObject()));
        }
        VariableTree oldVarTree = (VariableTree)fieldPath.getLeaf();
        VariableTree newVarTree = wcopy.getTreeMaker().Variable(oldVarTree.getModifiers(), (CharSequence)newName, oldVarTree.getType(), oldVarTree.getInitializer());
        wcopy.rewrite((Tree)oldVarTree, (Tree)newVarTree);
        final VariableElement fieldF = field;
        TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                super.visitIdentifier(node, p);
                if (this.shouldRename()) {
                    wcopy.rewrite(this.getCurrentPath().getLeaf(), (Tree)maker.Identifier((CharSequence)newName));
                }
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void p) {
                super.visitMemberSelect(node, p);
                if (this.shouldRename()) {
                    wcopy.rewrite(this.getCurrentPath().getLeaf(), (Tree)maker.MemberSelect(node.getExpression(), (CharSequence)newName));
                }
                return null;
            }

            private boolean shouldRename() {
                Element e = trees.getElement(this.getCurrentPath());
                return fieldF.equals(e);
            }
        };
        scanner.scan(cu, null);
    }

    public void fixImports(final int[][] ranges) throws QueryException {
        if (!(this.control instanceof WorkingCopy)) {
            throw new IllegalStateException();
        }
        Arrays.sort(ranges, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o1[0] - o2[0];
            }
        });
        WorkingCopy wcopy = (WorkingCopy)this.control;
        try {
            this.control.toPhase(JavaSource.Phase.RESOLVED);
        }
        catch (IOException ioe) {
            throw new QueryException((Throwable)ioe);
        }
        final CompilationUnitTree cu = wcopy.getCompilationUnit();
        final Trees trees = wcopy.getTrees();
        GeneratorUtilities utils = GeneratorUtilities.get((WorkingCopy)wcopy);
        final ArrayList toImport = new ArrayList();
        TreePathScanner<Void, Void> scanner = new TreePathScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void p) {
                int start = (int)trees.getSourcePositions().getStartPosition(cu, node);
                int end = (int)trees.getSourcePositions().getEndPosition(cu, node);
                int status = JavaOperationsImpl.contains(ranges, start, end);
                switch (status) {
                    case -1: {
                        super.scan(node, p);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        toImport.add(node);
                    }
                }
                return null;
            }
        };
        scanner.scan(cu, null);
        for (Tree tree : toImport) {
            wcopy.rewrite(tree, utils.importFQNs(tree));
        }
    }

    private List<? extends ExecutableElement> getMethods(@NonNull String clz, @NullAllowed String methodName, boolean rt, @NullAllowed String returnType, String ... parameterTypes) throws QueryException {
        TypeElement te = this.findClass(clz);
        if (te == null) {
            return Collections.emptyList();
        }
        TreeUtilities treeUtils = this.control.getTreeUtilities();
        Types types = this.control.getTypes();
        List topLevels = this.control.getTopLevelElements();
        if (topLevels.isEmpty()) {
            return Collections.emptyList();
        }
        TypeMirror rType = null;
        ArrayList<TypeMirror> pTypes = null;
        if (returnType != null) {
            rType = treeUtils.parseType(returnType, (TypeElement)topLevels.get(0));
            if (rType == null) {
                return Collections.emptyList();
            }
            if (rt) {
                rType = types.erasure(rType);
            }
        }
        if (parameterTypes != null) {
            pTypes = new ArrayList<TypeMirror>(parameterTypes.length + 1);
            for (String parameterType : parameterTypes) {
                TypeMirror tm = treeUtils.parseType(parameterType, (TypeElement)topLevels.get(0));
                if (tm == null) {
                    return Collections.emptyList();
                }
                if (rt) {
                    tm = types.erasure(tm);
                }
                pTypes.add(tm);
            }
        }
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        block1: for (ExecutableElement me : ElementFilter.methodsIn(te.getEnclosedElements())) {
            if (methodName != null && !methodName.contentEquals(me.getSimpleName())) continue;
            if (pTypes != null) {
                List<? extends VariableElement> params = me.getParameters();
                if (params.size() != pTypes.size()) continue;
                Iterator<? extends VariableElement> paramsIt = params.iterator();
                Iterator pTypesIt = pTypes.iterator();
                while (paramsIt.hasNext()) {
                    if (JavaOperationsImpl.isSameType(types, (TypeMirror)pTypesIt.next(), paramsIt.next().asType(), rt)) continue;
                    continue block1;
                }
            }
            if (!JavaOperationsImpl.isSameType(types, rType, me.getReturnType(), rt)) continue;
            result.add(me);
        }
        return result;
    }

    private TypeElement findClass(@NonNull String clz) throws QueryException {
        try {
            this.control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        }
        catch (IOException ioe) {
            throw new QueryException((Throwable)ioe);
        }
        return this.control.getElements().getTypeElement(clz);
    }

    private TreePath findClassInCompilationUnit(final @NonNull String clz) throws QueryException {
        try {
            this.control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        }
        catch (IOException ioe) {
            throw new QueryException((Throwable)ioe);
        }
        final Trees trees = this.control.getTrees();
        TreePathScanner<TreePath, Void> visitor = new TreePathScanner<TreePath, Void>(){

            @Override
            public TreePath visitClass(ClassTree node, Void p) {
                Element el = trees.getElement(this.getCurrentPath());
                if (el != null && (el.getKind().isClass() || el.getKind().isInterface()) && clz.contentEquals(((TypeElement)el).getQualifiedName())) {
                    return this.getCurrentPath();
                }
                return (TreePath)super.visitClass(node, p);
            }

            @Override
            public TreePath visitMethod(MethodTree node, Void p) {
                return null;
            }
        };
        return (TreePath)visitor.scan(this.control.getCompilationUnit(), null);
    }

    private static boolean isSameType(@NonNull Types types, @NullAllowed TypeMirror t1, @NonNull TypeMirror t2, boolean rawType) {
        return t1 == null || types.isSameType(t1, rawType ? types.erasure(t2) : t2);
    }

    private static int contains(@NonNull int[][] ranges, int start, int end) {
        for (int[] range : ranges) {
            if (start >= range[0] && end <= range[1]) {
                return 1;
            }
            if (start >= range[0] || end <= range[1]) continue;
            return -1;
        }
        return 0;
    }
}

