/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class QueryBasedValueHolder
extends DatabaseValueHolder {
    protected transient ReadQuery query;
    protected transient Object sourceObject;

    public QueryBasedValueHolder(ReadQuery query, AbstractRecord row, AbstractSession session) {
        this(query, null, row, session);
    }

    public QueryBasedValueHolder(ReadQuery query, Object sourceObject, AbstractRecord row, AbstractSession session) {
        this.row = row;
        this.session = session;
        if (!session.isUnitOfWork()) {
            this.session = session.getRootSession(query);
        }
        this.query = query;
        this.sourceObject = sourceObject;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.session);
    }

    protected Object instantiate(AbstractSession session) throws DatabaseException {
        if (session == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        return session.executeQuery((DatabaseQuery)this.getQuery(), this.getRow());
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    public void postInstantiate() {
        ClassDescriptor descriptor;
        if (this.query.getSourceMapping() != null && this.query.getSourceMapping().isForeignReferenceMapping() && (descriptor = this.session.getDescriptor(this.sourceObject)) != null) {
            this.session.getIdentityMapAccessorInstance().getIdentityMap(descriptor).lazyRelationshipLoaded(this.sourceObject, (ForeignReferenceMapping)this.query.getSourceMapping());
        }
    }

    public void releaseWrappedValueHolder(AbstractSession targetSession) {
        AbstractSession session = this.getSession();
        if (session != null && session.isUnitOfWork()) {
            this.setSession(targetSession);
        }
    }

    protected void resetFields() {
        super.resetFields();
        this.query = null;
    }

    protected void setQuery(ReadQuery theQuery) {
        this.query = theQuery;
    }

    public boolean isPessimisticLockingValueHolder() {
        if (this.query == null || !this.query.isObjectLevelReadQuery()) {
            return false;
        }
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.query;
        return query.isLockQuery(this.session);
    }
}

