/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataAsmFactory
extends MetadataFactory {
    public static final String PRIMITIVES = "VJIBZCSFD";
    public static final String TOKENS = "()<>;";

    public MetadataAsmFactory(MetadataLogger logger, ClassLoader loader) {
        super(logger, loader);
        this.addMetadataClass("I", new MetadataClass((MetadataFactory)this, Integer.TYPE));
        this.addMetadataClass("J", new MetadataClass((MetadataFactory)this, Long.TYPE));
        this.addMetadataClass("S", new MetadataClass((MetadataFactory)this, Short.TYPE));
        this.addMetadataClass("Z", new MetadataClass((MetadataFactory)this, Boolean.TYPE));
        this.addMetadataClass("F", new MetadataClass((MetadataFactory)this, Float.TYPE));
        this.addMetadataClass("D", new MetadataClass((MetadataFactory)this, Double.TYPE));
        this.addMetadataClass("C", new MetadataClass((MetadataFactory)this, Character.TYPE));
        this.addMetadataClass("B", new MetadataClass((MetadataFactory)this, Byte.TYPE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildClassMetadata(String className) {
        ClassMetadataVisitor visitor = new ClassMetadataVisitor();
        InputStream stream = null;
        try {
            String resourceString = className.replace('.', '/') + ".class";
            stream = this.m_loader.getResourceAsStream(resourceString);
            ClassReader reader = new ClassReader(stream);
            reader.accept(visitor, 0);
        }
        catch (Exception exception) {
            MetadataClass metadataClass = new MetadataClass((MetadataFactory)this, className);
            metadataClass.setIsAccessible(false);
            this.addMetadataClass(metadataClass);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    @Override
    public MetadataClass getMetadataClass(String className) {
        if (className == null) {
            return null;
        }
        if (!this.metadataClassExists(className)) {
            this.buildClassMetadata(className);
        }
        return this.getMetadataClasses().get(className);
    }

    @Override
    public void resolveGenericTypes(MetadataClass child, List<String> genericTypes, MetadataClass parent, MetadataDescriptor descriptor) {
        List<String> parentGenericTypes;
        if (genericTypes != null && (parentGenericTypes = parent.getGenericType()) != null) {
            ArrayList<String> genericParentTemp = new ArrayList<String>(genericTypes);
            genericParentTemp.removeAll(child.getInterfaces());
            int size = genericParentTemp.size();
            int parentIndex = 0;
            for (int index = genericTypes.indexOf(parent.getName()) + 1; index < size; ++index) {
                String actualTypeArgument = genericTypes.get(index);
                if (parentIndex >= parentGenericTypes.size()) break;
                String variable = parentGenericTypes.get(parentIndex);
                parentIndex += 3;
                if (actualTypeArgument.length() == 1) {
                    actualTypeArgument = genericTypes.get(++index);
                    descriptor.addGenericType(variable, descriptor.getGenericType(actualTypeArgument));
                    continue;
                }
                descriptor.addGenericType(variable, actualTypeArgument);
            }
        }
    }

    private static List<String> processDescription(String desc, boolean isGeneric) {
        if (desc == null) {
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (int index = 0; index < desc.length(); ++index) {
            int start;
            char next = desc.charAt(index);
            if (TOKENS.indexOf(next) != -1) continue;
            if (next == 'L') {
                start = ++index;
                next = desc.charAt(index);
                while (TOKENS.indexOf(next) == -1) {
                    next = desc.charAt(++index);
                }
                arguments.add(MetadataAsmFactory.toClassName(desc.substring(start, index)));
                continue;
            }
            if (!isGeneric && PRIMITIVES.indexOf(next) != -1) {
                arguments.add(MetadataAsmFactory.getPrimitiveName(next));
                continue;
            }
            if (next == '[') {
                start = index++;
                next = desc.charAt(index);
                while (next == '[') {
                    next = desc.charAt(++index);
                }
                if (PRIMITIVES.indexOf(next) == -1) {
                    while (next != ';') {
                        next = desc.charAt(++index);
                    }
                    arguments.add(MetadataAsmFactory.toClassName(desc.substring(start, index + 1)));
                    continue;
                }
                arguments.add(desc.substring(start, index + 1));
                continue;
            }
            arguments.add(new String(new char[]{next}));
        }
        return arguments;
    }

    private static String getPrimitiveName(char primitive) {
        if (primitive == 'V') {
            return "void";
        }
        if (primitive == 'I') {
            return "int";
        }
        if (primitive == 'Z') {
            return "boolean";
        }
        if (primitive == 'J') {
            return "long";
        }
        if (primitive == 'F') {
            return "float";
        }
        if (primitive == 'D') {
            return "double";
        }
        if (primitive == 'B') {
            return "byte";
        }
        if (primitive == 'C') {
            return "char";
        }
        if (primitive == 'S') {
            return "short";
        }
        return new String(new char[]{primitive});
    }

    private static String toClassName(String classDescription) {
        if (classDescription == null) {
            return "void";
        }
        return classDescription.replace('/', '.');
    }

    private static Object annotationValue(String description, Object value) {
        if (value instanceof Type) {
            return ((Type)value).getClassName();
        }
        return value;
    }

    class MetadataMethodVisitor
    extends EmptyVisitor {
        private MetadataMethod method;

        public MetadataMethodVisitor(MetadataClass classMetadata, int access, String name, String desc, String signature, String[] exceptions) {
            this.method = new MetadataMethod(MetadataAsmFactory.this, classMetadata);
            this.method.setName(name);
            this.method.setAttributeName(Helper.getAttributeNameFromMethodName(name));
            this.method.setModifiers(access);
            this.method.setGenericType(MetadataAsmFactory.processDescription(desc, true));
            List argumentNames = MetadataAsmFactory.processDescription(signature, false);
            if (argumentNames != null && !argumentNames.isEmpty()) {
                this.method.setReturnType((String)argumentNames.get(argumentNames.size() - 1));
                argumentNames.remove(argumentNames.size() - 1);
                this.method.setParameters(argumentNames);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                return new MetadataAnnotationVisitor(this.method, desc);
            }
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return null;
        }

        public void visitEnd() {
            MetadataClass classMetadata = this.method.getMetadataClass();
            MetadataMethod existing = classMetadata.getMethods().get(this.method.getName());
            if (existing == null) {
                classMetadata.getMethods().put(this.method.getName(), this.method);
            } else {
                while (existing.getNext() != null) {
                    existing = existing.getNext();
                }
                existing.setNext(this.method);
            }
        }
    }

    class MetadataFieldVisitor
    implements FieldVisitor {
        private MetadataField field;

        public MetadataFieldVisitor(MetadataClass classMetadata, int access, String name, String desc, String signature, Object value) {
            this.field = new MetadataField(classMetadata);
            this.field.setModifiers(access);
            this.field.setName(name);
            this.field.setAttributeName(name);
            this.field.setGenericType(MetadataAsmFactory.processDescription(signature, true));
            this.field.setType((String)MetadataAsmFactory.processDescription(desc, false).get(0));
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                return new MetadataAnnotationVisitor(this.field, desc);
            }
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
            this.field.getDeclaringClass().addField(this.field);
        }
    }

    class MetadataAnnotationArrayVisitor
    implements AnnotationVisitor {
        private MetadataAnnotation annotation;
        private String attributeName;
        private List<Object> values;

        public MetadataAnnotationArrayVisitor(MetadataAnnotation annotation, String name) {
            this.annotation = annotation;
            this.attributeName = name;
            this.values = new ArrayList<Object>();
        }

        public void visit(String name, Object value) {
            this.values.add(MetadataAsmFactory.annotationValue(null, value));
        }

        public void visitEnum(String name, String desc, String value) {
            this.values.add(MetadataAsmFactory.annotationValue(desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            MetadataAnnotation mda = new MetadataAnnotation();
            mda.setName((String)MetadataAsmFactory.processDescription(desc, false).get(0));
            this.values.add(mda);
            return new MetadataAnnotationVisitor(mda);
        }

        public AnnotationVisitor visitArray(String name) {
            return null;
        }

        public void visitEnd() {
            this.annotation.addAttribute(this.attributeName, this.values.toArray());
        }
    }

    class MetadataAnnotationVisitor
    implements AnnotationVisitor {
        private MetadataAnnotatedElement element;
        private MetadataAnnotation annotation;

        MetadataAnnotationVisitor(MetadataAnnotatedElement element, String name) {
            this.element = element;
            this.annotation = new MetadataAnnotation();
            this.annotation.setName((String)MetadataAsmFactory.processDescription(name, false).get(0));
        }

        public MetadataAnnotationVisitor(MetadataAnnotation annotation) {
            this.annotation = annotation;
        }

        public void visit(String name, Object value) {
            this.annotation.addAttribute(name, MetadataAsmFactory.annotationValue(null, value));
        }

        public void visitEnum(String name, String desc, String value) {
            this.annotation.addAttribute(name, MetadataAsmFactory.annotationValue(desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            MetadataAnnotation mda = new MetadataAnnotation();
            mda.setName((String)MetadataAsmFactory.processDescription(desc, false).get(0));
            this.annotation.addAttribute(name, mda);
            return new MetadataAnnotationVisitor(mda);
        }

        public AnnotationVisitor visitArray(String name) {
            return new MetadataAnnotationArrayVisitor(this.annotation, name);
        }

        public void visitEnd() {
            if (this.element != null) {
                this.element.addAnnotation(this.annotation);
            }
        }
    }

    public class ClassMetadataVisitor
    implements ClassVisitor {
        private MetadataClass classMetadata;

        ClassMetadataVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String className = MetadataAsmFactory.toClassName(name);
            this.classMetadata = new MetadataClass((MetadataFactory)MetadataAsmFactory.this, className);
            MetadataAsmFactory.this.addMetadataClass(this.classMetadata);
            this.classMetadata.setName(className);
            this.classMetadata.setSuperclassName(MetadataAsmFactory.toClassName(superName));
            this.classMetadata.setModifiers(access);
            this.classMetadata.setGenericType(MetadataAsmFactory.processDescription(signature, true));
            for (String interfaceName : interfaces) {
                this.classMetadata.addInterface(MetadataAsmFactory.toClassName(interfaceName));
            }
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (this.classMetadata.isJDK()) {
                return null;
            }
            return new MetadataFieldVisitor(this.classMetadata, access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.classMetadata.isJDK() || name.indexOf("init>") != -1) {
                return null;
            }
            return new MetadataMethodVisitor(this.classMetadata, access, name, signature, desc, exceptions);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                return new MetadataAnnotationVisitor(this.classMetadata, desc);
            }
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }
    }
}

