/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedStoredProcedureQueryMetadata
extends NamedNativeQueryMetadata {
    private Boolean m_multipleResultSets;
    private Boolean m_returnsResultSet;
    protected Boolean m_callByIndex;
    private List<StoredProcedureParameterMetadata> m_parameters = new ArrayList<StoredProcedureParameterMetadata>();
    private String m_procedureName;

    public NamedStoredProcedureQueryMetadata() {
        super("<named-stored-procedure-query>");
    }

    public NamedStoredProcedureQueryMetadata(String elementName) {
        super(elementName);
    }

    public NamedStoredProcedureQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        for (Object storedProcedureParameter : (Object[])namedStoredProcedureQuery.getAttributeArray("parameters")) {
            this.m_parameters.add(new StoredProcedureParameterMetadata((MetadataAnnotation)storedProcedureParameter, accessor));
        }
        this.m_procedureName = (String)namedStoredProcedureQuery.getAttribute("procedureName");
        this.m_returnsResultSet = (Boolean)namedStoredProcedureQuery.getAttribute("returnsResultSet");
        this.m_multipleResultSets = (Boolean)namedStoredProcedureQuery.getAttribute("multipleResultSets");
        this.m_callByIndex = (Boolean)namedStoredProcedureQuery.getAttribute("callByIndex");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedStoredProcedureQueryMetadata) {
            NamedStoredProcedureQueryMetadata query = (NamedStoredProcedureQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_returnsResultSet, query.getReturnsResultSet())) {
                return false;
            }
            if (!this.valuesMatch(this.m_callByIndex, query.getCallByIndex())) {
                return false;
            }
            if (!this.valuesMatch(this.m_multipleResultSets, query.getMultipleResultSets())) {
                return false;
            }
            if (!this.valuesMatch(this.m_parameters, query.getParameters())) {
                return false;
            }
            return this.valuesMatch(this.m_procedureName, query.getProcedureName());
        }
        return false;
    }

    public Boolean getCallByIndex() {
        return this.m_callByIndex;
    }

    public void setCallByIndex(Boolean callByIndex) {
        this.m_callByIndex = callByIndex;
    }

    public String getProcedureName() {
        return this.m_procedureName;
    }

    public List<StoredProcedureParameterMetadata> getParameters() {
        return this.m_parameters;
    }

    public Boolean getReturnsResultSet() {
        return this.m_returnsResultSet;
    }

    public Boolean getMultipleResultSets() {
        return this.m_multipleResultSets;
    }

    public void setMultipleResultSets(Boolean multipleResultSets) {
        this.m_multipleResultSets = multipleResultSets;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_parameters, accessibleObject);
    }

    @Override
    public void process(AbstractSession session, ClassLoader loader, MetadataProject project) {
        StoredProcedureCall call = new StoredProcedureCall();
        boolean callByIndex = this.m_callByIndex == null ? false : this.m_callByIndex;
        for (StoredProcedureParameterMetadata parameter : this.m_parameters) {
            parameter.process(call, project, callByIndex, false);
        }
        call.setProcedureName(this.m_procedureName);
        call.setReturnsResultSet(this.m_returnsResultSet == null ? false : this.m_returnsResultSet);
        call.setHasMultipleResultSets(this.m_multipleResultSets == null ? false : this.m_multipleResultSets);
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.getResultClass().isVoid()) {
            if (this.hasResultSetMapping(session)) {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), call, hints, loader, session));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(call, hints, loader, session));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), loader), call, hints, loader, session));
        }
    }

    public void setProcedureName(String procedureName) {
        this.m_procedureName = procedureName;
    }

    public void setParameters(List<StoredProcedureParameterMetadata> parameters) {
        this.m_parameters = parameters;
    }

    public void setReturnsResultSet(Boolean returnsResultSet) {
        this.m_returnsResultSet = returnsResultSet;
    }
}

