/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.ProjectHelper;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.internal.xr.XRSessionConfigLoader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;

public class XRServiceFactory {
    public XRServiceAdapter xrService;
    public ClassLoader parentClassLoader;
    public InputStream xrSchemaStream;

    public XRServiceAdapter buildService() {
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public XRServiceAdapter buildService(XRServiceModel xrServiceModel) {
        this.xrService = new XRServiceAdapter();
        this.xrService.setName(xrServiceModel.getName());
        this.xrService.setSessionsFile(xrServiceModel.getSessionsFile());
        this.xrService.setOperations(xrServiceModel.getOperations());
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return this.xrService;
    }

    public void initializeService(ClassLoader parentClassLoader, InputStream xrSchemaStream) {
        this.parentClassLoader = parentClassLoader;
        this.xrSchemaStream = xrSchemaStream;
        this.loadXMLSchema(xrSchemaStream);
        this.logoutSessions();
        this.buildSessions();
        this.customizeSession(this.xrService.orSession, this.xrService.oxSession);
        this.buildDescriptorIndex();
        this.validateOperations();
        this.initializeOperations();
        this.loginSessions();
    }

    public void customizeSession(Session orSession, Session oxSession) {
    }

    public void loadXMLSchema(InputStream xrSchemaStream) {
        SchemaModelProject schemaProject = new SchemaModelProject();
        XMLContext xmlContext = new XMLContext(schemaProject);
        XMLUnmarshaller unmarshaller = xmlContext.createUnmarshaller();
        Schema schema = (Schema)unmarshaller.unmarshal(xrSchemaStream);
        NamespaceResolver nr = schema.getNamespaceResolver();
        String targetNamespace = schema.getTargetNamespace();
        nr.put("ns1", targetNamespace);
        this.xrService.schema = schema;
        this.xrService.schemaNamespace = targetNamespace;
    }

    public void buildSessions() {
        String orSessionKey;
        XRDynamicClassLoader projectLoader = new XRDynamicClassLoader(this.parentClassLoader);
        SessionManager sessionManager = SessionManager.getManager();
        boolean found = false;
        String sessionsFile = this.xrService.sessionsFile == null ? "eclipselink-dbws-sessions.xml" : this.xrService.sessionsFile;
        for (String prefix : Util.META_INF_PATHS) {
            String searchPath = prefix + sessionsFile;
            XRSessionConfigLoader loader = new XRSessionConfigLoader(searchPath);
            loader.setShouldLogin(false);
            try {
                found = loader.load(sessionManager, projectLoader);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (found) break;
        }
        if (!found) {
            throw DBWSException.couldNotLocateFile("eclipselink-dbws-sessions.xml");
        }
        ConcurrentMap sessions = sessionManager.getSessions();
        if (!sessions.containsKey(orSessionKey = this.xrService.name + "-" + "dbws-or-session")) {
            throw DBWSException.couldNotLocateORSessionForService(this.xrService.name);
        }
        this.xrService.orSession = (Session)sessions.get(orSessionKey);
        String oxSessionKey = this.xrService.name + "-" + "dbws-ox-session";
        if (!sessions.containsKey(oxSessionKey)) {
            throw DBWSException.couldNotLocateOXSessionForService(this.xrService.name);
        }
        this.xrService.oxSession = (Session)sessions.get(oxSessionKey);
        ((XMLLogin)this.xrService.oxSession.getDatasourceLogin()).setEqualNamespaceResolvers(false);
        ProjectHelper.fixOROXAccessors(this.xrService.orSession.getProject(), this.xrService.oxSession.getProject());
        this.xrService.xmlContext = new XMLContext(this.xrService.oxSession.getProject());
        this.xrService.oxSession = this.xrService.xmlContext.getSession(0);
    }

    public void loginSessions() {
        ((DatabaseSession)this.xrService.orSession).login();
    }

    public void buildDescriptorIndex() {
        for (XMLDescriptor xMLDescriptor : this.xrService.oxSession.getProject().getOrderedDescriptors()) {
            String elementNameNS;
            QName elementName;
            String context;
            XMLSchemaReference schemaReference = xMLDescriptor.getSchemaReference();
            if (schemaReference == null || schemaReference.getType() != 1 || (context = schemaReference.getSchemaContext()) == null || context.lastIndexOf(47) != 0 || (elementName = this.resolveName(elementNameNS = context.substring(1), xMLDescriptor.getNamespaceResolver())) == null) continue;
            this.xrService.descriptorsByQName.put(elementName, xMLDescriptor);
        }
    }

    public void validateOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.validate(this.xrService);
        }
    }

    public void initializeOperations() {
        for (Operation operation : this.xrService.getOperationsList()) {
            operation.initialize(this.xrService);
        }
    }

    protected void logoutSessions() {
        String orSessionName;
        SessionManager manager = SessionManager.getManager();
        ConcurrentMap sessions = manager.getSessions();
        Session orSession = (Session)sessions.remove(orSessionName = this.xrService.name + "-" + "dbws-or-session");
        if (orSession != null && orSession.isConnected()) {
            ((DatabaseSession)orSession).logout();
        }
        String oxSessionName = this.xrService.name + "-" + "dbws-ox-session";
        sessions.remove(oxSessionName);
        this.xrService.orSession = null;
        this.xrService.oxSession = null;
    }

    protected QName resolveName(String name, NamespaceResolver ns) {
        if (ns == null) {
            return null;
        }
        if ("any".equals(name)) {
            return XMLConstants.ANY_QNAME;
        }
        int index = name.indexOf(58);
        if (index != -1) {
            String uri = ns.resolveNamespacePrefix(name.substring(0, index));
            return new QName(uri, name.substring(index + 1));
        }
        if (ns.getDefaultNamespaceURI() != null) {
            return new QName(ns.getDefaultNamespaceURI(), name);
        }
        String uri = ns.resolveNamespacePrefix("xmlns");
        return new QName(uri, name);
    }

    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder db = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return db;
    }

    public static Transformer getTransformer() {
        Transformer transformer = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        return transformer;
    }
}

